/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class SimplePrimitiveId
implements PrimitiveId,
Serializable {
    private final long id;
    private final OsmPrimitiveType type;

    public SimplePrimitiveId(long l, OsmPrimitiveType osmPrimitiveType) {
        this.id = l;
        this.type = osmPrimitiveType;
    }

    public OsmPrimitiveType getType() {
        return this.type;
    }

    public long getUniqueId() {
        return this.id;
    }

    public boolean isNew() {
        return this.id <= 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimplePrimitiveId simplePrimitiveId = (SimplePrimitiveId)object;
        if (this.id != simplePrimitiveId.id) {
            return false;
        }
        return !(this.type == null ? simplePrimitiveId.type != null : !this.type.equals((Object)simplePrimitiveId.type));
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.id;
    }

    public static SimplePrimitiveId fromString(String string) {
        Pattern pattern = Pattern.compile("((n(ode)?|w(ay)?|r(el(ation)?)?)/?)(\\d+)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return new SimplePrimitiveId(Long.parseLong(matcher.group(matcher.groupCount())), string.charAt(0) == 'n' ? OsmPrimitiveType.NODE : (string.charAt(0) == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION));
        }
        throw new IllegalArgumentException("The string " + string + " does not match the pattern " + pattern);
    }
}

