/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line", new Object[0]), "alignline", I18n.tr("Move the selected nodes in to a line.", new Object[0]), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Line", new Object[0])), 76, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/AlignInLine"));
    }

    private void nodePairFurthestApart(ArrayList<Node> arrayList, Node[] nodeArray) {
        if (nodeArray.length < 2) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        Node node = null;
        Node node2 = null;
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Node node3 = arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Node node4 = arrayList.get(j);
                double d2 = Math.sqrt(node3.getEastNorth().distance(node4.getEastNorth()));
                if (!(d2 > d)) continue;
                node = node3;
                node2 = node4;
                d = d2;
            }
        }
        nodeArray[0] = node;
        nodeArray[1] = node2;
    }

    private void showWarning() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least three nodes.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
    }

    private static int indexWrap(int n, int n2) {
        if ((n2 %= n) < 0) {
            n2 = n + n2;
        }
        return n2;
    }

    private static Node getNodeRelative(Way way, int n, int n2) {
        int n3 = AlignInLineAction.indexWrap(way.getNodesCount(), n + n2);
        if (way.isClosed() && n + n2 < 0) {
            --n3;
        }
        return way.getNode(n3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<Command> arrayList;
        if (!this.isEnabled()) {
            return;
        }
        Node[] nodeArray = new Node[2];
        ArrayList<Node> arrayList2 = new ArrayList<Node>(AlignInLineAction.getCurrentDataSet().getSelectedNodes());
        Collection<Way> collection = AlignInLineAction.getCurrentDataSet().getSelectedWays();
        ArrayList<Node> arrayList3 = new ArrayList<Node>();
        if (arrayList2.size() == 0 && collection.size() == 1) {
            for (Way way : collection) {
                arrayList3.addAll(way.getNodes());
            }
            this.nodePairFurthestApart(arrayList3, nodeArray);
        } else if (arrayList2.size() >= 3) {
            arrayList3.addAll(arrayList2);
            this.nodePairFurthestApart(arrayList3, nodeArray);
        } else if (arrayList2.size() == 1) {
            arrayList = (Node)arrayList2.iterator().next();
            Way way = null;
            if (collection.size() == 1) {
                way = collection.iterator().next();
                if (!way.containsNode((Node)((Object)arrayList))) {
                    return;
                }
            } else {
                List<Way> list = OsmPrimitive.getFilteredList(((OsmPrimitive)((Object)arrayList)).getReferrers(), Way.class);
                if (list.size() == 1) {
                    way = list.iterator().next();
                }
            }
            if (way == null || way.getNodesCount() < 3) {
                return;
            }
            int n = way.getNodes().indexOf(arrayList);
            if (!(n != 0 && n != way.getNodesCount() - 1 || way.isClosed())) {
                int n2 = n == 0 ? 1 : -1;
                nodeArray[0] = way.getNode(n + n2);
                nodeArray[1] = way.getNode(n + n2 * 2);
            } else {
                nodeArray[0] = AlignInLineAction.getNodeRelative(way, n, 1);
                nodeArray[1] = AlignInLineAction.getNodeRelative(way, n, -1);
            }
            arrayList3.add((Node)((Object)arrayList));
        }
        if (nodeArray[0] == null || nodeArray[1] == null) {
            this.showWarning();
            return;
        }
        arrayList = new ArrayList<Command>(arrayList3.size());
        this.createAlignNodesCommands(nodeArray, arrayList3, arrayList);
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), arrayList));
        Main.map.repaint();
    }

    private void createAlignNodesCommands(Node[] nodeArray, Collection<Node> collection, Collection<Command> collection2) {
        Node node = nodeArray[0];
        Node node2 = nodeArray[1];
        collection.remove(node);
        collection.remove(node2);
        double d = node.getEastNorth().east();
        double d2 = node.getEastNorth().north();
        double d3 = node2.getEastNorth().east();
        double d4 = node2.getEastNorth().north();
        for (Node node3 : collection) {
            double d5;
            double d6;
            double d7 = node3.getEastNorth().east();
            double d8 = node3.getEastNorth().north();
            if (d == d3) {
                d7 = d;
            } else if (d2 == d4) {
                d8 = d2;
            } else {
                d6 = (d4 - d2) / (d3 - d);
                d5 = d2 - d * d6;
                double d9 = -1.0 / d6;
                double d10 = node3.getEastNorth().north() - node3.getEastNorth().east() * d9;
                d7 = (d10 - d5) / (d6 - d9);
                d8 = d6 * d7 + d5;
            }
            d6 = d7 - node3.getEastNorth().east();
            d5 = d8 - node3.getEastNorth().north();
            collection2.add(new MoveCommand(node3, d6, d5));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AlignInLineAction.getCurrentDataSet() != null && !AlignInLineAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

