/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class RequestHandler {
    public static final String globalConfirmationKey = "remotecontrol.always-confirm";
    public static final boolean globalConfirmationDefault = false;
    protected HashMap<String, String> args;
    protected String request;
    protected String content = "OK\r\n";
    protected String contentType = "text/plain";
    protected String myCommand;

    public final void handle() throws RequestHandlerForbiddenException, RequestHandlerBadRequestException, RequestHandlerErrorException {
        this.checkPermission();
        this.checkMandatoryParams();
        this.handleRequest();
    }

    protected abstract void handleRequest() throws RequestHandlerErrorException, RequestHandlerBadRequestException;

    public abstract String getPermissionMessage();

    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    public String[] getMandatoryParams() {
        return null;
    }

    public final void checkPermission() throws RequestHandlerForbiddenException {
        PermissionPrefWithDefault permissionPrefWithDefault = this.getPermissionPref();
        if (permissionPrefWithDefault != null && permissionPrefWithDefault.pref != null && !Main.pref.getBoolean(permissionPrefWithDefault.pref, permissionPrefWithDefault.defaultVal)) {
            System.out.println(permissionPrefWithDefault.message);
            throw new RequestHandlerForbiddenException();
        }
        if (Main.pref.getBoolean(globalConfirmationKey, false) && JOptionPane.showConfirmDialog(Main.parent, "<html>" + this.getPermissionMessage() + "<br>" + I18n.tr("Do you want to allow this?", new Object[0]), I18n.tr("Confirm Remote Control action", new Object[0]), 0) != 0) {
            throw new RequestHandlerForbiddenException();
        }
    }

    public void setUrl(String string) {
        this.request = string;
        this.parseArgs();
    }

    protected void parseArgs() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.request, "&?");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("=");
            if (n <= -1) continue;
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        this.args = hashMap;
    }

    void checkMandatoryParams() throws RequestHandlerBadRequestException {
        String[] stringArray = this.getMandatoryParams();
        if (stringArray == null) {
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = this.args.get(string);
            if (string2 != null && string2.length() != 0) continue;
            bl = true;
            System.out.println("'" + this.myCommand + "' remote control request must have '" + string + "' parameter");
            linkedList.add(string);
        }
        if (bl) {
            throw new RequestHandlerBadRequestException("The following keys are mandatory, but have not been provided: " + Utils.join(", ", linkedList));
        }
    }

    public void setCommand(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        this.myCommand = string;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static class RequestHandlerForbiddenException
    extends RequestHandlerException {
        private static final long serialVersionUID = 2263904699747115423L;
    }

    public static class RequestHandlerBadRequestException
    extends RequestHandlerException {
        public RequestHandlerBadRequestException(String string) {
            super(string);
        }
    }

    public static class RequestHandlerErrorException
    extends RequestHandlerException {
    }

    public static class RequestHandlerException
    extends Exception {
        public RequestHandlerException(String string) {
            super(string);
        }

        public RequestHandlerException() {
        }
    }
}

