/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LanguagePreference
implements PreferenceSetting {
    private JComboBox langCombo;
    private LanguageComboBoxModel model;

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        this.model = new LanguageComboBoxModel();
        this.langCombo = new JComboBox(this.model);
        this.langCombo.setRenderer(new LanguageCellRenderer(this.langCombo.getRenderer()));
        this.model.selectLanguage(Main.pref.get("language"));
        LafPreference lafPreference = preferenceTabbedPane.getSetting(LafPreference.class);
        JPanel jPanel = lafPreference.panel;
        jPanel.add((Component)new JLabel(I18n.tr("Language", new Object[0])), GBC.std().insets(20, 0, 0, 0));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.langCombo, GBC.eol().fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public boolean ok() {
        if (this.langCombo.getSelectedItem() == null) {
            return Main.pref.put("language", null);
        }
        return Main.pref.put("language", ((Locale)this.langCombo.getSelectedItem()).toString());
    }

    private static class LanguageCellRenderer
    extends DefaultListCellRenderer {
        private ListCellRenderer dispatch;

        public LanguageCellRenderer(ListCellRenderer listCellRenderer) {
            this.dispatch = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Locale locale = (Locale)object;
            return this.dispatch.getListCellRendererComponent(jList, locale == null ? I18n.tr("Default (Auto determined)", new Object[0]) : locale.getDisplayName(locale), n, bl, bl2);
        }
    }

    private static class LanguageComboBoxModel
    extends DefaultComboBoxModel {
        private final List<Locale> data = new ArrayList<Locale>();

        public LanguageComboBoxModel() {
            this.data.add(0, null);
            this.data.addAll(Arrays.asList(I18n.getAvailableTranslations()));
        }

        public void selectLanguage(String string) {
            this.setSelectedItem(null);
            if (string != null) {
                for (Locale locale : this.data) {
                    if (locale == null || !locale.toString().equals(string)) continue;
                    this.setSelectedItem(locale);
                    return;
                }
            }
        }

        public Object getElementAt(int n) {
            return this.data.get(n);
        }

        public int getSize() {
            return this.data.size();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new LanguagePreference();
        }
    }
}

