/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.GBC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresetListPanel
extends JPanel {
    public PresetListPanel() {
        super(new GridBagLayout());
    }

    public void updatePresets(int n, int n2, int n3, int n4, Map<String, Map<String, Integer>> map, PresetHandler presetHandler) {
        this.removeAll();
        int n5 = n + n2 + n3 + n4;
        if (n5 == 0) {
            this.setVisible(false);
            return;
        }
        for (TaggingPreset cloneable : TaggingPresetPreference.taggingPresets) {
            if (!(cloneable.types == null || n3 > 0 && cloneable.types.contains((Object)TaggingPreset.PresetType.RELATION) || n > 0 && cloneable.types.contains((Object)TaggingPreset.PresetType.NODE) || n2 + n4 > 0 && cloneable.types.contains((Object)TaggingPreset.PresetType.WAY)) && (n4 <= 0 || !cloneable.types.contains((Object)TaggingPreset.PresetType.CLOSEDWAY)) || !cloneable.isShowable()) continue;
            int n6 = 0;
            for (TaggingPreset.Item item : cloneable.data) {
                String string;
                if (item instanceof TaggingPreset.Key) {
                    Map<String, Integer> map2;
                    string = ((TaggingPreset.Key)item).value;
                    String string2 = ((TaggingPreset.Key)item).key;
                    n6 -= 100;
                    if (string2 == null || !map.containsKey(string2) || (map2 = map.get(string2)).size() != 1 || string == null || !map2.containsKey(string) || map2.get(string) != n5) continue;
                    n6 += 101;
                    continue;
                }
                string = null;
                if (item instanceof TaggingPreset.Text && ((TaggingPreset.Text)item).required) {
                    string = ((TaggingPreset.Text)item).key;
                } else if (item instanceof TaggingPreset.Combo && ((TaggingPreset.Combo)item).required) {
                    string = ((TaggingPreset.Combo)item).key;
                } else if (item instanceof TaggingPreset.Check && ((TaggingPreset.Check)item).required) {
                    string = ((TaggingPreset.Check)item).key;
                }
                if (string == null) continue;
                if (map.get(string) != null) {
                    ++n6;
                    continue;
                }
                n6 -= 100;
            }
            if (n6 <= 0) continue;
            JLabel jLabel = new JLabel(cloneable.getName() + " \u2026");
            jLabel.setIcon((Icon)cloneable.getValue("SmallIcon"));
            jLabel.addMouseListener(new PresetLabelML(jLabel, cloneable, presetHandler));
            this.add((Component)jLabel, GBC.eol().fill(2));
        }
        if (this.getComponentCount() > 0) {
            this.setVisible(true);
            int n7 = this.getComponentCount() * this.getComponent(0).getHeight();
            Dimension dimension = new Dimension(this.getWidth(), n7);
            this.setMaximumSize(dimension);
            this.setMinimumSize(dimension);
        } else {
            this.setVisible(false);
        }
    }

    private static class PresetLabelML
    implements MouseListener {
        final JLabel label;
        final Font hover;
        final Font normal;
        final TaggingPreset tag;
        final PresetHandler presetHandler;

        PresetLabelML(JLabel jLabel, TaggingPreset taggingPreset, PresetHandler presetHandler) {
            this.label = jLabel;
            jLabel.setCursor(new Cursor(12));
            this.normal = this.label.getFont();
            this.hover = this.normal.deriveFont(Collections.singletonMap(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED));
            this.tag = taggingPreset;
            this.presetHandler = presetHandler;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Collection<OsmPrimitive> collection = this.tag.createSelection(this.presetHandler.getSelection());
            if (collection == null || collection.isEmpty()) {
                return;
            }
            int n = this.tag.showDialog(collection, false);
            if (n == 1) {
                this.presetHandler.updateTags(this.tag.getChangedTags());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.label.setFont(this.hover);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.label.setFont(this.normal);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PresetHandler {
        public Collection<OsmPrimitive> getSelection();

        public void updateTags(List<Tag> var1);
    }
}

