/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SplashScreen
extends JFrame {
    private SplashScreenProgressRenderer progressRenderer;
    private SwingRenderingProgressMonitor progressMonitor;

    public SplashScreen() {
        this.setUndecorated(true);
        JPanel jPanel = (JPanel)this.getContentPane();
        EtchedBorder etchedBorder = new EtchedBorder(1, Color.white, Color.gray);
        jPanel.setBorder(etchedBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 2, 10));
        jPanel.add(jPanel2);
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ImageProvider.get("logo.png"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        jLabel2.setFont(new Font("Helvetica", 1, 20));
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(I18n.tr("Version {0}", Version.getInstance().getVersionString()));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 5, 0);
        jPanel2.add((Component)jSeparator, gridBagConstraints);
        this.progressRenderer = new SplashScreenProgressRenderer();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel2.add((Component)this.progressRenderer, gridBagConstraints);
        this.progressMonitor = new SwingRenderingProgressMonitor(this.progressRenderer);
        this.pack();
        this.setLocationRelativeTo(null);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SplashScreen.this.setVisible(false);
            }
        });
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private static class SplashScreenProgressRenderer
    extends JPanel
    implements ProgressRenderer {
        private JLabel lblTaskTitle;
        private JLabel lblCustomText;
        private JProgressBar progressBar;
        private static final int MAX_NUMBER_OF_MESSAGES = 3;
        private LinkedList<String> messages = new LinkedList<String>(Arrays.asList("", "", ""));
        private long time = System.currentTimeMillis();

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.lblTaskTitle = new JLabel(" ");
            this.add((Component)this.lblTaskTitle, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.lblCustomText = new JLabel(" "){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    if (dimension.width < 600) {
                        dimension.width = 600;
                    }
                    dimension.height *= 3;
                    return dimension;
                }
            };
            this.add((Component)this.lblCustomText, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.progressBar = new JProgressBar(0);
            this.add((Component)this.progressBar, gridBagConstraints);
        }

        public SplashScreenProgressRenderer() {
            this.build();
        }

        public void setCustomText(String string) {
            if (string.isEmpty()) {
                string = " ";
            }
            this.lblCustomText.setText(string);
            this.repaint();
        }

        public void setIndeterminate(boolean bl) {
            this.progressBar.setIndeterminate(bl);
            this.repaint();
        }

        public void setMaximum(int n) {
            this.progressBar.setMaximum(n);
            this.repaint();
        }

        public void setTaskTitle(String string) {
            while (this.messages.size() >= 3) {
                this.messages.removeFirst();
            }
            long l = System.currentTimeMillis();
            String string2 = this.messages.getLast();
            if (!string2.isEmpty()) {
                this.messages.removeLast();
                this.messages.add(I18n.tr("{0} ({1} ms)", string2, Long.toString(l - this.time)));
            }
            this.time = l;
            if (!string.isEmpty()) {
                this.messages.add(string);
            }
            String string3 = "";
            int n = 0;
            for (String string4 : this.messages) {
                string3 = string3 + "<p class=\"entry" + ++n + "\">" + string4 + "</p>";
            }
            this.lblTaskTitle.setText("<html><style>.entry1{color:#CCCCCC;}.entry2{color:#999999;}.entry3{color:#000000;}</style>" + string3 + "</html>");
            this.repaint();
        }

        public void setValue(int n) {
            this.progressBar.setValue(n);
            this.repaint();
        }
    }
}

