/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTaskList {
    private List<DownloadTask> osmTasks = new LinkedList<DownloadTask>();
    private List<Future<?>> osmTaskFutures = new LinkedList();
    private ProgressMonitor progressMonitor;

    public Future<?> download(boolean bl, List<Rectangle2D> list, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (bl) {
            OsmDataLayer osmDataLayer = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(osmDataLayer);
            Main.map.mapView.setActiveLayer(osmDataLayer);
        }
        progressMonitor.beginTask(null, list.size());
        int n = 0;
        for (Rectangle2D rectangle2D : list) {
            DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
            ProgressMonitor progressMonitor2 = progressMonitor.createSubTaskMonitor(1, false);
            progressMonitor2.setCustomText(I18n.tr("Download {0} of {1} ({2} left)", ++n, list.size(), list.size() - n));
            Future<?> future = downloadOsmTask.download(false, new Bounds(rectangle2D), progressMonitor2);
            this.osmTaskFutures.add(future);
            this.osmTasks.add(downloadOsmTask);
        }
        progressMonitor.addCancelListener(new ProgressMonitor.CancelListener(){

            public void operationCanceled() {
                for (DownloadTask downloadTask : DownloadOsmTaskList.this.osmTasks) {
                    downloadTask.cancel();
                }
            }
        });
        return Main.worker.submit(new PostDownloadProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> download(boolean bl, Collection<Area> collection, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Updating data", new Object[0]));
        try {
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>(collection.size());
            for (Area area : collection) {
                arrayList.add(area.getBounds2D());
            }
            Future<?> future = this.download(bl, (List<Rectangle2D>)arrayList, progressMonitor.createSubTaskMonitor(-1, false));
            return future;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected Set<OsmPrimitive> getCompletePrimitives(DataSet dataSet) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (osmPrimitive.isIncomplete() || osmPrimitive.isNew()) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    protected void updatePotentiallyDeletedPrimitives(Set<OsmPrimitive> set) {
        final ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : set) {
            if (osmPrimitive == null) continue;
            arrayList.add(osmPrimitive);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UpdateSelectionAction().updatePrimitives(arrayList);
            }
        });
    }

    protected void handlePotentiallyDeletedPrimitives(Set<OsmPrimitive> set) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Check on the server", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to check whether objects in your local dataset are deleted on the server", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Ignore", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort and to resume editing", new Object[0]), null)};
        String string = "<html>" + I18n.trn("There is {0} object in your local dataset which might be deleted on the server. If you later try to delete or update this the server is likely to report a conflict.", "There are {0} objects in your local dataset which might be deleted on the server. If you later try to delete or update them the server is likely to report a conflict.", set.size(), set.size()) + "<br>" + I18n.trn("Click <strong>{0}</strong> to check the state of this object on the server.", "Click <strong>{0}</strong> to check the state of these objects on the server.", set.size(), buttonSpecArray[0].text) + "<br>" + I18n.tr("Click <strong>{0}</strong> to ignore.</html>", buttonSpecArray[1].text);
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Deleted or moved objects", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Action/UpdateData#SyncPotentiallyDeletedObjects"));
        if (n != 0) {
            return;
        }
        this.updatePotentiallyDeletedPrimitives(set);
    }

    public Set<OsmPrimitive> getDownloadedPrimitives() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (DownloadTask downloadTask : this.osmTasks) {
            DataSet dataSet;
            if (!(downloadTask instanceof DownloadOsmTask) || (dataSet = ((DownloadOsmTask)downloadTask).getDownloadedData()) == null) continue;
            hashSet.addAll(dataSet.allPrimitives());
        }
        return hashSet;
    }

    class PostDownloadProcessor
    implements Runnable {
        PostDownloadProcessor() {
        }

        public void run() {
            Object object3;
            Object object22;
            DownloadOsmTaskList.this.progressMonitor.finishTask();
            for (Object object22 : DownloadOsmTaskList.this.osmTaskFutures) {
                try {
                    object22.get();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (Object object3 : DownloadOsmTaskList.this.osmTasks) {
                linkedHashSet.addAll(object3.getErrorObjects());
            }
            if (!linkedHashSet.isEmpty()) {
                object22 = new StringBuffer();
                object3 = linkedHashSet.iterator();
                while (object3.hasNext()) {
                    Object e = object3.next();
                    if (e instanceof String) {
                        ((StringBuffer)object22).append("<li>").append(e).append("</li>").append("<br>");
                        continue;
                    }
                    if (!(e instanceof Exception)) continue;
                    ((StringBuffer)object22).append("<li>").append(ExceptionUtil.explainException((Exception)e)).append("</li>").append("<br>");
                }
                ((StringBuffer)object22).insert(0, "<ul>");
                ((StringBuffer)object22).append("</ul>");
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("The following errors occurred during mass download: {0}", ((StringBuffer)object22).toString()) + "</html>", I18n.tr("Errors during download", new Object[0]), 0);
                return;
            }
            for (Object object3 : DownloadOsmTaskList.this.osmTasks) {
                Object object4;
                if (!(object3 instanceof DownloadOsmTask) || !((AbstractDownloadTask)(object4 = (DownloadOsmTask)object3)).isCanceled() && !((AbstractDownloadTask)object4).isFailed()) continue;
                return;
            }
            object22 = Main.map.mapView.getEditLayer();
            if (object22 != null) {
                object3 = DownloadOsmTaskList.this.getCompletePrimitives(((OsmDataLayer)object22).data);
                for (DownloadTask downloadTask : DownloadOsmTaskList.this.osmTasks) {
                    DataSet dataSet;
                    if (!(downloadTask instanceof DownloadOsmTask) || (dataSet = ((DownloadOsmTask)downloadTask).getDownloadedData()) == null) continue;
                    for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
                        object3.remove(osmPrimitive);
                    }
                }
                if (!object3.isEmpty()) {
                    DownloadOsmTaskList.this.handlePotentiallyDeletedPrimitives((Set<OsmPrimitive>)object3);
                }
            }
        }
    }
}

