/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmChangeTask
extends DownloadOsmTask {
    @Override
    public boolean acceptsUrl(String string) {
        return string != null && string.matches("http://.*/api/0.6/changeset/\\p{Digit}+/download");
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, (OsmServerReader)new OsmServerLocationReader(string), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoryListener
    implements HistoryDataSetListener {
        private final List<Pair<OsmPrimitive, Date>> toMonitor;

        public HistoryListener(List<Pair<OsmPrimitive, Date>> list) {
            this.toMonitor = list;
        }

        @Override
        public void historyUpdated(HistoryDataSet historyDataSet, PrimitiveId primitiveId) {
            Iterator<Pair<OsmPrimitive, Date>> iterator = this.toMonitor.iterator();
            while (iterator.hasNext()) {
                HistoryOsmPrimitive historyOsmPrimitive;
                Pair<OsmPrimitive, Date> pair = iterator.next();
                History history = historyDataSet.getHistory(((OsmPrimitive)pair.a).getPrimitiveId());
                if (history == null || pair.b == null || (historyOsmPrimitive = history.getByDate((Date)pair.b)) == null) continue;
                PrimitiveData primitiveData = null;
                switch (((OsmPrimitive)pair.a).getType()) {
                    case NODE: {
                        primitiveData = new NodeData();
                        ((NodeData)primitiveData).setCoor(((HistoryNode)historyOsmPrimitive).getCoords());
                        break;
                    }
                    case WAY: {
                        primitiveData = new WayData();
                        ((WayData)primitiveData).setNodes(((HistoryWay)historyOsmPrimitive).getNodes());
                        break;
                    }
                    case RELATION: {
                        primitiveData = new RelationData();
                        ((RelationData)primitiveData).setMembers(((HistoryRelation)historyOsmPrimitive).getMembers());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                primitiveData.setUser(historyOsmPrimitive.getUser());
                primitiveData.setVisible(historyOsmPrimitive.isVisible());
                primitiveData.setTimestamp(historyOsmPrimitive.getTimestamp());
                primitiveData.setKeys(historyOsmPrimitive.getTags());
                primitiveData.setOsmId(historyOsmPrimitive.getChangesetId(), (int)historyOsmPrimitive.getVersion());
                ((OsmPrimitive)pair.a).load(primitiveData);
                iterator.remove();
            }
            if (this.toMonitor.isEmpty()) {
                historyDataSet.removeHistoryDataSetListener(this);
                Main.map.repaint();
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet historyDataSet) {
        }
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(bl, osmServerReader, progressMonitor);
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
                ArrayList<Pair<OsmPrimitive, Date>> arrayList2 = new ArrayList<Pair<OsmPrimitive, Date>>();
                for (OsmPrimitive osmPrimitive : DownloadOsmChangeTask.this.downloadedData.allNonDeletedPrimitives()) {
                    if (!osmPrimitive.isIncomplete()) continue;
                    Date date = null;
                    for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                        if (osmPrimitive2.isTimestampEmpty()) continue;
                        date = osmPrimitive2.getTimestamp();
                        break;
                    }
                    arrayList.add(osmPrimitive);
                    arrayList2.add(new Pair<OsmPrimitive, Date>(osmPrimitive, date));
                }
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                HistoryDataSet.getInstance().addHistoryDataSetListener(new HistoryListener(arrayList2));
                Main.worker.submit(new HistoryLoadTask().add(arrayList));
            }
            catch (Exception exception) {
                DownloadOsmChangeTask.this.rememberException(exception);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }
}

