/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ViewportFollowToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected;

    public ViewportFollowToggleAction() {
        super(I18n.tr("Viewport Following", new Object[0]), "viewport-follow", I18n.tr("Enable/disable automatic moving of the map view to last placed node", new Object[0]), Shortcut.registerShortcut("menu:view:viewportfollow", I18n.tr("Toggle Viewport Following", new Object[0]), 70, 2, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/ViewportFollowing"));
        this.selected = false;
        this.notifySelectedState();
    }

    public void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
            buttonModel.setSelected(this.selected);
        }
    }

    public void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == this.selected) continue;
            buttonModel.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        Main.map.mapView.viewportFollowing = this.selected = !this.selected;
        this.notifySelectedState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState();
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.map != null && Main.main.getEditLayer() != null);
    }
}

