/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shortcut {
    public static final int SHIFT_DEFAULT = 1;
    private String shortText;
    private String longText;
    private int requestedKey;
    private int requestedGroup;
    private int assignedKey;
    private int assignedModifier;
    private boolean assignedDefault;
    private boolean assignedUser;
    private boolean automatic;
    private boolean reset;
    private static Map<String, Shortcut> shortcuts = new LinkedHashMap<String, Shortcut>();
    private static Map<Integer, Integer> groups = new HashMap<Integer, Integer>();
    public static final int GROUP_NONE = 0;
    public static final int GROUP_HOTKEY = 1;
    public static final int GROUP_MENU = 2;
    public static final int GROUP_EDIT = 3;
    public static final int GROUP_LAYER = 4;
    public static final int GROUP_DIRECT = 5;
    public static final int GROUP_MNEMONIC = 6;
    public static final int GROUP__MAX = 7;
    public static final int GROUP_RESERVED = 1000;
    public static final int GROUPS_DEFAULT = 0;
    public static final int GROUPS_ALT1 = 7;
    public static final int GROUPS_ALT2 = 14;
    private static boolean initdone = false;

    private Shortcut(String string, String string2, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.shortText = string;
        this.longText = string2;
        this.requestedKey = n;
        this.requestedGroup = n2;
        this.assignedKey = n3;
        this.assignedModifier = n4;
        this.assignedDefault = bl;
        this.assignedUser = bl2;
        this.automatic = false;
        this.reset = false;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getLongText() {
        return this.longText;
    }

    private void setLongText(String string) {
        this.longText = string;
    }

    private int getRequestedKey() {
        return this.requestedKey;
    }

    public int getRequestedGroup() {
        return this.requestedGroup;
    }

    public int getAssignedKey() {
        return this.assignedKey;
    }

    public int getAssignedModifier() {
        return this.assignedModifier;
    }

    public boolean getAssignedDefault() {
        return this.assignedDefault;
    }

    public boolean getAssignedUser() {
        return this.assignedUser;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public boolean isChangeable() {
        return !this.automatic && !this.shortText.equals("core:none");
    }

    private boolean getReset() {
        return this.reset;
    }

    public void setAutomatic() {
        this.automatic = true;
    }

    public void setAssignedModifier(int n) {
        this.assignedModifier = n;
    }

    public void setAssignedKey(int n) {
        this.assignedKey = n;
    }

    public void setAssignedUser(boolean bl) {
        boolean bl2 = this.reset = !this.assignedUser && bl;
        if (bl) {
            this.assignedDefault = false;
        }
        this.assignedUser = bl;
    }

    public KeyStroke getKeyStroke() {
        if (this.assignedModifier != -1) {
            return KeyStroke.getKeyStroke(this.assignedKey, this.assignedModifier);
        }
        return null;
    }

    private boolean isSame(int n, int n2) {
        return n == this.assignedKey && n2 == this.assignedModifier && this.assignedModifier != groups.get(0);
    }

    private Shortcut(String string) {
        String[] stringArray = string.split(";");
        this.shortText = stringArray[0];
        this.longText = stringArray[1];
        this.requestedKey = Integer.parseInt(stringArray[2]);
        this.requestedGroup = Integer.parseInt(stringArray[3]);
        this.assignedKey = Integer.parseInt(stringArray[4]);
        this.assignedModifier = Integer.parseInt(stringArray[5]);
        this.assignedDefault = Boolean.parseBoolean(stringArray[6]);
        this.assignedUser = Boolean.parseBoolean(stringArray[7]);
    }

    private String asPrefString() {
        return this.shortText + ";" + this.longText + ";" + this.requestedKey + ";" + this.requestedGroup + ";" + this.assignedKey + ";" + this.assignedModifier + ";" + this.assignedDefault + ";" + this.assignedUser;
    }

    private boolean isSame(Shortcut shortcut) {
        return this.assignedKey == shortcut.assignedKey && this.assignedModifier == shortcut.assignedModifier;
    }

    public void setMnemonic(JMenu jMenu) {
        if (this.requestedGroup == 6 && this.assignedModifier == groups.get(this.requestedGroup + 0) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            jMenu.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setMnemonic(AbstractButton abstractButton) {
        if (this.requestedGroup == 6 && this.assignedModifier == groups.get(this.requestedGroup + 0) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            abstractButton.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public String getKeyText() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public String toString() {
        return this.getKeyText();
    }

    private static Shortcut findShortcut(int n, int n2) {
        if (n2 == groups.get(0)) {
            return null;
        }
        for (Shortcut shortcut : shortcuts.values()) {
            if (!shortcut.isSame(n, n2)) continue;
            return shortcut;
        }
        return null;
    }

    public static List<Shortcut> listAll() {
        ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
        for (Shortcut shortcut : shortcuts.values()) {
            if (shortcut.shortText.equals("core:none")) continue;
            arrayList.add(shortcut);
        }
        return arrayList;
    }

    private static Shortcut findRandomShortcut(String string, String string2, int n, int n2) {
        int[] nArray;
        for (int n3 : nArray = new int[]{groups.get(n2 + 0), groups.get(n2 + 7), groups.get(n2 + 14)}) {
            for (int i = 65; i < 90; ++i) {
                if (Shortcut.findShortcut(i, n3) != null) continue;
                return new Shortcut(string, string2, n, n2, i, n3, false, false);
            }
        }
        return new Shortcut(string, string2, n, n2, n, groups.get(0), false, false);
    }

    private static void doInit() {
        Shortcut shortcut;
        int n;
        if (initdone) {
            return;
        }
        initdone = true;
        if (Main.pref.get("shortcut.groups.configured", null) == null) {
            Main.platform.initShortcutGroups();
            Main.pref.put("shortcut.groups.configured", true);
        }
        for (n = 0; n < 35; ++n) {
            groups.put(n, Main.pref.getInteger("shortcut.groups." + n, -1));
        }
        Main.platform.initSystemShortcuts();
        n = 0;
        String string = Main.pref.get("shortcut.shortcut." + n, null);
        while (string != null) {
            shortcut = new Shortcut(string);
            if (shortcut.getAssignedUser()) {
                Shortcut.registerShortcut(shortcut);
            }
            string = Main.pref.get("shortcut.shortcut." + ++n, null);
        }
        n = 0;
        string = Main.pref.get("shortcut.shortcut." + n, null);
        while (string != null) {
            shortcut = new Shortcut(string);
            if (!shortcut.getAssignedUser() && shortcut.getAssignedDefault()) {
                Shortcut.registerShortcut(shortcut);
            }
            string = Main.pref.get("shortcut.shortcut." + ++n, null);
        }
        n = 0;
        string = Main.pref.get("shortcut.shortcut." + n, null);
        while (string != null) {
            shortcut = new Shortcut(string);
            if (!shortcut.getAssignedUser() && !shortcut.getAssignedDefault()) {
                Shortcut.registerShortcut(shortcut);
            }
            string = Main.pref.get("shortcut.shortcut." + ++n, null);
        }
    }

    public static boolean savePrefs() {
        boolean bl = false;
        int n = 0;
        for (Shortcut shortcut : shortcuts.values()) {
            if (shortcut.getAutomatic() || shortcut.getReset() || !shortcut.getAssignedUser()) continue;
            bl |= Main.pref.put("shortcut.shortcut." + n, shortcut.asPrefString());
            ++n;
        }
        return bl |= Main.pref.put("shortcut.shortcut." + n, "");
    }

    private static void registerShortcut(Shortcut shortcut) {
        if (shortcut.getAssignedUser() && Shortcut.findShortcut(shortcut.getAssignedKey(), shortcut.getAssignedModifier()) == null) {
            shortcuts.put(shortcut.getShortText(), shortcut);
        } else {
            Shortcut.registerShortcut(shortcut.getShortText(), shortcut.getLongText(), shortcut.getRequestedKey(), shortcut.getRequestedGroup(), shortcut.getAssignedModifier(), shortcut);
        }
    }

    public static Shortcut registerSystemShortcut(String string, String string2, int n, int n2) {
        if (shortcuts.containsKey(string)) {
            return shortcuts.get(string);
        }
        Shortcut shortcut = Shortcut.findShortcut(n, n2);
        if (shortcut != null) {
            System.err.println("CONFLICT WITH SYSTEM KEY " + string);
            return null;
        }
        shortcut = new Shortcut(string, string2, n, 1000, n, n2, true, false);
        shortcuts.put(string, shortcut);
        return shortcut;
    }

    public static Shortcut registerShortcut(String string, String string2, int n, int n2, int n3) {
        return Shortcut.registerShortcut(string, string2, n, n2, n3, null);
    }

    public static Shortcut registerShortcut(String string, String string2, int n, int n2) {
        return Shortcut.registerShortcut(string, string2, n, n2, null, null);
    }

    private static Shortcut registerShortcut(String string, String string2, int n, int n2, Integer n3, Shortcut shortcut) {
        Shortcut.doInit();
        if (shortcuts.containsKey(string)) {
            Shortcut shortcut2 = shortcuts.get(string);
            shortcut2.setLongText(string2);
            return shortcut2;
        }
        Integer n4 = groups.get(n2 + 0);
        if (n3 != null) {
            n4 = n3 == 1 ? Integer.valueOf(n4 | 0x40) : n3;
        } else if (n4 == null) {
            n4 = groups.get(0);
        }
        Shortcut shortcut3 = null;
        Shortcut shortcut4 = Shortcut.findShortcut(n, n4);
        if (shortcut4 != null) {
            shortcut3 = shortcut4;
            n4 = groups.get(n2 + 7);
            if (n4 == null) {
                n4 = groups.get(0);
            }
            if ((shortcut4 = Shortcut.findShortcut(n, n4)) != null) {
                n4 = groups.get(n2 + 14);
                if (n4 == null) {
                    n4 = groups.get(0);
                }
                shortcut4 = (shortcut4 = Shortcut.findShortcut(n, n4)) != null ? Shortcut.findRandomShortcut(string, string2, n, n2) : new Shortcut(string, string2, n, n2, n, n4, false, false);
            } else {
                shortcut4 = new Shortcut(string, string2, n, n2, n, n4, false, false);
            }
            if (shortcut != null && !shortcut.isSame(shortcut4)) {
                Shortcut.displayWarning(shortcut3, shortcut4, string, string2);
            } else if (shortcut == null) {
                System.out.println("Silent shortcut conflict: '" + string + "' moved by '" + shortcut3.getShortText() + "' to '" + shortcut4.getKeyText() + "'.");
            }
        } else {
            shortcut4 = new Shortcut(string, string2, n, n2, n, n4, true, false);
        }
        shortcuts.put(string, shortcut4);
        return shortcut4;
    }

    private static void displayWarning(Shortcut shortcut, Shortcut shortcut2, String string, String string2) {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Setting the keyboard shortcut ''{0}'' for the action ''{1}'' ({2}) failed\nbecause the shortcut is already taken by the action ''{3}'' ({4}).\n\n", shortcut.getKeyText(), string2, string, shortcut.getLongText(), shortcut.getShortText()) + (shortcut2.getKeyText().equals("") ? I18n.tr("This action will have no shortcut.\n\n", new Object[0]) : I18n.tr("Using the shortcut ''{0}'' instead.\n\n", shortcut2.getKeyText())) + I18n.tr("(Hint: You can edit the shortcuts in the preferences.)", new Object[0]), I18n.tr("Error", new Object[0]), 0);
    }

    public static KeyStroke getCopyKeyStroke() {
        Shortcut shortcut = shortcuts.get("system:copy");
        if (shortcut == null) {
            return null;
        }
        return shortcut.getKeyStroke();
    }

    public static KeyStroke getPasteKeyStroke() {
        Shortcut shortcut = shortcuts.get("system:paste");
        if (shortcut == null) {
            return null;
        }
        return shortcut.getKeyStroke();
    }

    public static KeyStroke getCutKeyStroke() {
        Shortcut shortcut = shortcuts.get("system:cut");
        if (shortcut == null) {
            return null;
        }
        return shortcut.getKeyStroke();
    }
}

