/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmUrlToBounds {
    private static final String SHORTLINK_PREFIX = "http://osm.org/go/";
    private static final char[] SHORTLINK_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '@'};

    public static Bounds parse(String string) {
        try {
            if (string.contains("%")) {
                string = URLDecoder.decode(string, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Bounds bounds = OsmUrlToBounds.parseShortLink(string);
        if (bounds != null) {
            return bounds;
        }
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        String[] stringArray = string.substring(n + 1).split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            int n2 = string2.indexOf(61);
            if (n2 == -1) continue;
            hashMap.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        try {
            if (hashMap.containsKey("bbox")) {
                String[] numberFormatException = ((String)hashMap.get("bbox")).split(",");
                bounds = new Bounds(new LatLon(Double.parseDouble(numberFormatException[1]), Double.parseDouble(numberFormatException[0])), new LatLon(Double.parseDouble(numberFormatException[3]), Double.parseDouble(numberFormatException[2])));
            } else if (hashMap.containsKey("minlat")) {
                String nullPointerException = (String)hashMap.get("minlat");
                Double d = Double.parseDouble(nullPointerException);
                String arrayIndexOutOfBoundsException = hashMap.get("minlon");
                Double d2 = Double.parseDouble(arrayIndexOutOfBoundsException);
                String string3 = hashMap.get("maxlat");
                Double d3 = Double.parseDouble(string3);
                String string4 = hashMap.get("maxlon");
                Double d4 = Double.parseDouble(string4);
                bounds = new Bounds(new LatLon(d, d2), new LatLon(d3, d4));
            } else {
                bounds = OsmUrlToBounds.positionToBounds(OsmUrlToBounds.parseDouble(hashMap, "lat"), OsmUrlToBounds.parseDouble(hashMap, "lon"), Integer.parseInt(hashMap.get("zoom")));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return bounds;
    }

    private static double parseDouble(HashMap<String, String> hashMap, String string) {
        if (hashMap.containsKey(string)) {
            return Double.parseDouble(hashMap.get(string));
        }
        return Double.parseDouble(hashMap.get("m" + string));
    }

    private static Bounds parseShortLink(String string) {
        if (!string.startsWith(SHORTLINK_PREFIX)) {
            return null;
        }
        String string2 = string.substring(SHORTLINK_PREFIX.length());
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (int i = 0; i < SHORTLINK_CHARS.length; ++i) {
            hashMap.put(Character.valueOf(SHORTLINK_CHARS[i]), i);
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        for (char c : string2.toCharArray()) {
            if (hashMap.containsKey(Character.valueOf(c))) {
                int n3 = (Integer)hashMap.get(Character.valueOf(c));
                for (int i = 0; i < 3; ++i) {
                    l <<= 1;
                    if ((n3 & 0x20) != 0) {
                        l |= 1L;
                    }
                    l2 <<= 1;
                    if (((n3 <<= 1) & 0x20) != 0) {
                        l2 |= 1L;
                    }
                    n3 <<= 1;
                }
                n += 3;
                continue;
            }
            --n2;
        }
        return OsmUrlToBounds.positionToBounds((double)(l2 <<= 32 - n) * 180.0 / 4.294967296E9 - 90.0, (double)(l <<= 32 - n) * 360.0 / 4.294967296E9 - 180.0, n - 8 - n2 % 3 - 2);
    }

    public static Bounds positionToBounds(double d, double d2, int n) {
        double d3 = 180.0 / Math.pow(2.0, n);
        return new Bounds(new LatLon(d - d3 / 2.0, d2 - d3), new LatLon(d + d3 / 2.0, d2 + d3));
    }

    public static int getZoom(Bounds bounds) {
        int n;
        double d = Math.log(Math.tan(0.7853981633974483 + bounds.getMin().lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d2 = Math.log(Math.tan(0.7853981633974483 + bounds.getMax().lat() / 180.0 * Math.PI / 2.0)) * 180.0 / Math.PI;
        double d3 = Math.max(Math.abs(d2 - d), Math.abs(bounds.getMax().lon() - bounds.getMin().lon()));
        for (n = 0; n <= 20 && !(d3 >= 180.0); d3 *= 2.0, ++n) {
        }
        return n;
    }

    public static String getURL(Bounds bounds) {
        return OsmUrlToBounds.getURL(bounds.getCenter(), OsmUrlToBounds.getZoom(bounds));
    }

    public static String getURL(LatLon latLon, int n) {
        int n2 = (int)Math.pow(10.0, n / 3);
        double d = Math.round(latLon.lat() * (double)n2);
        double d2 = Math.round(latLon.lon() * (double)n2);
        return "http://www.openstreetmap.org/?lat=" + (d /= (double)n2) + "&lon=" + (d2 /= (double)n2) + "&zoom=" + n;
    }
}

