/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.advanced.ListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.ListListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.MapListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.StringEditor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedPreference
implements PreferenceSetting {
    private AllSettingsTableModel model;
    protected List<PrefEntry> data;
    protected List<PrefEntry> displayData;
    protected JTextField txtFilter;

    @Override
    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = preferenceTabbedPane.createPreferenceTab("advanced", I18n.tr("Advanced Preferences", new Object[0]), I18n.tr("Setting Preference entries directly. Use with caution!", new Object[0]), false);
        this.txtFilter = new JTextField();
        JLabel jLabel = new JLabel(I18n.tr("Search: ", new Object[0]));
        jLabel.setLabelFor(this.txtFilter);
        jPanel.add(jLabel);
        jPanel.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.applyFilter();
            }
        });
        Map<String, Preferences.Setting> map = Main.pref.getAllSettings();
        Map<String, Preferences.Setting> map2 = Main.pref.getAllDefaults();
        map.remove("osm-server.password");
        map2.remove("osm-server.password");
        this.prepareData(map, map2);
        this.model = new AllSettingsTableModel();
        this.applyFilter();
        final JTable jTable = new JTable(this.model);
        jTable.putClientProperty("terminateEditOnFocusLost", true);
        jTable.getColumnModel().getColumn(1).setCellRenderer(new SettingCellRenderer());
        jTable.getColumnModel().getColumn(1).setCellEditor(new SettingCellEditor());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        JButton jButton = new JButton(I18n.tr("Add", new Object[0]));
        jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.addPreference(preferenceTabbedPane);
            }
        });
        JButton jButton2 = new JButton(I18n.tr("Edit", new Object[0]));
        jPanel.add((Component)jButton2, GBC.std().insets(5, 5, 5, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.editPreference(preferenceTabbedPane, jTable);
            }
        });
        JButton jButton3 = new JButton(I18n.tr("Reset", new Object[0]));
        jPanel.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.resetPreference(preferenceTabbedPane, jTable);
            }
        });
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AdvancedPreference.this.editPreference(preferenceTabbedPane, jTable);
                }
            }
        });
    }

    private void prepareData(Map<String, Preferences.Setting> map, Map<String, Preferences.Setting> map2) {
        Object object;
        this.data = new ArrayList<PrefEntry>();
        for (Map.Entry<String, Preferences.Setting> entry : map.entrySet()) {
            object = entry.getValue();
            Preferences.Setting setting = map2.get(entry.getKey());
            if (setting == null) {
                setting = object.getNullInstance();
            }
            PrefEntry prefEntry = new PrefEntry(entry.getKey(), (Preferences.Setting)object, setting, false);
            this.data.add(prefEntry);
        }
        for (Map.Entry<String, Preferences.Setting> entry : map2.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            object = new PrefEntry(entry.getKey(), entry.getValue(), entry.getValue(), true);
            this.data.add((PrefEntry)object);
        }
        Collections.sort(this.data);
        this.displayData = new ArrayList<PrefEntry>(this.data);
    }

    private void applyFilter() {
        this.displayData.clear();
        for (PrefEntry prefEntry : this.data) {
            String string = prefEntry.getKey();
            Preferences.Setting setting = prefEntry.getValue();
            String string2 = setting.getValue() == null ? "" : setting.getValue().toString();
            String[] stringArray = this.txtFilter.getText().split("\\s+");
            boolean bl = true;
            String string3 = string.toLowerCase();
            String string4 = string2.toLowerCase();
            for (String string5 : stringArray) {
                if (string3.contains(string5 = string5.toLowerCase()) || string4.contains(string5)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.displayData.add(prefEntry);
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public boolean ok() {
        for (PrefEntry prefEntry : this.data) {
            if (!prefEntry.isChanged()) continue;
            Main.pref.putSetting(prefEntry.getKey(), prefEntry.getValue());
        }
        return false;
    }

    private void resetPreference(PreferenceTabbedPane preferenceTabbedPane, JTable jTable) {
        if (jTable.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        for (int n : jTable.getSelectedRows()) {
            PrefEntry prefEntry = this.displayData.get(n);
            prefEntry.reset();
        }
        this.model.fireTableDataChanged();
    }

    private void addPreference(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JTextField jTextField = new JTextField("", 50);
        jPanel.add((Component)jTextField, GBC.eop().insets(5, 0, 0, 0).fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Select Setting Type:", new Object[0])), GBC.eol().insets(5, 15, 5, 0));
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("Simple", new Object[0]));
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("List", new Object[0]));
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("List of lists", new Object[0]));
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("List of maps", new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        jPanel.add((Component)jRadioButton, GBC.eol());
        jPanel.add((Component)jRadioButton2, GBC.eol());
        jPanel.add((Component)jRadioButton3, GBC.eol());
        jPanel.add((Component)jRadioButton4, GBC.eol());
        jRadioButton.setSelected(true);
        ExtendedDialog extendedDialog = new ExtendedDialog(preferenceTabbedPane, I18n.tr("Add setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        PrefEntry prefEntry = null;
        boolean bl = false;
        if (extendedDialog.getValue() == 1) {
            if (jRadioButton.isSelected()) {
                Preferences.StringSetting stringSetting = new Preferences.StringSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), stringSetting, stringSetting, false);
                StringEditor stringEditor = new StringEditor(preferenceTabbedPane, prefEntry, stringSetting);
                stringEditor.showDialog();
                if (stringEditor.getValue() == 1) {
                    String string = stringEditor.getData();
                    if (!Utils.equal(stringSetting.getValue(), string)) {
                        prefEntry.setValue(new Preferences.StringSetting(string));
                        bl = true;
                    }
                }
            } else if (jRadioButton2.isSelected()) {
                Preferences.ListSetting listSetting = new Preferences.ListSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), listSetting, listSetting, false);
                ListEditor listEditor = new ListEditor(preferenceTabbedPane, prefEntry, listSetting);
                listEditor.showDialog();
                if (listEditor.getValue() == 1) {
                    List<String> list = listEditor.getData();
                    if (!Preferences.equalCollection((Collection)listSetting.getValue(), list)) {
                        prefEntry.setValue(new Preferences.ListSetting(list));
                        bl = true;
                    }
                }
            } else if (jRadioButton3.isSelected()) {
                Preferences.ListListSetting listListSetting = new Preferences.ListListSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), listListSetting, listListSetting, false);
                ListListEditor listListEditor = new ListListEditor(preferenceTabbedPane, prefEntry, listListSetting);
                listListEditor.showDialog();
                if (listListEditor.getValue() == 1) {
                    List<List<String>> list = listListEditor.getData();
                    if (!Preferences.equalArray((Collection)listListSetting.getValue(), list)) {
                        prefEntry.setValue(new Preferences.ListListSetting(list));
                        bl = true;
                    }
                }
            } else if (jRadioButton4.isSelected()) {
                Preferences.MapListSetting mapListSetting = new Preferences.MapListSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), mapListSetting, mapListSetting, false);
                MapListEditor mapListEditor = new MapListEditor(preferenceTabbedPane, prefEntry, mapListSetting);
                mapListEditor.showDialog();
                if (mapListEditor.getValue() == 1) {
                    List<Map<String, String>> list = mapListEditor.getData();
                    if (!Preferences.equalListOfStructs((Collection)mapListSetting.getValue(), list)) {
                        prefEntry.setValue(new Preferences.MapListSetting(list));
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.data.add(prefEntry);
                Collections.sort(this.data);
                this.applyFilter();
            }
        }
    }

    private void editPreference(PreferenceTabbedPane preferenceTabbedPane, JTable jTable) {
        if (jTable.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        PrefEntry prefEntry = (PrefEntry)this.model.getValueAt(jTable.getSelectedRow(), 1);
        Preferences.Setting setting = prefEntry.getValue();
        if (setting instanceof Preferences.StringSetting) {
            jTable.editCellAt(jTable.getSelectedRow(), 1);
            Component component = jTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
        } else if (setting instanceof Preferences.ListSetting) {
            Preferences.ListSetting listSetting = (Preferences.ListSetting)setting;
            ListEditor listEditor = new ListEditor(preferenceTabbedPane, prefEntry, listSetting);
            listEditor.showDialog();
            if (listEditor.getValue() == 1) {
                List<String> list = listEditor.getData();
                if (!Preferences.equalCollection((Collection)listSetting.getValue(), list)) {
                    prefEntry.setValue(new Preferences.ListSetting(list));
                    this.applyFilter();
                }
            }
        } else if (setting instanceof Preferences.ListListSetting) {
            ListListEditor listListEditor = new ListListEditor(preferenceTabbedPane, prefEntry, (Preferences.ListListSetting)setting);
            listListEditor.showDialog();
            if (listListEditor.getValue() == 1) {
                List<List<String>> list = listListEditor.getData();
                if (!Preferences.equalArray((Collection)setting.getValue(), list)) {
                    prefEntry.setValue(new Preferences.ListListSetting(list));
                    this.applyFilter();
                }
            }
        } else if (setting instanceof Preferences.MapListSetting) {
            Preferences.MapListSetting mapListSetting = (Preferences.MapListSetting)setting;
            MapListEditor mapListEditor = new MapListEditor(preferenceTabbedPane, prefEntry, mapListSetting);
            mapListEditor.showDialog();
            if (mapListEditor.getValue() == 1) {
                List<Map<String, String>> list = mapListEditor.getData();
                if (!Preferences.equalListOfStructs((Collection)mapListSetting.getValue(), list)) {
                    prefEntry.setValue(new Preferences.MapListSetting(list));
                    this.applyFilter();
                }
            }
        }
    }

    private class SettingCellEditor
    extends DefaultCellEditor {
        public SettingCellEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            PrefEntry prefEntry = (PrefEntry)object;
            Preferences.StringSetting stringSetting = (Preferences.StringSetting)prefEntry.getValue();
            String string = stringSetting.getValue() == null ? "" : (String)stringSetting.getValue();
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }
    }

    private class SettingCellRenderer
    extends DefaultTableCellRenderer {
        private SettingCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            PrefEntry prefEntry = (PrefEntry)object;
            Preferences.Setting setting = prefEntry.getValue();
            Object t = setting.getValue();
            String string = t != null ? t.toString() : "<html><i>&lt;" + I18n.tr("unset", new Object[0]) + "&gt;</i></html>";
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (!prefEntry.isDefault()) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            return jLabel;
        }
    }

    class AllSettingsTableModel
    extends DefaultTableModel {
        public AllSettingsTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && AdvancedPreference.this.displayData.get(n).getValue() instanceof Preferences.StringSetting;
        }

        public int getRowCount() {
            return AdvancedPreference.this.displayData.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return AdvancedPreference.this.displayData.get(n).getKey();
            }
            return AdvancedPreference.this.displayData.get(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            PrefEntry prefEntry = AdvancedPreference.this.displayData.get(n);
            if (!string.equals(prefEntry.getValue().getValue())) {
                prefEntry.setValue(new Preferences.StringSetting(string));
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrefEntry
    implements Comparable<PrefEntry> {
        private String key;
        private Preferences.Setting value;
        private Preferences.Setting defaultValue;
        private boolean isDefault;
        private boolean changed;

        public PrefEntry(String string, Preferences.Setting setting, Preferences.Setting setting2, boolean bl) {
            CheckParameterUtil.ensureParameterNotNull(string);
            CheckParameterUtil.ensureParameterNotNull(setting);
            CheckParameterUtil.ensureParameterNotNull(setting2);
            this.key = string;
            this.value = setting;
            this.defaultValue = setting2;
            this.isDefault = bl;
        }

        public String getKey() {
            return this.key;
        }

        public Preferences.Setting getValue() {
            return this.value;
        }

        public void setValue(Preferences.Setting setting) {
            this.value = setting;
            this.changed = true;
            this.isDefault = false;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void reset() {
            this.value = this.defaultValue;
            this.changed = true;
            this.isDefault = true;
        }

        @Override
        public int compareTo(PrefEntry prefEntry) {
            return this.key.compareTo(prefEntry.key);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

