/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmDataLayer
extends Layer
implements DataSetListenerAdapter.Listener,
SelectionChangedListener {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile = false;
    private boolean requiresUploadToServer = false;
    private boolean isChanged = true;
    private int highlightUpdateCount;
    public List<TestError> validationErrors = new ArrayList<TestError>();
    private static int dataLayerCounter = 0;
    public final DataSet data;
    private ConflictCollection conflicts;
    private static TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean bl) {
        boolean bl2 = this.requiresSaveToFile;
        this.requiresSaveToFile = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, bl2, bl);
        }
    }

    protected void setRequiresUploadToServer(boolean bl) {
        boolean bl2 = this.requiresUploadToServer;
        this.requiresUploadToServer = bl;
        if (bl2 != bl) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, bl2, bl);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public static Color getBackgroundColor() {
        return Main.pref.getColor(I18n.marktr("background"), Color.BLACK);
    }

    public static Color getOutsideColor() {
        return Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW);
    }

    public static void createHatchTexture() {
        BufferedImage bufferedImage = new BufferedImage(15, 15, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(OsmDataLayer.getBackgroundColor());
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillRect(0, 0, 15, 15);
        graphics2D.setColor(OsmDataLayer.getOutsideColor());
        graphics2D.drawLine(0, 15, 15, 0);
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bufferedImage, rectangle);
    }

    public OsmDataLayer(DataSet dataSet, String string, File file) {
        super(string);
        this.data = dataSet;
        this.setAssociatedFile(file);
        this.conflicts = new ConflictCollection();
        dataSet.addDataSetListener(new DataSetListenerAdapter(this));
        dataSet.addDataSetListener(MultipolygonCache.getInstance());
        DataSet.addSelectionListener(this);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        boolean bl;
        this.isChanged = false;
        this.highlightUpdateCount = this.data.getHighlightUpdateCount();
        boolean bl2 = mapView.getActiveLayer() == this;
        boolean bl3 = !bl2 && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl4 = bl = !bl3 && mapView.isVirtualNodesEnabled();
        if (bl2 && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            object = mapView.getBounds();
            ((Rectangle)object).grow(100, 100);
            Area area = new Area((Shape)object);
            for (Bounds bounds2 : this.data.getDataSourceBounds()) {
                if (bounds2.isCollapsed()) continue;
                Point point = mapView.getPoint(bounds2.getMin());
                Point point2 = mapView.getPoint(bounds2.getMax());
                Rectangle rectangle = new Rectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
                area.subtract(new Area(rectangle));
            }
            graphics2D.setPaint(hatched);
            graphics2D.fill(area);
        }
        object = MapRendererFactory.getInstance().createActiveRenderer(graphics2D, mapView, bl3);
        object.render(this.data, bl, bounds);
        Main.map.conflictDialog.paintConflicts(graphics2D, mapView);
    }

    @Override
    public String getToolTipText() {
        File file;
        int n = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getNodes(), OsmPrimitive.nonDeletedPredicate).size();
        int n2 = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getWays(), OsmPrimitive.nonDeletedPredicate).size();
        String string = I18n.trn("{0} node", "{0} nodes", n, n) + ", ";
        string = string + I18n.trn("{0} way", "{0} ways", n2, n2);
        if (this.data.getVersion() != null) {
            string = string + ", " + I18n.tr("version {0}", this.data.getVersion());
        }
        if ((file = this.getAssociatedFile()) != null) {
            string = "<html>" + string + "<br>" + file.getPath() + "</html>";
        }
        return string;
    }

    @Override
    public void mergeFrom(Layer layer) {
        this.mergeFrom(((OsmDataLayer)layer).data);
    }

    public void mergeFrom(DataSet dataSet) {
        DataSetMerger dataSetMerger = new DataSetMerger(this.data, dataSet);
        try {
            dataSetMerger.merge();
        }
        catch (DataIntegrityProblemException dataIntegrityProblemException) {
            JOptionPane.showMessageDialog(Main.parent, dataIntegrityProblemException.getMessage(), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        Area area = this.data.getDataSourceArea();
        for (DataSource object : dataSet.dataSources) {
            if (area != null && area.contains(object.bounds.asRect())) continue;
            this.data.dataSources.add(object);
        }
        if (this.data.getVersion() == null) {
            this.data.setVersion(dataSet.getVersion());
        } else if ("0.5".equals(this.data.getVersion()) ^ "0.5".equals(dataSet.getVersion())) {
            System.err.println(I18n.tr("Warning: mixing 0.6 and 0.5 data results in version 0.5", new Object[0]));
            this.data.setVersion("0.5");
        }
        int n = 0;
        for (Conflict<?> conflict : dataSetMerger.getConflicts()) {
            if (this.conflicts.hasConflict(conflict)) continue;
            ++n;
            this.conflicts.add(conflict);
        }
        Main.map.mapView.repaint();
        this.warnNumNewConflicts(n);
    }

    protected void warnNumNewConflicts(int n) {
        if (n == 0) {
            return;
        }
        String string = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", n, n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>").append(string).append("</html>");
        if (n > 0) {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to close this dialog and continue editing", new Object[0]), null)};
            HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuffer.toString(), I18n.tr("Conflicts detected", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Concepts/Conflict#WarningAboutDetectedConflicts"));
            Main.map.conflictDialog.unfurlDialog();
            Main.map.repaint();
        }
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Node node : this.data.getNodes()) {
            if (!node.isUsable()) continue;
            boundingXYVisitor.visit(node);
        }
    }

    public void cleanupAfterUpload(Collection<IPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        this.data.cleanupDeletedPrimitives();
        for (OsmPrimitive osmPrimitive : this.data.allPrimitives()) {
            if (!collection.contains(osmPrimitive)) continue;
            osmPrimitive.setModified(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getInfoComponent() {
        void var3_6;
        DataCountVisitor dataCountVisitor = new DataCountVisitor();
        for (OsmPrimitive object2 : this.data.allPrimitives()) {
            object2.visit(dataCountVisitor);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = I18n.trn("{0} node", "{0} nodes", dataCountVisitor.nodes, dataCountVisitor.nodes);
        if (dataCountVisitor.deletedNodes > 0) {
            String string2 = string + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedNodes, dataCountVisitor.deletedNodes) + ")";
        }
        String string3 = I18n.trn("{0} way", "{0} ways", dataCountVisitor.ways, dataCountVisitor.ways);
        if (dataCountVisitor.deletedWays > 0) {
            string3 = string3 + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedWays, dataCountVisitor.deletedWays) + ")";
        }
        String string4 = I18n.trn("{0} relation", "{0} relations", dataCountVisitor.relations, dataCountVisitor.relations);
        if (dataCountVisitor.deletedRelations > 0) {
            string4 = string4 + " (" + I18n.trn("{0} deleted", "{0} deleted", dataCountVisitor.deletedRelations, dataCountVisitor.deletedRelations) + ")";
        }
        jPanel.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        jPanel.add((Component)new JLabel((String)var3_6, ImageProvider.get("data", "node"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(string3, ImageProvider.get("data", "way"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add((Component)new JLabel(string4, ImageProvider.get("data", "relation"), 0), GBC.eop().insets(15, 0, 0, 0));
        jPanel.add(new JLabel(I18n.tr("API version: {0}", this.data.getVersion() != null ? this.data.getVersion() : I18n.tr("unset", new Object[0]))));
        return jPanel;
    }

    @Override
    public Action[] getMenuEntries() {
        if (Main.applet) {
            return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
        }
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new Layer.LayerGpxExportAction(this), new ConvertToGpxLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public static GpxData toGpxData(DataSet dataSet, File file) {
        Object object;
        Object object2;
        Object object3;
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Way osmPrimitive : dataSet.getWays()) {
            if (!osmPrimitive.isUsable()) continue;
            object3 = new ArrayList();
            object2 = new HashMap<String, String>();
            if (osmPrimitive.get("name") != null) {
                object2.put("name", osmPrimitive.get("name"));
            }
            object = null;
            for (Node node : osmPrimitive.getNodes()) {
                if (!node.isUsable()) {
                    object = null;
                    continue;
                }
                if (object == null) {
                    object = new ArrayList();
                    object3.add(object);
                }
                if (!node.isTagged()) {
                    hashSet.add(node);
                }
                WayPoint wayPoint = new WayPoint(node.getCoor());
                if (!node.isTimestampEmpty()) {
                    wayPoint.attr.put("time", DateUtils.fromDate(node.getTimestamp()));
                    wayPoint.setTime();
                }
                object.add(wayPoint);
            }
            gpxData.tracks.add(new ImmutableGpxTrack((Collection<Collection<WayPoint>>)object3, (Map<String, Object>)object2));
        }
        for (Node node : dataSet.getNodes()) {
            if (node.isIncomplete() || node.isDeleted() || hashSet.contains(node) || (object3 = node.get("name")) == null) continue;
            object2 = new WayPoint(node.getCoor());
            ((WayPoint)object2).attr.put("name", object3);
            if (!node.isTimestampEmpty()) {
                ((WayPoint)object2).attr.put("time", DateUtils.fromDate(node.getTimestamp()));
                ((WayPoint)object2).setTime();
            }
            if ((object = node.get("description")) != null) {
                ((WayPoint)object2).attr.put("desc", object);
            }
            gpxData.waypoints.add((WayPoint)object2);
        }
        return gpxData;
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon latLon) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (DataSource dataSource : this.data.dataSources) {
            if (!dataSource.bounds.contains(latLon)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostDownloadFromServer() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    @Override
    public boolean isChanged() {
        return this.isChanged || this.highlightUpdateCount != this.data.getHighlightUpdateCount();
    }

    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.data.isModified());
    }

    @Override
    public void destroy() {
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.isChanged = true;
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.isChanged = true;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    private class ConsistencyTestAction
    extends AbstractAction {
        public ConsistencyTestAction() {
            super(I18n.tr("Dataset consistency test", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DatasetConsistencyTest.runTests(OsmDataLayer.this.data);
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No problems found", new Object[0]));
            } else {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)new JLabel(I18n.tr("Following problems found:", new Object[0])), GBC.eol());
                JTextArea jTextArea = new JTextArea(string, 20, 60);
                jTextArea.setCaretPosition(0);
                jTextArea.setEditable(false);
                jPanel.add((Component)new JScrollPane(jTextArea), GBC.eop());
                JOptionPane.showMessageDialog(Main.parent, jPanel, I18n.tr("Warning", new Object[0]), 2);
            }
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer", new Object[0]), ImageProvider.get("converttogpx"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.getName())));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public int nodes;
        public int ways;
        public int relations;
        public int deletedNodes;
        public int deletedWays;
        public int deletedRelations;

        public void visit(Node node) {
            ++this.nodes;
            if (node.isDeleted()) {
                ++this.deletedNodes;
            }
        }

        public void visit(Way way) {
            ++this.ways;
            if (way.isDeleted()) {
                ++this.deletedWays;
            }
        }

        public void visit(Relation relation) {
            ++this.relations;
            if (relation.isDeleted()) {
                ++this.deletedRelations;
            }
        }
    }
}

