/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HideableButton;
import org.openstreetmap.josm.gui.ShowHideButtonListener;
import org.openstreetmap.josm.tools.Destroyable;

public class IconToggleButton
extends JToggleButton
implements HideableButton,
PropertyChangeListener,
Destroyable {
    public boolean groupbutton;
    private ShowHideButtonListener listener;

    public IconToggleButton(Action action) {
        super(action);
        this.setText(null);
        Object object = action.getValue("ShortDescription");
        if (object != null) {
            this.setToolTipText(object.toString());
        }
        action.addPropertyChangeListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                IconToggleButton.this.groupbutton = mouseEvent.getX() > IconToggleButton.this.getWidth() / 2 && mouseEvent.getY() > IconToggleButton.this.getHeight() / 2;
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("active")) {
            this.setSelected((Boolean)propertyChangeEvent.getNewValue());
            this.requestFocusInWindow();
        } else if (propertyChangeEvent.getPropertyName().equals("selected")) {
            this.setSelected((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            action.removePropertyChangeListener(this);
        }
    }

    public void applyButtonHiddenPreferences() {
        String string = (String)this.getSafeActionValue("Name");
        boolean bl = Main.pref.getBoolean(string + ".itbutton_hidden", false);
        this.setVisible(!bl);
    }

    public void setButtonHidden(boolean bl) {
        String string = (String)this.getSafeActionValue("Name");
        this.setVisible(!bl);
        if (this.listener != null) {
            if (!bl) {
                this.listener.buttonShown();
            } else {
                this.listener.buttonHidden();
            }
        }
        Main.pref.put(string + ".itbutton_hidden", bl);
    }

    public void showButton() {
        this.setButtonHidden(false);
    }

    public void hideButton() {
        this.setButtonHidden(true);
    }

    public String getActionName() {
        return (String)this.getSafeActionValue("Name");
    }

    public Icon getIcon() {
        return (Icon)this.getSafeActionValue("SmallIcon");
    }

    public boolean isButtonVisible() {
        return this.isVisible();
    }

    public void setShowHideButtonListener(ShowHideButtonListener showHideButtonListener) {
        this.listener = showHideButtonListener;
    }

    protected final Object getSafeActionValue(String string) {
        return this.getAction() != null ? this.getAction().getValue(string) : null;
    }
}

