/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class OverlappingAreas
extends Test {
    protected static int OVERLAPPING_AREAS = 2201;
    protected QuadBuckets<Way> index = new QuadBuckets();
    private static ElemStyles styles = MapPaintStyles.getStyles();

    public OverlappingAreas() {
        super(I18n.tr("Overlapping Areas", new Object[0]));
    }

    public void visit(Way way) {
        if (way.isUsable() && way.isClosed() && this.hasAreaElemStyle(way)) {
            this.index.add(way);
        }
    }

    public void endTest() {
        for (final Way way : this.index) {
            Collection<Way> collection = Utils.filter(this.index.search(way.getBBox()), new Predicate<Way>(){

                @Override
                public boolean evaluate(Way way2) {
                    if (way.equals(way2)) {
                        return false;
                    }
                    return Geometry.polygonIntersection(way.getNodes(), way2.getNodes()) == Geometry.PolygonIntersection.CROSSING;
                }
            });
            if (collection.isEmpty()) continue;
            this.errors.add(new TestError(this, Severity.OTHER, I18n.tr("Overlapping Areas", new Object[0]), OVERLAPPING_AREAS, Collections.singletonList(way), collection));
        }
    }

    private boolean hasAreaElemStyle(OsmPrimitive osmPrimitive) {
        for (ElemStyle elemStyle : (StyleCache.StyleList)OverlappingAreas.styles.generateStyles((OsmPrimitive)osmPrimitive, (double)1.0, null, (boolean)false).a) {
            if (!(elemStyle instanceof AreaElemStyle)) continue;
            return true;
        }
        return false;
    }
}

