/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;
    protected static final int OUTER_STYLE_MISMATCH = 1607;
    protected static final int INNER_STYLE_MISMATCH = 1608;
    protected static final int NOT_CLOSED = 1609;
    protected static final int NO_STYLE = 1610;
    protected static final int NO_STYLE_POLYGON = 1611;
    private static ElemStyles styles;
    private final List<List<Node>> nonClosedWays = new ArrayList<List<Node>>();
    private final double SCALE = 1.0;

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        styles = MapPaintStyles.getStyles();
    }

    private List<List<Node>> joinWays(Collection<Way> collection) {
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        for (Way object : collection) {
            if (object.isClosed()) {
                arrayList.add(object.getNodes());
                continue;
            }
            arrayList2.add(object);
        }
        for (Multipolygon.JoinedWay joinedWay : Multipolygon.joinWays(arrayList2)) {
            if (!joinedWay.isClosed()) {
                this.nonClosedWays.add(joinedWay.getNodes());
                continue;
            }
            arrayList.add(joinedWay.getNodes());
        }
        return arrayList;
    }

    private GeneralPath createPath(List<Node> list) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)list.get(0).getCoor().lat(), (float)list.get(0).getCoor().lon());
        for (int i = 1; i < list.size(); ++i) {
            Node node = list.get(i);
            generalPath.lineTo((float)node.getCoor().lat(), (float)node.getCoor().lon());
        }
        return generalPath;
    }

    private List<GeneralPath> createPolygons(List<List<Node>> list) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (List<Node> list2 : list) {
            arrayList.add(this.createPath(list2));
        }
        return arrayList;
    }

    private Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath generalPath, List<Node> list) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : list) {
            boolean bl3 = generalPath.contains(node.getCoor().lat(), node.getCoor().lon());
            if (!((bl |= bl3) & (bl2 |= !bl3))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return bl ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way way) {
        if (styles != null && !way.isClosed()) {
            for (ElemStyle elemStyle : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)false).a) {
                if (!(elemStyle instanceof AreaElemStyle)) continue;
                List<Node> list = way.getNodes();
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Area style way is not closed", new Object[0]), 1609, Collections.singletonList(way), Arrays.asList(list.get(0), list.get(list.size() - 1))));
                break;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        this.nonClosedWays.clear();
        if (relation.isMultipolygon()) {
            List<GeneralPath> list;
            Object object;
            this.checkMembersAndRoles(relation);
            Multipolygon multipolygon = MultipolygonCache.getInstance().get(Main.map.mapView, relation);
            boolean bl = false;
            for (RelationMember object22 : relation.getMembers()) {
                if (!"outer".equals(object22.getRole())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("No outer way for multipolygon", new Object[0]), 1604, relation));
            }
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember().isUsable()) continue;
                return;
            }
            List<List<Node>> list2 = this.joinWays(multipolygon.getInnerWays());
            List<List<Node>> list3 = this.joinWays(multipolygon.getOuterWays());
            if (styles != null) {
                object = null;
                boolean bl2 = false;
                for (ElemStyle elemStyle : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)relation, (double)1.0, null, (boolean)false).a) {
                    if (!(elemStyle instanceof AreaElemStyle)) continue;
                    object = (AreaElemStyle)elemStyle;
                    bl2 = true;
                    break;
                }
                if (object == null) {
                    for (Way way : multipolygon.getOuterWays()) {
                        for (Object object2 : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)true).a) {
                            if (!(object2 instanceof AreaElemStyle)) continue;
                            object = (AreaElemStyle)object2;
                            break;
                        }
                        if (object == null) continue;
                        break;
                    }
                    if (object == null) {
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("No style for multipolygon", new Object[0]), 1610, relation));
                    } else {
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("No style in multipolygon relation", new Object[0]), 1611, relation));
                    }
                }
                if (object != null) {
                    Object object3;
                    Object object2;
                    for (Way way : multipolygon.getInnerWays()) {
                        object3 = null;
                        for (Object object4 : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)false).a) {
                            if (!(object4 instanceof AreaElemStyle)) continue;
                            object3 = (AreaElemStyle)object4;
                            break;
                        }
                        if (object3 == null || !((AreaElemStyle)object).equals(object3)) continue;
                        object2 = new ArrayList();
                        object2.add(relation);
                        object2.add(way);
                        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Style for inner way equals multipolygon", new Object[0]), 1608, (Collection<? extends OsmPrimitive>)object2, (Collection<?>)Collections.singletonList(way)));
                    }
                    if (!bl2) {
                        for (Way way : multipolygon.getOuterWays()) {
                            object3 = null;
                            for (Object object4 : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)false).a) {
                                if (!(object4 instanceof AreaElemStyle)) continue;
                                object3 = (AreaElemStyle)object4;
                                break;
                            }
                            if (object3 == null || ((AreaElemStyle)object).equals(object3)) continue;
                            object2 = new ArrayList<Relation>();
                            object2.add(relation);
                            object2.add(way);
                            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Style for outer way mismatches", new Object[0]), 1607, (Collection<? extends OsmPrimitive>)object2, (Collection<?>)Collections.singletonList(way)));
                        }
                    }
                }
            }
            object = new LinkedList<Node>();
            for (List<Node> list4 : this.nonClosedWays) {
                object.add(list4.get(0));
                object.add(list4.get(list4.size() - 1));
            }
            if (!object.isEmpty()) {
                list = new LinkedList();
                list.add((GeneralPath)((Object)relation));
                list.addAll((Collection<GeneralPath>)object);
                Arrays.asList(object, relation);
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Multipolygon is not closed", new Object[0]), 1603, (Collection<? extends OsmPrimitive>)list, (Collection<?>)object));
            }
            list = this.createPolygons(list3);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object object4;
                List list5 = (List)iterator.next();
                boolean bl3 = true;
                boolean bl4 = false;
                object4 = null;
                for (int i = 0; i < list3.size(); ++i) {
                    GeneralPath generalPath = list.get(i);
                    Multipolygon.PolyData.Intersection intersection = this.getPolygonIntersection(generalPath, list5);
                    bl3 &= intersection == Multipolygon.PolyData.Intersection.OUTSIDE;
                    if (intersection != Multipolygon.PolyData.Intersection.CROSSING) continue;
                    bl4 = true;
                    object4 = list3.get(i);
                }
                if (!bl3 && !bl4) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(list5);
                if (bl3) {
                    this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Multipolygon inner way is outside", new Object[0]), 1605, Collections.singletonList(relation), arrayList));
                    continue;
                }
                if (!bl4) continue;
                arrayList.add(object4);
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Intersection between multipolygon ways", new Object[0]), 1606, Collections.singletonList(relation), arrayList));
            }
        }
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if ("inner".equals(relationMember.getRole()) || "outer".equals(relationMember.getRole()) || !relationMember.hasRole()) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("No useful role for multipolygon member", new Object[0]), 1602, relationMember.getMember()));
                continue;
            }
            if ("admin_centre".equals(relationMember.getRole())) continue;
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Non-Way in multipolygon", new Object[0]), 1601, relationMember.getMember()));
        }
    }
}

