/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public class MapRectangleImpl
implements MapRectangle {
    private Coordinate topLeft;
    private Coordinate bottomRight;
    private Color color;
    private Stroke stroke;

    public MapRectangleImpl(Coordinate coordinate, Coordinate coordinate2) {
        this(coordinate, coordinate2, Color.BLUE, new BasicStroke(2.0f));
    }

    public MapRectangleImpl(Coordinate coordinate, Coordinate coordinate2, Color color, Stroke stroke) {
        this.topLeft = coordinate;
        this.bottomRight = coordinate2;
        this.color = color;
        this.stroke = stroke;
    }

    public Coordinate getTopLeft() {
        return this.topLeft;
    }

    public Coordinate getBottomRight() {
        return this.bottomRight;
    }

    public void paint(Graphics graphics, Point point, Point point2) {
        Color color = graphics.getColor();
        graphics.setColor(this.color);
        Stroke stroke = null;
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.stroke);
        }
        graphics.drawRect(point.x, point.y, point2.x - point.x, point2.y - point.y);
        graphics.setColor(color);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
    }

    public String toString() {
        return "MapRectangle from " + this.topLeft + " to " + this.bottomRight;
    }
}

