/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedPreference
implements PreferenceSetting {
    private Map<String, String> orig;
    private Map<String, String> defaults;
    private DefaultTableModel model;
    protected Map<String, String> data;
    protected JTextField txtFilter;

    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = preferenceTabbedPane.createPreferenceTab("advanced", I18n.tr("Advanced Preferences", new Object[0]), I18n.tr("Setting Preference entries directly. Use with caution!", new Object[0]), false);
        this.txtFilter = new JTextField();
        JLabel jLabel = new JLabel(I18n.tr("Search: ", new Object[0]));
        jLabel.setLabelFor(this.txtFilter);
        jPanel.add(jLabel);
        jPanel.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.dataToModel();
            }
        });
        this.model = new DefaultTableModel(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])}, 0){

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }

            public void fireTableCellUpdated(int n, int n2) {
                super.fireTableCellUpdated(n, n2);
                if (n2 == 1) {
                    AdvancedPreference.this.data.put((String)AdvancedPreference.this.model.getValueAt(n, 0), (String)AdvancedPreference.this.model.getValueAt(n, 1));
                }
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = new JLabel();
                String string = (String)AdvancedPreference.this.defaults.get(object);
                if (string != null) {
                    if (string.equals(AdvancedPreference.this.model.getValueAt(n, 1))) {
                        jLabel.setToolTipText(I18n.tr("Current value is default.", new Object[0]));
                    } else {
                        jLabel.setToolTipText(I18n.tr("Default value is ''{0}''.", string));
                    }
                } else {
                    jLabel.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet).", new Object[0]));
                }
                jLabel.setText((String)object);
                return jLabel;
            }
        };
        final JTable jTable = new JTable(this.model);
        jTable.putClientProperty("terminateEditOnFocusLost", true);
        jTable.getColumn(I18n.tr("Key", new Object[0])).setCellRenderer(defaultTableCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        this.orig = Main.pref.getAllPrefix("");
        this.defaults = Main.pref.getDefaults();
        this.orig.remove("osm-server.password");
        this.defaults.remove("osm-server.password");
        this.prepareData();
        this.dataToModel();
        JButton jButton = new JButton(I18n.tr("Add", new Object[0]));
        jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.addPreference(preferenceTabbedPane);
            }
        });
        JButton jButton2 = new JButton(I18n.tr("Edit", new Object[0]));
        jPanel.add((Component)jButton2, GBC.std().insets(5, 5, 5, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.editPreference(preferenceTabbedPane, jTable);
            }
        });
        JButton jButton3 = new JButton(I18n.tr("Delete", new Object[0]));
        jPanel.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.removePreference(preferenceTabbedPane, jTable);
            }
        });
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AdvancedPreference.this.editPreference(preferenceTabbedPane, jTable);
                }
            }
        });
    }

    private void prepareData() {
        TreeSet<String> treeSet = new TreeSet<String>(this.orig.keySet());
        for (String string : this.defaults.keySet()) {
            if (treeSet.contains(string)) continue;
            treeSet.add(string);
        }
        this.data = new TreeMap<String, String>();
        for (String string : treeSet) {
            String string2 = Main.pref.get(string);
            if (string2 == null) {
                string2 = "";
            }
            this.data.put(string, string2);
        }
    }

    private void dataToModel() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        for (String string : this.data.keySet()) {
            String string2 = this.data.get(string);
            String[] stringArray = this.txtFilter.getText().split("\\s+");
            boolean bl = true;
            String string3 = string.toLowerCase();
            String string4 = string2.toLowerCase();
            for (String string5 : stringArray) {
                if (string3.contains(string5 = string5.toLowerCase()) || string4.contains(string5)) continue;
                bl = false;
            }
            if (!bl) continue;
            this.model.addRow(new String[]{string, string2});
        }
    }

    public boolean ok() {
        for (String object : this.data.keySet()) {
            String string = this.data.get(object);
            if (string.length() == 0) continue;
            String string2 = this.orig.get(object);
            if (string2 == null || !string2.equals(string)) {
                Main.pref.put(object, string);
            }
            this.orig.remove(object);
        }
        for (Map.Entry entry : this.orig.entrySet()) {
            Main.pref.put((String)entry.getKey(), null);
        }
        return false;
    }

    private void removePreference(PreferenceTabbedPane preferenceTabbedPane, JTable jTable) {
        if (jTable.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        for (int n : jTable.getSelectedRows()) {
            this.data.put((String)this.model.getValueAt(n, 0), "");
            this.model.setValueAt("", n, 1);
        }
    }

    private void addPreference(PreferenceTabbedPane preferenceTabbedPane) {
        String[] stringArray = this.showEditDialog(preferenceTabbedPane, I18n.tr("Enter a new key/value pair", new Object[0]), "", "");
        if (stringArray != null && !stringArray[0].isEmpty() && !stringArray[1].isEmpty()) {
            this.data.put(stringArray[0], stringArray[1]);
            this.dataToModel();
        }
    }

    private void editPreference(PreferenceTabbedPane preferenceTabbedPane, JTable jTable) {
        String[] stringArray;
        if (jTable.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        String string = (String)this.model.getValueAt(jTable.getSelectedRow(), 0);
        String string2 = this.data.get(string);
        if (string2.isEmpty()) {
            string2 = this.defaults.get(string);
        }
        if ((stringArray = this.showEditDialog(preferenceTabbedPane, I18n.tr("Change a key/value pair", new Object[0]), string, string2)) != null && !stringArray[0].isEmpty()) {
            this.data.put(stringArray[0], stringArray[1]);
            if (!stringArray[0].equals(string)) {
                this.data.put(string, "");
            }
            this.dataToModel();
        }
    }

    private String[] showEditDialog(PreferenceTabbedPane preferenceTabbedPane, String string, String string2, String string3) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JTextField jTextField = new JTextField(string2, 50);
        JTextField jTextField2 = new JTextField(string3, 50);
        jPanel.add((Component)jTextField, GBC.eop().insets(5, 0, 0, 0).fill(2));
        PrefValueTableModel prefValueTableModel = new PrefValueTableModel(string3);
        jPanel.add((Component)new JLabel(I18n.tr("Values", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JTable jTable = new JTable(prefValueTableModel);
        jTable.putClientProperty("terminateEditOnFocusLost", true);
        jTable.getTableHeader().setVisible(false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.height = dimension.height / 20 * (prefValueTableModel.getRowCount() + 4);
        jScrollPane.setPreferredSize(dimension);
        jPanel.add((Component)jScrollPane, GBC.eol().insets(5, 10, 0, 0).fill(2));
        ExtendedDialog extendedDialog = new ExtendedDialog(preferenceTabbedPane, string, new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() == 1) {
            return new String[]{jTextField.getText(), prefValueTableModel.getText()};
        }
        return null;
    }

    class PrefValueTableModel
    extends DefaultTableModel {
        private final ArrayList<String> data = new ArrayList();

        public PrefValueTableModel(String string) {
            this.data.addAll(Arrays.asList(string.split("\u001e")));
            this.setColumnIdentifiers(new String[]{""});
        }

        public String getText() {
            String string = null;
            for (String string2 : this.data) {
                if (string == null) {
                    string = string2;
                    continue;
                }
                string = string + "\u001e" + string2;
            }
            return string == null ? "" : string;
        }

        public int getRowCount() {
            return this.data == null ? 1 : this.data.size() + 1;
        }

        public Object getValueAt(int n, int n2) {
            return this.data.size() == n ? "" : this.data.get(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == this.data.size()) {
                this.data.add(string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.data.set(n, string);
            }
            this.fireTableCellUpdated(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

