/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import org.openstreetmap.josm.data.osm.OsmUtils;

public class XmlCondition {
    public String key;
    public String value;
    public String boolValue;

    public XmlCondition() {
        this.init();
    }

    public XmlCondition(XmlCondition xmlCondition) {
        this.key = xmlCondition.key;
        this.value = xmlCondition.value;
        this.boolValue = xmlCondition.boolValue;
    }

    public String getKey() {
        if (this.value != null) {
            return "n" + this.key + "=" + this.value;
        }
        if (this.boolValue != null) {
            return "b" + this.key + "=" + OsmUtils.getNamedOsmBoolean(this.boolValue);
        }
        return "x" + this.key;
    }

    public void init() {
        this.boolValue = null;
        this.value = null;
        this.key = null;
    }

    public String toString() {
        return "Rule[" + this.key + "," + (this.boolValue != null ? "b=" + this.boolValue : "v=" + this.value) + "]";
    }

    public String toCode() {
        return "[k=" + this.key + (this.boolValue != null ? ",b=" + this.boolValue : ",v=" + this.value) + "]";
    }
}

