/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePrimitivesTask
extends PleaseWaitRunnable {
    private DataSet ds;
    private boolean canceled;
    private Exception lastException;
    private Collection<? extends OsmPrimitive> toUpdate;
    private OsmDataLayer layer;
    private MultiFetchServerObjectReader multiObjectReader;
    private OsmServerObjectReader objectReader;

    public UpdatePrimitivesTask(OsmDataLayer osmDataLayer, Collection<? extends OsmPrimitive> collection) throws IllegalArgumentException {
        super(I18n.tr("Update objects", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.layer = osmDataLayer;
        this.toUpdate = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        UpdatePrimitivesTask updatePrimitivesTask = this;
        synchronized (updatePrimitivesTask) {
            if (this.multiObjectReader != null) {
                this.multiObjectReader.cancel();
            }
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                UpdatePrimitivesTask.this.layer.mergeFrom(UpdatePrimitivesTask.this.ds);
                UpdatePrimitivesTask.this.layer.onPostDownloadFromServer();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    protected void initMultiFetchReaderWithNodes(MultiFetchServerObjectReader multiFetchServerObjectReader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to update ...", new Object[0]));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (osmPrimitive instanceof Node && !osmPrimitive.isNew()) {
                multiFetchServerObjectReader.append((Node)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            Way way = (Way)osmPrimitive;
            for (Node node : way.getNodes()) {
                if (node.isNew()) continue;
                multiFetchServerObjectReader.append(node);
            }
        }
    }

    protected void initMultiFetchReaderWithWays(MultiFetchServerObjectReader multiFetchServerObjectReader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing ways to update ...", new Object[0]));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.isNew()) continue;
            multiFetchServerObjectReader.append((Way)osmPrimitive);
        }
    }

    protected void initMultiFetchReaderWithRelations(MultiFetchServerObjectReader multiFetchServerObjectReader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing relations to update ...", new Object[0]));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isNew()) continue;
            multiFetchServerObjectReader.append((Relation)osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.ds = new DataSet();
        try {
            Object object = this;
            synchronized (object) {
                if (this.canceled) {
                    return;
                }
                this.multiObjectReader = new MultiFetchServerObjectReader();
            }
            this.initMultiFetchReaderWithNodes(this.multiObjectReader);
            this.initMultiFetchReaderWithWays(this.multiObjectReader);
            this.initMultiFetchReaderWithRelations(this.multiObjectReader);
            DataSet dataSet = this.multiObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            object = this;
            synchronized (object) {
                this.multiObjectReader = null;
            }
            object = new DataSetMerger(this.ds, dataSet);
            ((DataSetMerger)object).merge();
            for (Way way : this.ds.getWays()) {
                if (this.canceled) {
                    return;
                }
                if (!way.hasIncompleteNodes()) continue;
                UpdatePrimitivesTask updatePrimitivesTask = this;
                synchronized (updatePrimitivesTask) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(way.getId(), OsmPrimitiveType.WAY, true);
                }
                dataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                updatePrimitivesTask = this;
                synchronized (updatePrimitivesTask) {
                    this.objectReader = null;
                }
                object = new DataSetMerger(this.ds, dataSet);
                ((DataSetMerger)object).merge();
            }
        }
        catch (Exception exception) {
            if (this.canceled) {
                return;
            }
            this.lastException = exception;
        }
    }
}

