/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_DELETED = new Color(255, 197, 197);
    public static final Color BGCOLOR_INSERTED = new Color(221, 255, 221);
    public static final Color BGCOLOR_CHANGED = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private ImageIcon nodeIcon;

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
        this.nodeIcon = ImageProvider.get("data", "node");
        this.setIcon(this.nodeIcon);
    }

    protected void renderNode(TwoColumnDiff.Item item, boolean bl) {
        String string = "";
        Color color = Color.WHITE;
        this.setIcon(this.nodeIcon);
        if (item.value != null) {
            string = I18n.tr("Node {0}", item.value.toString());
        }
        switch (item.state) {
            case 5: {
                string = "";
                color = BGCOLOR_EMPTY_ROW;
                this.setIcon(null);
                break;
            }
            case 3: {
                color = BGCOLOR_CHANGED;
                break;
            }
            case 1: {
                color = BGCOLOR_INSERTED;
                break;
            }
            case 2: {
                color = BGCOLOR_DELETED;
                break;
            }
            default: {
                color = BGCOLOR_EMPTY_ROW;
            }
        }
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        this.setText(string);
        this.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        this.renderNode((TwoColumnDiff.Item)object, bl);
        return this;
    }
}

