/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class NodesWithSameName
extends Test {
    protected static int SAME_NAME = 801;
    private Map<String, List<Node>> namesToNodes;

    public NodesWithSameName() {
        super(I18n.tr("Nodes with same name", new Object[0]), I18n.tr("This test finds nodes that have the same name (might be duplicates).", new Object[0]));
    }

    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.namesToNodes = new HashMap<String, List<Node>>();
    }

    public void visit(Node node) {
        if (!node.isUsable()) {
            return;
        }
        String string = node.get("name");
        String string2 = node.get("traffic_sign");
        String string3 = node.get("highway");
        if (string == null || string2 != null && string2.equals("city_limit") || string3 != null && string3.equals("bus_stop")) {
            return;
        }
        List<Node> list = this.namesToNodes.get(string);
        if (list == null) {
            list = new ArrayList<Node>();
            this.namesToNodes.put(string, list);
        }
        list.add(node);
    }

    public void endTest() {
        block0: for (List<Node> list : this.namesToNodes.values()) {
            if (list.size() <= 1) continue;
            HashSet<String> hashSet = new HashSet<String>();
            for (Node node : list) {
                String string = node.get("ref");
                if (string != null && hashSet.add(string)) continue;
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Nodes with same name", new Object[0]), SAME_NAME, list));
                continue block0;
            }
        }
        super.endTest();
        this.namesToNodes = null;
    }
}

