/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM_France_DOM
extends AbstractProjection
implements ProjectionSubPrefs {
    private static final String FortMarigotName = I18n.tr("Guadeloupe Fort-Marigot 1949", new Object[0]);
    private static final String SainteAnneName = I18n.tr("Guadeloupe Ste-Anne 1948", new Object[0]);
    private static final String MartiniqueName = I18n.tr("Martinique Fort Desaix 1952", new Object[0]);
    private static final String Reunion92Name = I18n.tr("Reunion RGR92", new Object[0]);
    private static final String Guyane92Name = I18n.tr("Guyane RGFG95", new Object[0]);
    private static final String[] utmGeodesicsNames = new String[]{FortMarigotName, SainteAnneName, MartiniqueName, Reunion92Name, Guyane92Name};
    private static final Bounds FortMarigotBounds = new Bounds(new LatLon(17.6, -63.25), new LatLon(18.5, -62.5));
    private static final Bounds SainteAnneBounds = new Bounds(new LatLon(15.8, -61.9), new LatLon(16.6, -60.9));
    private static final Bounds MartiniqueBounds = new Bounds(new LatLon(14.25, -61.25), new LatLon(15.025, -60.725));
    private static final Bounds ReunionBounds = new Bounds(new LatLon(-25.92, 37.58), new LatLon(-10.6, 58.27));
    private static final Bounds GuyaneBounds = new Bounds(new LatLon(2.16, -54.0), new LatLon(9.06, -49.62));
    private static final Bounds[] utmBounds = new Bounds[]{FortMarigotBounds, SainteAnneBounds, MartiniqueBounds, ReunionBounds, GuyaneBounds};
    private static final Integer FortMarigotEPSG = 2969;
    private static final Integer SainteAnneEPSG = 2970;
    private static final Integer MartiniqueEPSG = 2973;
    private static final Integer ReunionEPSG = 2975;
    private static final Integer GuyaneEPSG = 2972;
    private static final Integer[] utmEPSGs = new Integer[]{FortMarigotEPSG, SainteAnneEPSG, MartiniqueEPSG, ReunionEPSG, GuyaneEPSG};
    private static final Datum FortMarigotDatum = new ThreeParameterDatum("FortMarigot Datum", null, Ellipsoid.hayford, 136.596, 248.148, -429.789);
    private static final Datum SainteAnneDatum = new SevenParameterDatum("SainteAnne Datum", null, Ellipsoid.hayford, -472.29, -5.63, -304.12, 0.4362, -0.8374, 0.2563, 1.8984);
    private static final Datum MartiniqueDatum = new SevenParameterDatum("Martinique Datum", null, Ellipsoid.hayford, 126.926, 547.939, 130.409, -2.7867, 5.16124, -0.85844, 13.82265);
    private static final Datum ReunionDatum = GRS80Datum.INSTANCE;
    private static final Datum GuyaneDatum = GRS80Datum.INSTANCE;
    private static final Datum[] utmDatums = new Datum[]{FortMarigotDatum, SainteAnneDatum, MartiniqueDatum, ReunionDatum, GuyaneDatum};
    private static final int[] utmZones = new int[]{20, 20, 20, 40, 22};
    private static int zone;
    private boolean isNorth;
    public static final int DEFAULT_GEODESIC = 0;
    public int currentGeodesic;

    public UTM_France_DOM() {
        this.updateParameters(0);
    }

    public void updateParameters(int n) {
        this.currentGeodesic = n;
        this.datum = utmDatums[n];
        this.ellps = this.datum.getEllipsoid();
        this.proj = new TransverseMercator(this.ellps);
        this.isNorth = n != 3;
        zone = utmZones[n];
        this.x_0 = 500000.0;
        this.y_0 = this.isNorth ? 0.0 : 1.0E7;
        this.lon_0 = 6 * zone - 183;
        this.k_0 = 0.9996;
    }

    public int getCurrentGeodesic() {
        return this.currentGeodesic;
    }

    @Override
    public String toString() {
        return I18n.tr("UTM France (DOM)", new Object[0]);
    }

    @Override
    public String getCacheDirectoryName() {
        return this.toString();
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return utmBounds[this.currentGeodesic];
    }

    @Override
    public Integer getEpsgCode() {
        return utmEPSGs[this.currentGeodesic];
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.currentGeodesic;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<String> jComboBox = new JComboBox<String>(utmGeodesicsNames);
        jComboBox.setSelectedIndex(this.currentGeodesic);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("UTM Geodesic system", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        this.currentGeodesic = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Integer.toString(this.currentGeodesic + 1));
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[utmEPSGs.length];
        for (int i = 0; i < utmEPSGs.length; ++i) {
            stringArray[i] = "EPSG:" + utmEPSGs[i];
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (int i = 0; i < utmEPSGs.length; ++i) {
            if (!("EPSG:" + utmEPSGs[i]).equals(string)) continue;
            return Collections.singleton(Integer.toString(i + 1));
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        int n = 0;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((n = Integer.parseInt(string = iterator.next()) - 1) < 0 || n >= utmEPSGs.length)) {
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.updateParameters(n);
    }
}

