/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable,
ProjectionChangeListener {
    private static final int MAX_SINGLE_EVENTS = 30;
    private static final int MAX_EVENTS = 1000;
    private Storage<OsmPrimitive> allPrimitives = new Storage<OsmPrimitive>(new IdHash(), true);
    private Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new IdHash());
    private CopyOnWriteArrayList<DataSetListener> listeners = new CopyOnWriteArrayList();
    private Collection<WaySegment> highlightedVirtualNodes = new LinkedList<WaySegment>();
    private Collection<WaySegment> highlightedWaySegments = new LinkedList<WaySegment>();
    private int updateCount;
    private final List<AbstractDatasetChangedEvent> cachedEvents = new ArrayList<AbstractDatasetChangedEvent>();
    private int highlightUpdateCount;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object selectionLock = new Object();
    private final LinkedList<Collection<? extends OsmPrimitive>> selectionHistory = new LinkedList();
    private AutoCompletionManager autocomplete;
    private String version;
    private Map<String, String> changeSetTags = new HashMap<String, String>();
    private QuadBuckets<Node> nodes = new QuadBuckets();
    private QuadBuckets<Way> ways = new QuadBuckets();
    private Collection<Relation> relations = new ArrayList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    @Deprecated
    public static final Collection<SelectionChangedListener> selListeners = new CopyOnWriteArrayList<SelectionChangedListener>();
    private LinkedHashSet<OsmPrimitive> selectedPrimitives = new LinkedHashSet();
    private Collection<OsmPrimitive> selectionSnapshot;

    public DataSet() {
        Main.addProjectionChangeListener(this);
    }

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public int getHighlightUpdateCount() {
        return this.highlightUpdateCount;
    }

    public LinkedList<Collection<? extends OsmPrimitive>> getSelectionHistory() {
        return this.selectionHistory;
    }

    public void clearSelectionHistory() {
        this.selectionHistory.clear();
    }

    public AutoCompletionManager getAutoCompletionManager() {
        if (this.autocomplete == null) {
            this.autocomplete = new AutoCompletionManager(this);
            this.addDataSetListener(this.autocomplete);
        }
        return this.autocomplete;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public Map<String, String> getChangeSetTags() {
        return this.changeSetTags;
    }

    public void addChangeSetTag(String string, String string2) {
        this.changeSetTags.put(string, string2);
    }

    private <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<OsmPrimitive> predicate) {
        return new SubclassFilteredCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(OsmPrimitive.nodePredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> searchNodes(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Node> list = this.nodes.search(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(OsmPrimitive.wayPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Way> searchWays(BBox bBox) {
        this.lock.readLock().lock();
        try {
            List<Way> list = this.ways.search(bBox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(OsmPrimitive.relationPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relation> searchRelations(BBox bBox) {
        this.lock.readLock().lock();
        try {
            ArrayList<Relation> arrayList = new ArrayList<Relation>();
            for (Relation relation : this.relations) {
                if (!relation.getBBox().intersects(bBox)) continue;
                arrayList.add(relation);
            }
            ArrayList<Relation> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(OsmPrimitive.allPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedCompletePredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPhysicalPredicate);
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(OsmPrimitive.modifiedPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimitive(OsmPrimitive osmPrimitive) {
        this.beginUpdate();
        try {
            if (this.getPrimitiveById(osmPrimitive) != null) {
                throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", osmPrimitive.toString()));
            }
            osmPrimitive.updatePosition();
            boolean bl = false;
            if (osmPrimitive instanceof Node) {
                bl = this.nodes.add((Node)osmPrimitive);
            } else if (osmPrimitive instanceof Way) {
                bl = this.ways.add((Way)osmPrimitive);
            } else if (osmPrimitive instanceof Relation) {
                bl = this.relations.add((Relation)osmPrimitive);
            }
            if (!bl) {
                throw new RuntimeException("failed to add primitive: " + osmPrimitive);
            }
            this.allPrimitives.add(osmPrimitive);
            osmPrimitive.setDataset(this);
            this.firePrimitivesAdded(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimitive(PrimitiveId primitiveId) {
        this.beginUpdate();
        try {
            OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
            if (osmPrimitive == null) {
                return;
            }
            boolean bl = false;
            if (osmPrimitive instanceof Node) {
                bl = this.nodes.remove(osmPrimitive);
            } else if (osmPrimitive instanceof Way) {
                bl = this.ways.remove(osmPrimitive);
            } else if (osmPrimitive instanceof Relation) {
                bl = this.relations.remove(osmPrimitive);
            }
            if (!bl) {
                throw new RuntimeException("failed to remove primitive: " + osmPrimitive);
            }
            Object object = this.selectionLock;
            synchronized (object) {
                this.selectedPrimitives.remove(osmPrimitive);
                this.selectionSnapshot = null;
            }
            this.allPrimitives.remove(osmPrimitive);
            osmPrimitive.setDataset(null);
            this.firePrimitivesRemoved(Collections.singletonList(osmPrimitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public static void addSelectionListener(SelectionChangedListener selectionChangedListener) {
        ((CopyOnWriteArrayList)selListeners).addIfAbsent(selectionChangedListener);
    }

    public static void removeSelectionListener(SelectionChangedListener selectionChangedListener) {
        selListeners.remove(selectionChangedListener);
    }

    public void fireSelectionChanged() {
        Collection<OsmPrimitive> collection = this.getSelected();
        for (SelectionChangedListener selectionChangedListener : selListeners) {
            selectionChangedListener.selectionChanged(collection);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        return new FilteredCollection<OsmPrimitive>(this.getSelected(), new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive instanceof Node || osmPrimitive instanceof Way;
            }
        });
    }

    public Collection<WaySegment> getHighlightedVirtualNodes() {
        return Collections.unmodifiableCollection(this.highlightedVirtualNodes);
    }

    public Collection<WaySegment> getHighlightedWaySegments() {
        return Collections.unmodifiableCollection(this.highlightedWaySegments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OsmPrimitive> getSelected() {
        Collection<OsmPrimitive> collection;
        Object object = this.selectionLock;
        synchronized (object) {
            if (this.selectionSnapshot == null) {
                this.selectionSnapshot = Collections.unmodifiableList(new ArrayList<OsmPrimitive>(this.selectedPrimitives));
            }
            collection = this.selectionSnapshot;
        }
        return collection;
    }

    public Collection<Node> getSelectedNodes() {
        return new SubclassFilteredCollection(this.getSelected(), OsmPrimitive.nodePredicate);
    }

    public Collection<Way> getSelectedWays() {
        return new SubclassFilteredCollection(this.getSelected(), OsmPrimitive.wayPredicate);
    }

    public Collection<Relation> getSelectedRelations() {
        return new SubclassFilteredCollection(this.getSelected(), OsmPrimitive.relationPredicate);
    }

    public boolean selectionEmpty() {
        return this.selectedPrimitives.isEmpty();
    }

    public boolean isSelected(OsmPrimitive osmPrimitive) {
        return this.selectedPrimitives.contains(osmPrimitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleSelected(Collection<? extends PrimitiveId> collection) {
        boolean bl = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : collection) {
                bl |= this.__toggleSelected(primitiveId);
            }
            if (bl) {
                this.selectionSnapshot = null;
            }
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void toggleSelected(PrimitiveId ... primitiveIdArray) {
        this.toggleSelected(Arrays.asList(primitiveIdArray));
    }

    private boolean __toggleSelected(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
        if (osmPrimitive == null) {
            return false;
        }
        if (!this.selectedPrimitives.remove(osmPrimitive)) {
            this.selectedPrimitives.add(osmPrimitive);
        }
        this.selectionSnapshot = null;
        return true;
    }

    public void setHighlightedVirtualNodes(Collection<WaySegment> collection) {
        if (this.highlightedVirtualNodes.isEmpty() && collection.isEmpty()) {
            return;
        }
        this.highlightedVirtualNodes = collection;
        ++this.highlightUpdateCount;
    }

    public void setHighlightedWaySegments(Collection<WaySegment> collection) {
        if (this.highlightedWaySegments.isEmpty() && collection.isEmpty()) {
            return;
        }
        this.highlightedWaySegments = collection;
        ++this.highlightUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        boolean bl2;
        Object object = this.selectionLock;
        synchronized (object) {
            boolean bl3 = this.selectedPrimitives.isEmpty();
            this.selectedPrimitives = new LinkedHashSet();
            boolean bl4 = bl2 = this.addSelected(collection, false) || !bl3 && this.selectedPrimitives.isEmpty();
            if (bl2) {
                this.selectionSnapshot = null;
            }
        }
        if (bl2 && bl) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(Collection<? extends PrimitiveId> collection) {
        this.setSelected(collection, true);
    }

    public void setSelected(PrimitiveId ... primitiveIdArray) {
        if (primitiveIdArray.length == 1 && primitiveIdArray[0] == null) {
            this.setSelected(new PrimitiveId[0]);
            return;
        }
        List<PrimitiveId> list = Arrays.asList(primitiveIdArray);
        this.setSelected(list);
    }

    public void addSelected(Collection<? extends PrimitiveId> collection) {
        this.addSelected(collection, true);
    }

    public void addSelected(PrimitiveId ... primitiveIdArray) {
        this.addSelected(Arrays.asList(primitiveIdArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSelected(Collection<? extends PrimitiveId> collection, boolean bl) {
        boolean bl2 = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : collection) {
                OsmPrimitive osmPrimitive = this.getPrimitiveByIdChecked(primitiveId);
                if (osmPrimitive == null) continue;
                bl2 |= this.selectedPrimitives.add(osmPrimitive);
            }
            if (bl2) {
                this.selectionSnapshot = null;
            }
        }
        if (bl && bl2) {
            this.fireSelectionChanged();
        }
        return bl2;
    }

    public void clearHighlightedVirtualNodes() {
        this.setHighlightedVirtualNodes(new ArrayList<WaySegment>());
    }

    public void clearHighlightedWaySegments() {
        this.setHighlightedWaySegments(new ArrayList<WaySegment>());
    }

    public void clearSelection(PrimitiveId ... primitiveIdArray) {
        this.clearSelection(Arrays.asList(primitiveIdArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection(Collection<? extends PrimitiveId> collection) {
        boolean bl = false;
        Object object = this.selectionLock;
        synchronized (object) {
            for (PrimitiveId primitiveId : collection) {
                OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
                if (osmPrimitive == null) continue;
                bl |= this.selectedPrimitives.remove(osmPrimitive);
            }
            if (bl) {
                this.selectionSnapshot = null;
            }
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        if (!this.selectedPrimitives.isEmpty()) {
            Object object = this.selectionLock;
            synchronized (object) {
                this.selectedPrimitives.clear();
                this.selectionSnapshot = null;
            }
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet clone() {
        this.getReadLock().lock();
        try {
            ArrayList<Node> arrayList;
            OsmPrimitive osmPrimitive;
            DataSet dataSet = new DataSet();
            HashMap<OsmPrimitive, OsmPrimitive> hashMap = new HashMap<OsmPrimitive, OsmPrimitive>();
            for (Node object : this.nodes) {
                osmPrimitive = new Node(object);
                hashMap.put(object, osmPrimitive);
                dataSet.addPrimitive(osmPrimitive);
            }
            for (Way way : this.ways) {
                osmPrimitive = new Way(way);
                hashMap.put(way, osmPrimitive);
                arrayList = new ArrayList<Node>();
                for (Node node : way.getNodes()) {
                    arrayList.add((Node)hashMap.get(node));
                }
                ((Way)osmPrimitive).setNodes(arrayList);
                dataSet.addPrimitive(osmPrimitive);
            }
            for (Relation relation : this.relations) {
                osmPrimitive = new Relation(relation, relation.isNew());
                ((Relation)osmPrimitive).setMembers(null);
                hashMap.put(relation, osmPrimitive);
                dataSet.addPrimitive(osmPrimitive);
            }
            for (Relation relation : this.relations) {
                osmPrimitive = (Relation)hashMap.get(relation);
                arrayList = new ArrayList();
                for (RelationMember relationMember : relation.getMembers()) {
                    arrayList.add((Node)((Object)new RelationMember(relationMember.getRole(), (OsmPrimitive)hashMap.get(relationMember.getMember()))));
                }
                ((Relation)osmPrimitive).setMembers(arrayList);
            }
            for (DataSource dataSource : this.dataSources) {
                dataSet.dataSources.add(new DataSource(dataSource.bounds, dataSource.origin));
            }
            dataSet.version = this.version;
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : this.dataSources) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public OsmPrimitive getPrimitiveById(long l, OsmPrimitiveType osmPrimitiveType) {
        return this.getPrimitiveById(new SimplePrimitiveId(l, osmPrimitiveType));
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return this.primitivesMap.get(primitiveId);
    }

    @Deprecated
    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId, boolean bl) {
        OsmPrimitive osmPrimitive = this.primitivesMap.get(primitiveId);
        if (osmPrimitive == null && bl) {
            switch (primitiveId.getType()) {
                case NODE: {
                    osmPrimitive = new Node(primitiveId.getUniqueId(), true);
                    break;
                }
                case WAY: {
                    osmPrimitive = new Way(primitiveId.getUniqueId(), true);
                    break;
                }
                case RELATION: {
                    osmPrimitive = new Relation(primitiveId.getUniqueId(), true);
                }
            }
            this.addPrimitive(osmPrimitive);
        }
        return osmPrimitive;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive osmPrimitive = this.getPrimitiveById(primitiveId);
        if (osmPrimitive == null) {
            System.out.println(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this at http://josm.openstreetmap.de/. This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId())}));
            new Exception().printStackTrace();
        }
        return osmPrimitive;
    }

    private void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkNodeFromWays(Node node) {
        this.beginUpdate();
        try {
            for (Way way : this.ways) {
                List<Node> list = way.getNodes();
                if (!list.remove(node)) continue;
                if (list.size() < 2) {
                    this.deleteWay(way);
                    continue;
                }
                way.setNodes(list);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkPrimitiveFromRelations(OsmPrimitive osmPrimitive) {
        this.beginUpdate();
        try {
            for (Relation relation : this.relations) {
                List<RelationMember> list = relation.getMembers();
                Iterator<RelationMember> iterator = list.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    RelationMember relationMember = iterator.next();
                    if (!relationMember.getMember().equals(osmPrimitive)) continue;
                    iterator.remove();
                    bl = true;
                }
                if (!bl) continue;
                relation.setMembers(list);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkReferencesToPrimitive(OsmPrimitive osmPrimitive) {
        this.beginUpdate();
        try {
            if (osmPrimitive instanceof Node) {
                this.unlinkNodeFromWays((Node)osmPrimitive);
                this.unlinkPrimitiveFromRelations(osmPrimitive);
            } else {
                this.unlinkPrimitiveFromRelations(osmPrimitive);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean isModified() {
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            if (!osmPrimitive.isModified()) continue;
            return true;
        }
        return false;
    }

    private void reindexNode(Node node, LatLon latLon, EastNorth eastNorth) {
        if (!this.nodes.remove(node)) {
            throw new RuntimeException("Reindexing node failed to remove");
        }
        node.setCoorInternal(latLon, eastNorth);
        if (!this.nodes.add(node)) {
            throw new RuntimeException("Reindexing node failed to add");
        }
        for (OsmPrimitive osmPrimitive : node.getReferrers()) {
            if (osmPrimitive instanceof Way) {
                this.reindexWay((Way)osmPrimitive);
                continue;
            }
            this.reindexRelation((Relation)osmPrimitive);
        }
    }

    private void reindexWay(Way way) {
        BBox bBox = way.getBBox();
        if (!this.ways.remove(way)) {
            throw new RuntimeException("Reindexing way failed to remove");
        }
        way.updatePosition();
        if (!this.ways.add(way)) {
            throw new RuntimeException("Reindexing way failed to add");
        }
        if (!way.getBBox().equals(bBox)) {
            for (OsmPrimitive osmPrimitive : way.getReferrers()) {
                this.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    private void reindexRelation(Relation relation) {
        BBox bBox = relation.getBBox();
        relation.updatePosition();
        if (!bBox.equals(relation.getBBox())) {
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                this.reindexRelation((Relation)osmPrimitive);
            }
        }
    }

    public void addDataSetListener(DataSetListener dataSetListener) {
        this.listeners.addIfAbsent(dataSetListener);
    }

    public void removeDataSetListener(DataSetListener dataSetListener) {
        this.listeners.remove(dataSetListener);
    }

    public void beginUpdate() {
        this.lock.writeLock().lock();
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            if (this.updateCount == 0) {
                ArrayList<AbstractDatasetChangedEvent> arrayList = new ArrayList<AbstractDatasetChangedEvent>(this.cachedEvents);
                this.cachedEvents.clear();
                this.lock.writeLock().unlock();
                if (!arrayList.isEmpty()) {
                    this.lock.readLock().lock();
                    try {
                        if (arrayList.size() < 30) {
                            for (AbstractDatasetChangedEvent abstractDatasetChangedEvent : arrayList) {
                                this.fireEventToListeners(abstractDatasetChangedEvent);
                            }
                        }
                        if (arrayList.size() == 1000) {
                            this.fireEventToListeners(new DataChangedEvent(this));
                        }
                        this.fireEventToListeners(new DataChangedEvent(this, arrayList));
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                }
            } else {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEventToListeners(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        for (DataSetListener dataSetListener : this.listeners) {
            abstractDatasetChangedEvent.fire(dataSetListener);
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        if (this.updateCount == 0) {
            throw new AssertionError((Object)"dataset events can be fired only when dataset is locked");
        }
        if (this.cachedEvents.size() < 1000) {
            this.cachedEvents.add(abstractDatasetChangedEvent);
        }
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesAddedEvent(this, collection, bl));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> collection, boolean bl) {
        this.fireEvent(new PrimitivesRemovedEvent(this, collection, bl));
    }

    void fireTagsChanged(OsmPrimitive osmPrimitive, Map<String, String> map) {
        this.fireEvent(new TagsChangedEvent(this, osmPrimitive, map));
    }

    void fireRelationMembersChanged(Relation relation) {
        this.reindexRelation(relation);
        this.fireEvent(new RelationMembersChangedEvent(this, relation));
    }

    void fireNodeMoved(Node node, LatLon latLon, EastNorth eastNorth) {
        this.reindexNode(node, latLon, eastNorth);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive osmPrimitive, int n, int n2) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(osmPrimitive), n, n2));
    }

    void fireHighlightingChanged(OsmPrimitive osmPrimitive) {
        ++this.highlightUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateEastNorthCache() {
        if (Main.getProjection() == null) {
            return;
        }
        try {
            this.beginUpdate();
            for (Node node : Utils.filteredCollection(this.allPrimitives, Node.class)) {
                node.invalidateEastNorthCache();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDeletedPrimitives() {
        this.beginUpdate();
        try {
            if (this.cleanupDeleted(this.nodes.iterator()) | this.cleanupDeleted(this.ways.iterator()) | this.cleanupDeleted(this.relations.iterator())) {
                this.fireSelectionChanged();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupDeleted(Iterator<? extends OsmPrimitive> iterator) {
        boolean bl = false;
        Object object = this.selectionLock;
        synchronized (object) {
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = iterator.next();
                if (!osmPrimitive.isDeleted() || osmPrimitive.isVisible() && !osmPrimitive.isNew()) continue;
                this.selectedPrimitives.remove(osmPrimitive);
                this.selectionSnapshot = null;
                this.allPrimitives.remove(osmPrimitive);
                osmPrimitive.setDataset(null);
                bl = true;
                iterator.remove();
            }
            if (bl) {
                this.selectionSnapshot = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            this.clearSelection();
            for (OsmPrimitive osmPrimitive : this.allPrimitives) {
                osmPrimitive.setDataset(null);
            }
            this.nodes.clear();
            this.ways.clear();
            this.relations.clear();
            this.allPrimitives.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public void deleteInvisible() {
        for (OsmPrimitive osmPrimitive : this.allPrimitives) {
            if (osmPrimitive.isVisible()) continue;
            osmPrimitive.setDeleted(true);
        }
    }

    public List<Bounds> getDataSourceBounds() {
        ArrayList<Bounds> arrayList = new ArrayList<Bounds>(this.dataSources.size());
        for (DataSource dataSource : this.dataSources) {
            if (dataSource.bounds == null) continue;
            arrayList.add(dataSource.bounds);
        }
        return arrayList;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        this.invalidateEastNorthCache();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdHash
    implements Hash<PrimitiveId, OsmPrimitive> {
        private IdHash() {
        }

        @Override
        public int getHashCode(PrimitiveId primitiveId) {
            return (int)primitiveId.getUniqueId() ^ primitiveId.getType().hashCode();
        }

        @Override
        public boolean equals(PrimitiveId primitiveId, OsmPrimitive osmPrimitive) {
            if (primitiveId == null || osmPrimitive == null) {
                return false;
            }
            return primitiveId.getUniqueId() == osmPrimitive.getUniqueId() && primitiveId.getType() == osmPrimitive.getType();
        }
    }
}

