/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class Bounds {
    private double minLat;
    private double minLon;
    private double maxLat;
    private double maxLon;

    public LatLon getMin() {
        return new LatLon(this.minLat, this.minLon);
    }

    public LatLon getMax() {
        return new LatLon(this.maxLat, this.maxLon);
    }

    public Bounds(LatLon latLon, LatLon latLon2) {
        this(latLon.lat(), latLon.lon(), latLon2.lat(), latLon2.lon());
    }

    public Bounds(LatLon latLon) {
        this(latLon, latLon);
    }

    public Bounds(double d, double d2, double d3, double d4) {
        this.minLat = LatLon.roundToOsmPrecision(d);
        this.minLon = LatLon.roundToOsmPrecision(d2);
        this.maxLat = LatLon.roundToOsmPrecision(d3);
        this.maxLon = LatLon.roundToOsmPrecision(d4);
    }

    public Bounds(double[] dArray) {
        CheckParameterUtil.ensureParameterNotNull(dArray, "coords");
        if (dArray.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Expected array of length 4, got {0}", dArray.length));
        }
        this.minLat = LatLon.roundToOsmPrecision(dArray[0]);
        this.minLon = LatLon.roundToOsmPrecision(dArray[1]);
        this.maxLat = LatLon.roundToOsmPrecision(dArray[2]);
        this.maxLon = LatLon.roundToOsmPrecision(dArray[3]);
    }

    public Bounds(String string, String string2) throws IllegalArgumentException {
        this(string, string2, ParseMethod.MINLAT_MINLON_MAXLAT_MAXLON);
    }

    public Bounds(String string, String string2, ParseMethod parseMethod) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(string, "asString");
        String[] stringArray = string.split(string2);
        if (stringArray.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Exactly four doubles expected in string, got {0}: {1}", stringArray.length, string));
        }
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                dArray[i] = Double.parseDouble(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", stringArray[i]));
            }
        }
        switch (parseMethod) {
            case LEFT_BOTTOM_RIGHT_TOP: {
                this.minLat = Bounds.initLat(dArray[1]);
                this.minLon = Bounds.initLon(dArray[0]);
                this.maxLat = Bounds.initLat(dArray[3]);
                this.maxLon = Bounds.initLon(dArray[2]);
                break;
            }
            default: {
                this.minLat = Bounds.initLat(dArray[0]);
                this.minLon = Bounds.initLon(dArray[1]);
                this.maxLat = Bounds.initLat(dArray[2]);
                this.maxLon = Bounds.initLon(dArray[3]);
            }
        }
    }

    protected static double initLat(double d) {
        if (!LatLon.isValidLat(d)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", d));
        }
        return LatLon.roundToOsmPrecision(d);
    }

    protected static double initLon(double d) {
        if (!LatLon.isValidLon(d)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", d));
        }
        return LatLon.roundToOsmPrecision(d);
    }

    public Bounds(Bounds bounds) {
        this(bounds.getMin(), bounds.getMax());
    }

    public Bounds(Rectangle2D rectangle2D) {
        this(rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX());
    }

    public Bounds(LatLon latLon, double d, double d2) {
        CheckParameterUtil.ensureParameterNotNull(latLon, "center");
        if (d <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 exptected, got {1}", "latExtent", d));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 exptected, got {1}", "lonExtent", d2));
        }
        this.minLat = LatLon.roundToOsmPrecision(latLon.lat() - d / 2.0);
        this.minLon = LatLon.roundToOsmPrecision(latLon.lon() - d2 / 2.0);
        this.maxLat = LatLon.roundToOsmPrecision(latLon.lat() + d / 2.0);
        this.maxLon = LatLon.roundToOsmPrecision(latLon.lon() + d2 / 2.0);
    }

    public String toString() {
        return "Bounds[" + this.minLat + "," + this.minLon + "," + this.maxLat + "," + this.maxLon + "]";
    }

    public String toShortString(DecimalFormat decimalFormat) {
        return decimalFormat.format(this.minLat) + " " + decimalFormat.format(this.minLon) + " / " + decimalFormat.format(this.maxLat) + " " + decimalFormat.format(this.maxLon);
    }

    public LatLon getCenter() {
        return this.getMin().getCenter(this.getMax());
    }

    public void extend(LatLon latLon) {
        if (latLon.lat() < this.minLat) {
            this.minLat = LatLon.roundToOsmPrecision(latLon.lat());
        }
        if (latLon.lon() < this.minLon) {
            this.minLon = LatLon.roundToOsmPrecision(latLon.lon());
        }
        if (latLon.lat() > this.maxLat) {
            this.maxLat = LatLon.roundToOsmPrecision(latLon.lat());
        }
        if (latLon.lon() > this.maxLon) {
            this.maxLon = LatLon.roundToOsmPrecision(latLon.lon());
        }
    }

    public void extend(Bounds bounds) {
        this.extend(bounds.getMin());
        this.extend(bounds.getMax());
    }

    public boolean contains(LatLon latLon) {
        if (latLon.lat() < this.minLat || latLon.lon() < this.minLon) {
            return false;
        }
        return !(latLon.lat() > this.maxLat) && !(latLon.lon() > this.maxLon);
    }

    public boolean intersects(Bounds bounds) {
        return bounds.maxLat >= this.minLat && bounds.maxLon >= this.minLon && bounds.minLat <= this.maxLat && bounds.minLon <= this.maxLon;
    }

    public Rectangle2D.Double asRect() {
        return new Rectangle2D.Double(this.minLon, this.minLat, this.maxLon - this.minLon, this.maxLat - this.minLat);
    }

    public double getArea() {
        return (this.maxLon - this.minLon) * (this.maxLat - this.minLat);
    }

    public String encodeAsString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.minLat).append(string).append(this.minLon).append(string).append(this.maxLat).append(string).append(this.maxLon);
        return stringBuffer.toString();
    }

    public boolean isCollapsed() {
        return this.getMin().equals(this.getMax());
    }

    public boolean isOutOfTheWorld() {
        return this.minLat < -90.0 || this.minLat > 90.0 || this.maxLat < -90.0 || this.maxLat > 90.0 || this.minLon < -180.0 || this.minLon > 180.0 || this.maxLon < -180.0 || this.maxLon > 180.0;
    }

    private double toIntervalLat(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    private double toIntervalLon(double d) {
        if (d < -180.0 || d > 180.0) {
            if ((d = (d + 180.0) % 360.0) < 0.0) {
                d += 360.0;
            }
            return d - 180.0;
        }
        return d;
    }

    public void normalize() {
        this.minLat = this.toIntervalLat(this.minLat, -90.0, 90.0);
        this.maxLat = this.toIntervalLat(this.maxLat, -90.0, 90.0);
        this.minLon = this.toIntervalLon(this.minLon);
        this.maxLon = this.toIntervalLon(this.maxLon);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.maxLat);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxLon);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minLat);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minLon);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Bounds bounds = (Bounds)object;
        if (Double.doubleToLongBits(this.maxLat) != Double.doubleToLongBits(bounds.maxLat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLon) != Double.doubleToLongBits(bounds.maxLon)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLat) != Double.doubleToLongBits(bounds.minLat)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLon) == Double.doubleToLongBits(bounds.minLon);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParseMethod {
        MINLAT_MINLON_MAXLAT_MAXLON,
        LEFT_BOTTOM_RIGHT_TOP;

    }
}

