/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.InspectPrimitiveDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoAction
extends JosmAction {
    public InfoAction() {
        super(I18n.tr("Advanced info", new Object[0]), "about", I18n.tr("Display advanced object information about OSM nodes, ways, or relations.", new Object[0]), Shortcut.registerShortcut("core:info", I18n.tr("Advanced info", new Object[0]), 73, 1), false);
        this.putValue("help", HelpUtil.ht("/Action/InfoAboutElements"));
        this.putValue("toolbar", "action/info");
        Main.toolbar.register(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = InfoAction.getCurrentDataSet();
        if (dataSet != null) {
            new InspectPrimitiveDialog(dataSet.getSelected(), Main.map.mapView.getEditLayer()).showDialog();
        }
    }

    @Override
    public void updateEnabledState() {
        if (InfoAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(InfoAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(!collection.isEmpty());
    }
}

