/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BingAerialTileSource
extends AbstractTMSTileSource {
    private static String API_KEY = "Arzdiw4nlOJzRwOz__qailc8NiR31Tt51dN2D7cm57NrnceZnCpgOkmJhNpGoppU";
    private static Future<List<Attribution>> attributions;
    private static String imageUrlTemplate;
    private static Integer imageryZoomMax;
    private static String[] subdomains;
    private static final Pattern subdomainPattern;
    private static final Pattern quadkeyPattern;
    private static final Pattern culturePattern;

    public BingAerialTileSource() {
        super("Bing Aerial Maps", "http://example.com/");
        if (attributions == null) {
            attributions = Executors.newSingleThreadExecutor().submit(new Callable<List<Attribution>>(){

                @Override
                public List<Attribution> call() throws Exception {
                    List list = null;
                    int n = 1;
                    while (true) {
                        try {
                            list = BingAerialTileSource.this.loadAttributionText();
                            System.out.println("Successfully loaded Bing attribution data.");
                            return list;
                        }
                        catch (IOException iOException) {
                            System.err.println("Could not connect to Bing API. Will retry in " + n + " seconds.");
                            Thread.sleep((long)n * 1000L);
                            n *= 2;
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) throws IOException {
        int n4 = (n + n2 + n3) % subdomains.length;
        String string = subdomains[n4];
        String string2 = new String(imageUrlTemplate);
        string2 = subdomainPattern.matcher(string2).replaceAll(string);
        string2 = quadkeyPattern.matcher(string2).replaceAll(BingAerialTileSource.computeQuadTree(n, n2, n3));
        return string2;
    }

    private List<Attribution> loadAttributionText() throws IOException {
        try {
            URL uRL = new URL("http://dev.virtualearth.net/REST/v1/Imagery/Metadata/Aerial?include=ImageryProviders&output=xml&key=" + API_KEY);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            imageUrlTemplate = xPath.compile("//ImageryMetadata/ImageUrl/text()").evaluate(document);
            imageUrlTemplate = culturePattern.matcher(imageUrlTemplate).replaceAll(Locale.getDefault().toString());
            imageryZoomMax = Integer.parseInt(xPath.compile("//ImageryMetadata/ZoomMax/text()").evaluate(document));
            NodeList nodeList = (NodeList)xPath.compile("//ImageryMetadata/ImageUrlSubdomains/string/text()").evaluate(document, XPathConstants.NODESET);
            subdomains = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                BingAerialTileSource.subdomains[i] = nodeList.item(i).getNodeValue();
            }
            XPathExpression xPathExpression = xPath.compile("Attribution/text()");
            XPathExpression xPathExpression2 = xPath.compile("CoverageArea");
            XPathExpression xPathExpression3 = xPath.compile("ZoomMin/text()");
            XPathExpression xPathExpression4 = xPath.compile("ZoomMax/text()");
            XPathExpression xPathExpression5 = xPath.compile("BoundingBox/SouthLatitude/text()");
            XPathExpression xPathExpression6 = xPath.compile("BoundingBox/WestLongitude/text()");
            XPathExpression xPathExpression7 = xPath.compile("BoundingBox/NorthLatitude/text()");
            XPathExpression xPathExpression8 = xPath.compile("BoundingBox/EastLongitude/text()");
            NodeList nodeList2 = (NodeList)xPath.compile("//ImageryMetadata/ImageryProvider").evaluate(document, XPathConstants.NODESET);
            ArrayList<Attribution> arrayList = new ArrayList<Attribution>(nodeList2.getLength());
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                String string = xPathExpression.evaluate(node);
                NodeList nodeList3 = (NodeList)xPathExpression2.evaluate(node, XPathConstants.NODESET);
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Node node2 = nodeList3.item(j);
                    Attribution attribution = new Attribution();
                    attribution.attribution = string;
                    attribution.maxZoom = Integer.parseInt(xPathExpression4.evaluate(node2));
                    attribution.minZoom = Integer.parseInt(xPathExpression3.evaluate(node2));
                    Double d = Double.parseDouble(xPathExpression5.evaluate(node2));
                    Double d2 = Double.parseDouble(xPathExpression7.evaluate(node2));
                    Double d3 = Double.parseDouble(xPathExpression6.evaluate(node2));
                    Double d4 = Double.parseDouble(xPathExpression8.evaluate(node2));
                    attribution.min = new Coordinate(d, d3);
                    attribution.max = new Coordinate(d2, d4);
                    arrayList.add(attribution);
                }
            }
            return arrayList;
        }
        catch (SAXException sAXException) {
            System.err.println("Could not parse Bing aerials attribution metadata.");
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        return null;
    }

    @Override
    public int getMaxZoom() {
        if (imageryZoomMax != null) {
            return imageryZoomMax;
        }
        return 22;
    }

    @Override
    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    @Override
    public boolean requiresAttribution() {
        return true;
    }

    @Override
    public String getAttributionLinkURL() {
        return "http://go.microsoft.com/?linkid=9710837";
    }

    @Override
    public Image getAttributionImage() {
        try {
            return ImageIO.read(this.getClass().getResourceAsStream("/org/openstreetmap/gui/jmapviewer/images/bing_maps.png"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getAttributionImageURL() {
        return "http://opengeodata.org/microsoft-imagery-details";
    }

    @Override
    public String getTermsOfUseText() {
        return null;
    }

    @Override
    public String getTermsOfUseURL() {
        return "http://opengeodata.org/microsoft-imagery-details";
    }

    @Override
    public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
        try {
            if (!attributions.isDone()) {
                return "Loading Bing attribution data...";
            }
            if (attributions.get() == null) {
                return "Error loading Bing attribution data";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Attribution attribution : attributions.get()) {
                if (n > attribution.maxZoom || n < attribution.minZoom || !(coordinate.getLon() < attribution.max.getLon()) || !(coordinate2.getLon() > attribution.min.getLon()) || !(coordinate.getLat() > attribution.min.getLat()) || !(coordinate2.getLat() < attribution.max.getLat())) continue;
                stringBuilder.append(attribution.attribution);
                stringBuilder.append(" ");
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Error loading Bing attribution data";
        }
    }

    static String computeQuadTree(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i > 0; --i) {
            char c = '0';
            int n4 = 1 << i - 1;
            if ((n2 & n4) != 0) {
                c = (char)(c + 1);
            }
            if ((n3 & n4) != 0) {
                c = (char)(c + 2);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static {
        subdomainPattern = Pattern.compile("\\{subdomain\\}");
        quadkeyPattern = Pattern.compile("\\{quadkey\\}");
        culturePattern = Pattern.compile("\\{culture\\}");
    }

    class Attribution {
        String attribution;
        int minZoom;
        int maxZoom;
        Coordinate min;
        Coordinate max;

        Attribution() {
        }
    }
}

