/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.ClipPath;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.TransformableElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.net.URI;
import java.util.List;

public abstract class RenderableElement
extends TransformableElement {
    AffineTransform cachedXform = null;
    Shape cachedClip = null;
    public static final int VECTOR_EFFECT_NONE = 0;
    public static final int VECTOR_EFFECT_NON_SCALING_STROKE = 1;
    int vectorEffect;

    public RenderableElement() {
    }

    public RenderableElement(String string, SVGElement sVGElement) {
        super(string, sVGElement);
    }

    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        this.vectorEffect = this.getPres(styleAttribute.setName("vector-effect")) ? ("non-scaling-stroke".equals(styleAttribute.getStringValue()) ? 1 : 0) : 0;
    }

    public abstract void render(Graphics2D var1) throws SVGException;

    abstract void pick(Point2D var1, boolean var2, List var3) throws SVGException;

    abstract void pick(Rectangle2D var1, AffineTransform var2, boolean var3, List var4) throws SVGException;

    public abstract Rectangle2D getBoundingBox() throws SVGException;

    protected void beginLayer(Graphics2D graphics2D) throws SVGException {
        Serializable serializable;
        Object object;
        if (this.xform != null) {
            this.cachedXform = graphics2D.getTransform();
            graphics2D.transform(this.xform);
        }
        StyleAttribute styleAttribute = new StyleAttribute();
        Shape shape = null;
        int n = 0;
        if (this.getStyle(styleAttribute.setName("clip-path")) && (object = styleAttribute.getURIValue(this.getXMLBase())) != null) {
            serializable = (ClipPath)this.diagram.getUniverse().getElement((URI)object);
            shape = ((ClipPath)serializable).getClipPathShape();
            n = ((ClipPath)serializable).getClipPathUnits();
        }
        if (shape != null) {
            if (n == 1 && this instanceof ShapeElement) {
                object = ((ShapeElement)this).getBoundingBox();
                serializable = new AffineTransform();
                ((AffineTransform)serializable).scale(((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight());
                shape = ((AffineTransform)serializable).createTransformedShape(shape);
            }
            this.cachedClip = graphics2D.getClip();
            object = new Area(this.cachedClip);
            ((Area)object).intersect(new Area(shape));
            graphics2D.setClip((Shape)object);
        }
    }

    protected void finishLayer(Graphics2D graphics2D) {
        if (this.cachedClip != null) {
            graphics2D.setClip(this.cachedClip);
        }
        if (this.cachedXform != null) {
            graphics2D.setTransform(this.cachedXform);
        }
    }
}

