/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryReader {
    private String source;

    public ImageryReader(String string) {
        this.source = string;
    }

    public List<ImageryInfo> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            MirroredInputStream mirroredInputStream = new MirroredInputStream(this.source);
            InputSource inputSource = new InputSource(UTFInputStreamReader.create(mirroredInputStream, "UTF-8"));
            sAXParserFactory.newSAXParser().parse(inputSource, (DefaultHandler)parser);
            return parser.entries;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
    }

    private class Parser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private Stack<State> states;
        List<ImageryInfo> entries;
        boolean skipEntry;
        ImageryInfo entry;
        ImageryInfo.ImageryBounds bounds;
        Shape shape;
        List<String> projections;

        private Parser() {
        }

        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.projections = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            State state = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!string3.equals("imagery")) break;
                    state = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    if (!string3.equals("entry")) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    state = State.ENTRY;
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "type", "default", "url", "eula", "min-zoom", "max-zoom", "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url", "country-code").contains(string3)) {
                        state = State.ENTRY_ATTRIBUTE;
                        break;
                    }
                    if (string3.equals("bounds")) {
                        try {
                            this.bounds = new ImageryInfo.ImageryBounds(attributes.getValue("min-lat") + "," + attributes.getValue("min-lon") + "," + attributes.getValue("max-lat") + "," + attributes.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break;
                        }
                        state = State.BOUNDS;
                        break;
                    }
                    if (!string3.equals("projections")) break;
                    this.projections = new ArrayList<String>();
                    state = State.PROJECTIONS;
                    break;
                }
                case BOUNDS: {
                    if (!string3.equals("shape")) break;
                    this.shape = new Shape();
                    state = State.SHAPE;
                    break;
                }
                case SHAPE: {
                    if (!string3.equals("point")) break;
                    try {
                        this.shape.addPoint(attributes.getValue("lat"), attributes.getValue("lon"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case PROJECTIONS: {
                    if (!string3.equals("code")) break;
                    state = State.CODE;
                }
            }
            if (state == null) {
                state = State.UNKNOWN;
            }
            this.states.push(state);
            if (state == State.UNKNOWN && Utils.equal(attributes.getValue("mandatory"), "true")) {
                this.skipEntry = true;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) {
            switch (this.states.pop()) {
                case INIT: {
                    throw new RuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!string2.equals("entry")) break;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    if (string2.equals("name")) {
                        this.entry.setName(I18n.tr(this.accumulator.toString(), new Object[0]));
                        break;
                    }
                    if (string2.equals("type")) {
                        boolean bl = false;
                        for (ImageryInfo.ImageryType imageryType : ImageryInfo.ImageryType.values()) {
                            if (!Utils.equal(this.accumulator.toString(), imageryType.getUrlString())) continue;
                            this.entry.setImageryType(imageryType);
                            bl = true;
                            break;
                        }
                        if (bl) break;
                        this.skipEntry = true;
                        break;
                    }
                    if (string2.equals("default")) {
                        if (this.accumulator.toString().equals("true")) {
                            this.entry.setDefaultEntry(true);
                            break;
                        }
                        if (this.accumulator.toString().equals("false")) {
                            this.entry.setDefaultEntry(false);
                            break;
                        }
                        this.skipEntry = true;
                        break;
                    }
                    if (string2.equals("url")) {
                        this.entry.setUrl(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("eula")) {
                        this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("min-zoom") || string2.equals("max-zoom")) {
                        Integer n = null;
                        try {
                            n = Integer.parseInt(this.accumulator.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            n = null;
                        }
                        if (n == null) {
                            this.skipEntry = true;
                            break;
                        }
                        if (string2.equals("min-zoom")) {
                            this.entry.setDefaultMinZoom(n);
                            break;
                        }
                        this.entry.setDefaultMaxZoom(n);
                        break;
                    }
                    if (string2.equals("attribution-text")) {
                        this.entry.setAttributionText(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("attribution-url")) {
                        this.entry.setAttributionLinkURL(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("logo-image")) {
                        this.entry.setAttributionImage(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("logo-url") || string2.equals("terms-of-use-text")) break;
                    if (string2.equals("terms-of-use-url")) {
                        this.entry.setTermsOfUseURL(this.accumulator.toString());
                        break;
                    }
                    if (!string2.equals("country-code")) break;
                    this.entry.setCountryCode(this.accumulator.toString());
                    break;
                }
                case BOUNDS: {
                    this.entry.setBounds(this.bounds);
                    this.bounds = null;
                    break;
                }
                case SHAPE: {
                    this.bounds.addShape(this.shape);
                    this.shape = null;
                    break;
                }
                case CODE: {
                    this.projections.add(this.accumulator.toString());
                    break;
                }
                case PROJECTIONS: {
                    this.entry.setServerProjections(this.projections);
                    this.projections = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        PROJECTIONS,
        CODE,
        BOUNDS,
        SHAPE,
        UNKNOWN;

    }
}

