/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractTextComponentValidator
implements ActionListener,
FocusListener,
DocumentListener,
PropertyChangeListener {
    private static final Border ERROR_BORDER = BorderFactory.createLineBorder(Color.RED, 1);
    private static final Color ERROR_BACKGROUND = new Color(255, 224, 224);
    private JTextComponent tc;
    private Boolean valid = null;

    protected void feedbackInvalid(String string) {
        if (this.valid == null || this.valid.booleanValue()) {
            this.tc.setBorder(ERROR_BORDER);
            this.tc.setBackground(ERROR_BACKGROUND);
            this.tc.setToolTipText(string);
            this.valid = false;
        }
    }

    protected void feedbackDisabled() {
        this.feedbackValid(null);
    }

    protected void feedbackValid(String string) {
        if (this.valid == null || !this.valid.booleanValue()) {
            this.tc.setBorder(UIManager.getBorder("TextField.border"));
            this.tc.setBackground(UIManager.getColor("TextField.background"));
            this.tc.setToolTipText(string == null ? "" : string);
            this.valid = true;
        }
    }

    public JTextComponent getComponent() {
        return this.tc;
    }

    public AbstractTextComponentValidator(JTextComponent jTextComponent) throws IllegalArgumentException {
        this(jTextComponent, true);
    }

    public AbstractTextComponentValidator(JTextComponent jTextComponent, boolean bl) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(jTextComponent, "tc");
        this.tc = jTextComponent;
        jTextComponent.addFocusListener(this);
        jTextComponent.getDocument().addDocumentListener(this);
        if (bl && jTextComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jTextComponent;
            jTextField.addActionListener(this);
        }
        jTextComponent.addPropertyChangeListener("enabled", this);
    }

    public abstract void validate();

    public abstract boolean isValid();

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.validate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validate();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                this.validate();
            } else {
                this.feedbackDisabled();
            }
        }
    }
}

