/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HistoryOsmPrimitive
implements Comparable<HistoryOsmPrimitive> {
    private long id;
    private boolean visible;
    private String user;
    private long uid;
    private long changesetId;
    private Date timestamp;
    private long version;
    private HashMap<String, String> tags;

    protected void ensurePositiveLong(long l, String string) {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", string, l));
        }
    }

    public HistoryOsmPrimitive(long l, long l2, boolean bl, String string, long l3, long l4, Date date) throws IllegalArgumentException {
        this.ensurePositiveLong(l, "id");
        this.ensurePositiveLong(l2, "version");
        if (l3 != -1L) {
            this.ensurePositiveLong(l3, "uid");
        }
        CheckParameterUtil.ensureParameterNotNull(string, "user");
        CheckParameterUtil.ensureParameterNotNull(date, "timestamp");
        this.id = l;
        this.version = l2;
        this.visible = bl;
        this.user = string;
        this.uid = l3;
        this.changesetId = l4;
        this.timestamp = date;
        this.tags = new HashMap();
    }

    public HistoryOsmPrimitive(OsmPrimitive osmPrimitive) {
        this(osmPrimitive.getId(), osmPrimitive.getVersion(), osmPrimitive.isVisible(), osmPrimitive.getUser() == null ? null : osmPrimitive.getUser().getName(), osmPrimitive.getUser() == null ? 0L : osmPrimitive.getUser().getId(), osmPrimitive.getChangesetId(), osmPrimitive.getTimestamp());
    }

    public static HistoryOsmPrimitive forOsmPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            return new HistoryNode((Node)osmPrimitive);
        }
        if (osmPrimitive instanceof Way) {
            return new HistoryWay((Way)osmPrimitive);
        }
        if (osmPrimitive instanceof Relation) {
            return new HistoryRelation((Relation)osmPrimitive);
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.id, this.getType());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getUser() {
        return this.user;
    }

    public long getUid() {
        return this.uid;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean matches(long l, long l2) {
        return this.id == l && this.version == l2;
    }

    public boolean matches(long l) {
        return this.id == l;
    }

    public abstract OsmPrimitiveType getType();

    @Override
    public int compareTo(HistoryOsmPrimitive historyOsmPrimitive) {
        if (this.id != historyOsmPrimitive.id) {
            throw new ClassCastException(I18n.tr("Cannot compare primitive with ID ''{0}'' to primitive with ID ''{1}''.", historyOsmPrimitive.id, this.id));
        }
        return Long.valueOf(this.version).compareTo(historyOsmPrimitive.version);
    }

    public void put(String string, String string2) {
        this.tags.put(string, string2);
    }

    public String get(String string) {
        return this.tags.get(string);
    }

    public boolean hasTag(String string) {
        return this.tags.get(string) != null;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public void setTags(Map<String, String> map) {
        this.tags = map == null ? new HashMap() : new HashMap<String, String>(map);
    }

    public String getName() {
        if (this.get("name") != null) {
            return this.get("name");
        }
        return null;
    }

    public abstract String getDisplayName(HistoryNameFormatter var1);

    public String getLocalName() {
        String string = "name:" + Locale.getDefault().toString();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage();
        if (this.get(string) != null) {
            return this.get(string);
        }
        return this.getName();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        n = 31 * n + (int)(this.version ^ this.version >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HistoryOsmPrimitive)) {
            return false;
        }
        HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
        if (this.id != historyOsmPrimitive.id) {
            return false;
        }
        return this.version == historyOsmPrimitive.version;
    }
}

