/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class SearchCompiler {
    private boolean caseSensitive = false;
    private boolean regexSearch = false;
    private static String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private static String rxErrorMsgNoPos = I18n.marktr("The regex \"{0}\" had a parse error, full error:\n\n{1}");
    private PushbackTokenizer tokenizer;

    public SearchCompiler(boolean bl, boolean bl2, PushbackTokenizer pushbackTokenizer) {
        this.caseSensitive = bl;
        this.regexSearch = bl2;
        this.tokenizer = pushbackTokenizer;
    }

    public static Match compile(String string, boolean bl, boolean bl2) throws ParseError {
        return new SearchCompiler(bl, bl2, new PushbackTokenizer(new PushbackReader(new StringReader(string)))).parse();
    }

    public Match parse() throws ParseError {
        Match match = this.parseExpression();
        if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.EOF)) {
            throw new ParseError(I18n.tr("Unexpected token: {0}", new Object[]{this.tokenizer.nextToken()}));
        }
        if (match == null) {
            return new Always();
        }
        return match;
    }

    private Match parseExpression() throws ParseError {
        Match match = this.parseFactor();
        if (match == null) {
            return null;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.OR)) {
            return new Or(match, this.parseExpression(I18n.tr("Missing parameter for OR", new Object[0])));
        }
        Match match2 = this.parseExpression();
        if (match2 == null) {
            return match;
        }
        return new And(match, match2);
    }

    private Match parseExpression(String string) throws ParseError {
        Match match = this.parseExpression();
        if (match == null) {
            throw new ParseError(string);
        }
        return match;
    }

    private Match parseFactor() throws ParseError {
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.LEFT_PARENT)) {
            Match match = this.parseExpression();
            if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.RIGHT_PARENT)) {
                throw new ParseError(PushbackTokenizer.Token.RIGHT_PARENT, this.tokenizer.nextToken());
            }
            return match;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.NOT)) {
            return new Not(this.parseFactor(I18n.tr("Missing operator for NOT", new Object[0])));
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.KEY)) {
            String string = this.tokenizer.getText();
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.EQUALS)) {
                return new ExactKeyValue(this.regexSearch, string, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.COLON)) {
                if ("id".equals(string)) {
                    return new Id(this.tokenizer.readNumber(I18n.tr("Primitive id expected", new Object[0])));
                }
                if ("tags".equals(string)) {
                    PushbackTokenizer.Range range = this.tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0]));
                    return new TagCountRange((int)range.getStart(), (int)range.getEnd());
                }
                if ("nodes".equals(string)) {
                    PushbackTokenizer.Range range = this.tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0]));
                    return new NodeCountRange((int)range.getStart(), (int)range.getEnd());
                }
                if ("areasize".equals(string)) {
                    PushbackTokenizer.Range range = this.tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0]));
                    return new Area((int)range.getStart(), (int)range.getEnd());
                }
                if ("changeset".equals(string)) {
                    return new ChangesetId(this.tokenizer.readNumber(I18n.tr("Changeset id expected", new Object[0])));
                }
                if ("version".equals(string)) {
                    return new Version(this.tokenizer.readNumber(I18n.tr("Version expected", new Object[0])));
                }
                return this.parseKV(string, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.QUESTION_MARK)) {
                return new BooleanMatch(string, false);
            }
            if ("new".equals(string)) {
                return new New();
            }
            if ("modified".equals(string)) {
                return new Modified();
            }
            if ("incomplete".equals(string)) {
                return new Incomplete();
            }
            if ("untagged".equals(string)) {
                return new Untagged();
            }
            if ("selected".equals(string)) {
                return new Selected();
            }
            if ("closed".equals(string)) {
                return new Closed();
            }
            if ("child".equals(string)) {
                return new Child(this.parseFactor());
            }
            if ("parent".equals(string)) {
                return new Parent(this.parseFactor());
            }
            if ("indownloadedarea".equals(string)) {
                return new InDataSourceArea(false);
            }
            if ("allindownloadedarea".equals(string)) {
                return new InDataSourceArea(true);
            }
            if ("inview".equals(string)) {
                return new InView(false);
            }
            if ("allinview".equals(string)) {
                return new InView(true);
            }
            return new Any(string, this.regexSearch, this.caseSensitive);
        }
        return null;
    }

    private Match parseFactor(String string) throws ParseError {
        Match match = this.parseFactor();
        if (match == null) {
            throw new ParseError(string);
        }
        return match;
    }

    private Match parseKV(String string, String string2) throws ParseError {
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("type")) {
            return new ExactType(string2);
        }
        if (string.equals("user")) {
            return new UserMatch(string2);
        }
        if (string.equals("role")) {
            return new RoleMatch(string2);
        }
        return new KeyValue(string, string2, this.regexSearch, this.caseSensitive);
    }

    private static int regexFlags(boolean bl) {
        int n = 0;
        n |= 0x80;
        n |= 0x20;
        if (!bl) {
            n |= 0x42;
        }
        return n;
    }

    public static class ParseError
    extends Exception {
        public ParseError(String string) {
            super(string);
        }

        public ParseError(PushbackTokenizer.Token token, PushbackTokenizer.Token token2) {
            this(I18n.tr("Unexpected token. Expected {0}, found {1}", new Object[]{token, token2}));
        }
    }

    private static class InView
    extends InArea {
        public InView(boolean bl) {
            super(bl);
        }

        protected Bounds getBounds() {
            return Main.map.mapView.getRealBounds();
        }
    }

    private static class InDataSourceArea
    extends InArea {
        public InDataSourceArea(boolean bl) {
            super(bl);
        }

        protected Bounds getBounds() {
            return new Bounds(Main.main.getCurrentDataSet().getDataSourceArea().getBounds2D());
        }
    }

    private static abstract class InArea
    extends Match {
        protected final boolean all;
        protected final Bounds bounds;

        protected abstract Bounds getBounds();

        public InArea(boolean bl) {
            this.all = bl;
            this.bounds = this.getBounds();
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.isUsable()) {
                return false;
            }
            if (osmPrimitive instanceof Node) {
                return this.bounds.contains(((Node)osmPrimitive).getCoor());
            }
            if (osmPrimitive instanceof Way) {
                List<Node> list = ((Way)osmPrimitive).getNodes();
                return this.all ? this.forallMatch(list) : this.existsMatch(list);
            }
            if (osmPrimitive instanceof Relation) {
                Set<OsmPrimitive> set = ((Relation)osmPrimitive).getMemberPrimitives();
                return this.all ? this.forallMatch(set) : this.existsMatch(set);
            }
            return false;
        }
    }

    private static class Area
    extends CountRange {
        public Area(int n, int n2) {
            super(n, n2);
        }

        protected Integer getCount(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Way) || !((Way)osmPrimitive).isClosed()) {
                return null;
            }
            Way way = (Way)osmPrimitive;
            return (int)Geometry.closedWayArea(way);
        }

        protected String getCountString() {
            return "area";
        }
    }

    private static class Child
    extends Match {
        private final Match parent;

        public Child(Match match) {
            this.parent = match == null ? new Always() : match;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            boolean bl = false;
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                bl |= this.parent.match(osmPrimitive2);
            }
            return bl;
        }

        public String toString() {
            return "child(" + this.parent + ")";
        }
    }

    private static class Parent
    extends Match {
        private Match child;

        public Parent(Match match) {
            this.child = match;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            boolean bl;
            block4: {
                block3: {
                    bl = false;
                    if (this.child == null) {
                        this.child = new Always();
                    }
                    if (!(osmPrimitive instanceof Way)) break block3;
                    for (Node node : ((Way)osmPrimitive).getNodes()) {
                        bl |= this.child.match(node);
                    }
                    break block4;
                }
                if (!(osmPrimitive instanceof Relation)) break block4;
                for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                    bl |= this.child.match(relationMember.getMember());
                }
            }
            return bl;
        }

        public String toString() {
            return "parent(" + this.child + ")";
        }
    }

    private static class Closed
    extends Match {
        private Closed() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive instanceof Way && ((Way)osmPrimitive).isClosed();
        }

        public String toString() {
            return "closed";
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return !osmPrimitive.isTagged() && !osmPrimitive.isIncomplete();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isIncomplete();
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return Main.main.getCurrentDataSet().isSelected(osmPrimitive);
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isModified() || osmPrimitive.isNewOrUndeleted();
        }

        public String toString() {
            return "modified";
        }
    }

    private static class New
    extends Match {
        private New() {
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.isNew();
        }

        public String toString() {
            return "new";
        }
    }

    private static class TagCountRange
    extends CountRange {
        public TagCountRange(int n, int n2) {
            super(n, n2);
        }

        protected Integer getCount(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getKeys().size();
        }

        protected String getCountString() {
            return "tags";
        }
    }

    private static class NodeCountRange
    extends CountRange {
        public NodeCountRange(int n, int n2) {
            super(n, n2);
        }

        protected Integer getCount(OsmPrimitive osmPrimitive) {
            if (!(osmPrimitive instanceof Way)) {
                return null;
            }
            return ((Way)osmPrimitive).getNodesCount();
        }

        protected String getCountString() {
            return "nodes";
        }
    }

    private static abstract class CountRange
    extends Match {
        private int minCount;
        private int maxCount;

        public CountRange(int n, int n2) {
            this.minCount = Math.min(n, n2);
            this.maxCount = Math.max(n, n2);
        }

        protected abstract Integer getCount(OsmPrimitive var1);

        protected abstract String getCountString();

        public boolean match(OsmPrimitive osmPrimitive) {
            Integer n = this.getCount(osmPrimitive);
            if (n == null) {
                return false;
            }
            return n >= this.minCount && n <= this.maxCount;
        }

        public String toString() {
            return this.getCountString() + "=" + this.minCount + "-" + this.maxCount;
        }
    }

    private static class RoleMatch
    extends Match {
        private String role;

        public RoleMatch(String string) {
            this.role = string == null ? "" : string;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                for (RelationMember relationMember : ((Relation)osmPrimitive2).getMembers()) {
                    String string;
                    if (relationMember.getMember() != osmPrimitive || !this.role.equals((string = relationMember.getRole()) == null ? "" : string)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "role=" + this.role;
        }
    }

    private static class UserMatch
    extends Match {
        private String user;

        public UserMatch(String string) {
            this.user = string.equals("anonymous") ? null : string;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.getUser() == null) {
                return this.user == null;
            }
            return osmPrimitive.getUser().hasName(this.user);
        }

        public String toString() {
            return "user=" + this.user == null ? "" : this.user;
        }
    }

    private static class ExactType
    extends Match {
        private final Class<?> type;

        public ExactType(String string) throws ParseError {
            if ("node".equals(string)) {
                this.type = Node.class;
            } else if ("way".equals(string)) {
                this.type = Way.class;
            } else if ("relation".equals(string)) {
                this.type = Relation.class;
            } else {
                throw new ParseError(I18n.tr("Unknown primitive type: {0}. Allowed values are node, way or relation", string));
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return osmPrimitive.getClass() == this.type;
        }

        public String toString() {
            return "type=" + this.type;
        }
    }

    private static class Any
    extends Match {
        private final String search;
        private final Pattern searchRegex;
        private final boolean caseSensitive;

        public Any(String string, boolean bl, boolean bl2) throws ParseError {
            string = Normalizer.normalize(string, Normalizer.Form.NFC);
            this.caseSensitive = bl2;
            if (bl) {
                try {
                    this.searchRegex = Pattern.compile(string, SearchCompiler.regexFlags(bl2));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string, exception.getMessage()));
                }
                this.search = string;
            } else if (bl2) {
                this.search = string;
                this.searchRegex = null;
            } else {
                this.search = string.toLowerCase();
                this.searchRegex = null;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.hasKeys() && osmPrimitive.getUser() == null) {
                return this.search.equals("");
            }
            for (String string : osmPrimitive.keySet()) {
                String string2 = osmPrimitive.get(string);
                if (this.searchRegex != null) {
                    string2 = Normalizer.normalize(string2, Normalizer.Form.NFC);
                    Matcher matcher = this.searchRegex.matcher(string);
                    Matcher matcher2 = this.searchRegex.matcher(string2);
                    boolean bl = matcher.find();
                    boolean bl2 = matcher2.find();
                    if (!bl && !bl2) continue;
                    return true;
                }
                if (!this.caseSensitive) {
                    string = string.toLowerCase();
                    string2 = string2.toLowerCase();
                }
                string2 = Normalizer.normalize(string2, Normalizer.Form.NFC);
                if (string.indexOf(this.search) == -1 && string2.indexOf(this.search) == -1) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.search;
        }
    }

    public static class ExactKeyValue
    extends Match {
        private final String key;
        private final String value;
        private final Pattern keyPattern;
        private final Pattern valuePattern;
        private final Mode mode;

        public ExactKeyValue(boolean bl, String string, String string2) throws ParseError {
            if ("".equals(string)) {
                throw new ParseError(I18n.tr("Key cannot be empty when tag operator is used. Sample use: key=value", new Object[0]));
            }
            this.key = string;
            String string3 = this.value = string2 == null ? "" : string2;
            this.mode = "".equals(this.value) && "*".equals(string) ? Mode.NONE : ("".equals(this.value) ? (bl ? Mode.MISSING_KEY_REGEXP : Mode.MISSING_KEY) : ("*".equals(string) && "*".equals(this.value) ? Mode.ANY : ("*".equals(string) ? (bl ? Mode.ANY_KEY_REGEXP : Mode.ANY_KEY) : ("*".equals(this.value) ? (bl ? Mode.ANY_VALUE_REGEXP : Mode.ANY_VALUE) : (bl ? Mode.EXACT_REGEXP : Mode.EXACT)))));
            if (bl && string.length() > 0 && !string.equals("*")) {
                try {
                    this.keyPattern = Pattern.compile(string, SearchCompiler.regexFlags(false));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string, exception.getMessage()));
                }
            } else {
                this.keyPattern = null;
            }
            if (bl && this.value.length() > 0 && !this.value.equals("*")) {
                try {
                    this.valuePattern = Pattern.compile(this.value, SearchCompiler.regexFlags(false));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string2, exception.getMessage()));
                }
            } else {
                this.valuePattern = null;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (!osmPrimitive.hasKeys()) {
                return this.mode == Mode.NONE;
            }
            switch (this.mode) {
                case NONE: {
                    return false;
                }
                case MISSING_KEY: {
                    return osmPrimitive.get(this.key) == null;
                }
                case ANY: {
                    return true;
                }
                case ANY_VALUE: {
                    return osmPrimitive.get(this.key) != null;
                }
                case ANY_KEY: {
                    for (String string : osmPrimitive.getKeys().values()) {
                        if (!string.equals(this.value)) continue;
                        return true;
                    }
                    return false;
                }
                case EXACT: {
                    return this.value.equals(osmPrimitive.get(this.key));
                }
                case ANY_KEY_REGEXP: {
                    for (String string : osmPrimitive.getKeys().values()) {
                        if (!this.valuePattern.matcher(string).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case ANY_VALUE_REGEXP: 
                case EXACT_REGEXP: {
                    for (String string : osmPrimitive.keySet()) {
                        if (!this.keyPattern.matcher(string).matches() || this.mode != Mode.ANY_VALUE_REGEXP && !this.valuePattern.matcher(osmPrimitive.get(string)).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case MISSING_KEY_REGEXP: {
                    for (String string : osmPrimitive.keySet()) {
                        if (!this.keyPattern.matcher(string).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new AssertionError((Object)"Missed state");
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Mode {
            ANY,
            ANY_KEY,
            ANY_VALUE,
            EXACT,
            NONE,
            MISSING_KEY,
            ANY_KEY_REGEXP,
            ANY_VALUE_REGEXP,
            EXACT_REGEXP,
            MISSING_KEY_REGEXP;

        }
    }

    private static class KeyValue
    extends Match {
        private final String key;
        private final Pattern keyPattern;
        private final String value;
        private final Pattern valuePattern;
        private final boolean caseSensitive;

        public KeyValue(String string, String string2, boolean bl, boolean bl2) throws ParseError {
            this.caseSensitive = bl2;
            if (bl) {
                int n = SearchCompiler.regexFlags(bl2);
                try {
                    this.keyPattern = Pattern.compile(string, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string, exception.getMessage()));
                }
                try {
                    this.valuePattern = Pattern.compile(string2, n);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ParseError(I18n.tr(rxErrorMsg, patternSyntaxException.getPattern(), patternSyntaxException.getIndex(), patternSyntaxException.getMessage()));
                }
                catch (Exception exception) {
                    throw new ParseError(I18n.tr(rxErrorMsgNoPos, string2, exception.getMessage()));
                }
                this.key = string;
                this.value = string2;
            } else if (bl2) {
                this.key = string;
                this.value = string2;
                this.keyPattern = null;
                this.valuePattern = null;
            } else {
                this.key = string.toLowerCase();
                this.value = string2;
                this.keyPattern = null;
                this.valuePattern = null;
            }
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            if (this.keyPattern != null) {
                if (!osmPrimitive.hasKeys()) {
                    return false;
                }
                for (String string : osmPrimitive.keySet()) {
                    Matcher matcher;
                    boolean bl;
                    String string2 = osmPrimitive.get(string);
                    Matcher matcher2 = this.keyPattern.matcher(string);
                    boolean bl2 = matcher2.find();
                    if (!bl2 || !(bl = (matcher = this.valuePattern.matcher(string2)).find())) continue;
                    return true;
                }
            } else {
                String string = null;
                string = this.key.equals("timestamp") ? DateUtils.fromDate(osmPrimitive.getTimestamp()) : osmPrimitive.get(this.key);
                if (string == null) {
                    return false;
                }
                String string3 = this.caseSensitive ? string : string.toLowerCase();
                String string4 = this.caseSensitive ? this.value : this.value.toLowerCase();
                string3 = Normalizer.normalize(string3, Normalizer.Form.NFC);
                string4 = Normalizer.normalize(string4, Normalizer.Form.NFC);
                return string3.indexOf(string4) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Version
    extends Match {
        private long version;

        public Version(long l) {
            this.version = l;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return (long)osmPrimitive.getVersion() == this.version;
        }

        public String toString() {
            return "version=" + this.version;
        }
    }

    private static class ChangesetId
    extends Match {
        private long changesetid;

        public ChangesetId(long l) {
            this.changesetid = l;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return (long)osmPrimitive.getChangesetId() == this.changesetid;
        }

        public String toString() {
            return "changeset=" + this.changesetid;
        }
    }

    private static class Id
    extends Match {
        private long id;

        public Id(long l) {
            this.id = l;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return this.id == 0L ? osmPrimitive.isNew() : osmPrimitive.getUniqueId() == this.id;
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    private static class Or
    extends Match {
        private Match lhs;
        private Match rhs;

        public Or(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return this.lhs.match(osmPrimitive) || this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " || " + this.rhs;
        }
    }

    private static class And
    extends Match {
        private Match lhs;
        private Match rhs;

        public And(Match match, Match match2) {
            this.lhs = match;
            this.rhs = match2;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return this.lhs.match(osmPrimitive) && this.rhs.match(osmPrimitive);
        }

        public String toString() {
            return this.lhs + " && " + this.rhs;
        }
    }

    private static class BooleanMatch
    extends Match {
        private final String key;
        private final boolean defaultValue;

        public BooleanMatch(String string, boolean bl) {
            this.key = string;
            this.defaultValue = bl;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            Boolean bl = OsmUtils.getOsmBoolean(osmPrimitive.get(this.key));
            if (bl == null) {
                return this.defaultValue;
            }
            return bl;
        }
    }

    public static class Not
    extends Match {
        private final Match match;

        public Not(Match match) {
            this.match = match;
        }

        public boolean match(OsmPrimitive osmPrimitive) {
            return !this.match.match(osmPrimitive);
        }

        public String toString() {
            return "!" + this.match;
        }
    }

    public static class Never
    extends Match {
        public boolean match(OsmPrimitive osmPrimitive) {
            return false;
        }
    }

    public static class Always
    extends Match {
        public static Always INSTANCE = new Always();

        public boolean match(OsmPrimitive osmPrimitive) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Match {
        public abstract boolean match(OsmPrimitive var1);

        protected boolean existsMatch(Collection<? extends OsmPrimitive> collection) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!this.match(osmPrimitive)) continue;
                return true;
            }
            return false;
        }

        protected boolean forallMatch(Collection<? extends OsmPrimitive> collection) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (this.match(osmPrimitive)) continue;
                return false;
            }
            return true;
        }
    }
}

