/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;

public class DefaultAuthenticator
extends Authenticator {
    private static DefaultAuthenticator instance;
    private final Map<Authenticator.RequestorType, Boolean> credentialsTried = new HashMap<Authenticator.RequestorType, Boolean>();
    private boolean enabled = true;

    public static DefaultAuthenticator getInstance() {
        return instance;
    }

    public static void createInstance() {
        instance = new DefaultAuthenticator();
    }

    private DefaultAuthenticator() {
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (!this.enabled) {
            return null;
        }
        try {
            String string;
            if (this.getRequestorType().equals((Object)Authenticator.RequestorType.SERVER) && (string = Main.pref.get("osm-server.auth-method", "basic")).equals("oauth")) {
                return null;
            }
            boolean bl = this.credentialsTried.get((Object)this.getRequestorType()) != null;
            CredentialsAgentResponse credentialsAgentResponse = CredentialsManager.getInstance().getCredentials(this.getRequestorType(), bl);
            if (credentialsAgentResponse == null || credentialsAgentResponse.isCanceled()) {
                return null;
            }
            this.credentialsTried.put(this.getRequestorType(), true);
            return new PasswordAuthentication(credentialsAgentResponse.getUsername(), credentialsAgentResponse.getPassword());
        }
        catch (CredentialsAgentException credentialsAgentException) {
            credentialsAgentException.printStackTrace();
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

