/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddWMSLayerPanel
extends JPanel {
    private List<LayerDetails> selectedLayers;
    private URL serviceUrl;
    private LayerDetails selectedLayer;
    private JTextField menuName;
    private JTextArea resultingLayerField;
    private MutableTreeNode treeRootNode;
    private DefaultTreeModel treeData;
    private JTree layerTree;
    private JButton showBoundsButton;
    private boolean previouslyShownUnsupportedCrsError = false;
    private JTextArea tmsURL;
    private JTextField tmsZoom;

    public AddWMSLayerPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Menu Name")), GBC.std().insets(0, 0, 5, 0));
        this.menuName = new JTextField(40);
        this.menuName.setText(I18n.tr("Unnamed Imagery Layer"));
        jPanel.add((Component)this.menuName, GBC.eop().insets(5, 0, 0, 0).fill(2));
        final JTabbedPane jTabbedPane = new JTabbedPane();
        final JPanel jPanel2 = new JPanel(new GridBagLayout());
        jTabbedPane.addTab(I18n.tr("WMS"), jPanel2);
        jPanel.add((Component)jTabbedPane, GBC.eop().insets(5, 0, 0, 0).fill(2));
        final JTextArea jTextArea = new JTextArea(3, 40);
        jTextArea.setLineWrap(true);
        jTextArea.setText("http://sample.com/wms?");
        jPanel2.add((Component)new JLabel(I18n.tr("Service URL")), GBC.std().insets(0, 0, 5, 0));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
        jPanel2.add((Component)jScrollPane, GBC.eop().insets(5, 0, 0, 0));
        JButton jButton = new JButton(I18n.tr("Get Layers"));
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Cursor cursor = AddWMSLayerPanel.this.getCursor();
                try {
                    AddWMSLayerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    AddWMSLayerPanel.this.attemptGetCapabilities(AddWMSLayerPanel.this.sanitize(jTextArea.getText()));
                }
                finally {
                    AddWMSLayerPanel.this.setCursor(cursor);
                }
            }
        });
        jPanel2.add((Component)jButton, GBC.eop().anchor(13));
        this.treeRootNode = new DefaultMutableTreeNode();
        this.treeData = new DefaultTreeModel(this.treeRootNode);
        this.layerTree = new JTree(this.treeData);
        this.layerTree.setCellRenderer(new LayerTreeCellRenderer());
        this.layerTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath[] treePathArray = AddWMSLayerPanel.this.layerTree.getSelectionPaths();
                if (treePathArray == null) {
                    AddWMSLayerPanel.this.showBoundsButton.setEnabled(false);
                    AddWMSLayerPanel.this.selectedLayer = null;
                    return;
                }
                AddWMSLayerPanel.this.selectedLayers = new LinkedList();
                for (TreePath treePath : treePathArray) {
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    if (!(object instanceof LayerDetails)) continue;
                    LayerDetails layerDetails = (LayerDetails)object;
                    if (!layerDetails.isSupported()) {
                        AddWMSLayerPanel.this.layerTree.removeSelectionPath(treePath);
                        if (AddWMSLayerPanel.this.previouslyShownUnsupportedCrsError) continue;
                        JOptionPane.showMessageDialog(null, I18n.tr("That layer does not support any of JOSM''s projections,\nso you can not use it. This message will not show again."), I18n.tr("WMS Error"), 0);
                        AddWMSLayerPanel.this.previouslyShownUnsupportedCrsError = true;
                        continue;
                    }
                    if (layerDetails.ident == null) continue;
                    AddWMSLayerPanel.this.selectedLayers.add(layerDetails);
                }
                if (!AddWMSLayerPanel.this.selectedLayers.isEmpty()) {
                    AddWMSLayerPanel.this.resultingLayerField.setText(AddWMSLayerPanel.this.buildGetMapUrl());
                    if (AddWMSLayerPanel.this.selectedLayers.size() == 1) {
                        AddWMSLayerPanel.this.showBoundsButton.setEnabled(true);
                        AddWMSLayerPanel.this.selectedLayer = (LayerDetails)AddWMSLayerPanel.this.selectedLayers.get(0);
                    }
                } else {
                    AddWMSLayerPanel.this.showBoundsButton.setEnabled(false);
                    AddWMSLayerPanel.this.selectedLayer = null;
                }
            }
        });
        jPanel2.add((Component)new JScrollPane(this.layerTree), GBC.eop().insets(5, 0, 0, 0).fill(2));
        JPanel jPanel3 = new JPanel();
        this.showBoundsButton = new JButton(I18n.tr("Show Bounds"));
        this.showBoundsButton.setEnabled(false);
        this.showBoundsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AddWMSLayerPanel.this.selectedLayer.bounds != null) {
                    SlippyMapBBoxChooser slippyMapBBoxChooser = new SlippyMapBBoxChooser();
                    slippyMapBBoxChooser.setBoundingBox(AddWMSLayerPanel.this.selectedLayer.bounds);
                    JOptionPane.showMessageDialog(null, slippyMapBBoxChooser, I18n.tr("Show Bounds"), -1);
                } else {
                    JOptionPane.showMessageDialog(null, I18n.tr("No bounding box was found for this layer."), I18n.tr("WMS Error"), 0);
                }
            }
        });
        jPanel3.add(this.showBoundsButton);
        jPanel2.add((Component)jPanel3, GBC.eol().insets(0, 0, 5, 0));
        final JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)new JLabel(I18n.tr("TMS URL")), GBC.std().insets(0, 0, 5, 0));
        this.tmsURL = new JTextArea(3, 40);
        this.tmsURL.setLineWrap(true);
        this.tmsURL.setText("http://sample.com/tms/{zoom}/{x}/{y}.jpg");
        this.tmsURL.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                AddWMSLayerPanel.this.resultingLayerField.setText(AddWMSLayerPanel.this.buildTMSUrl());
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.tmsURL, 20, 31);
        jPanel4.add((Component)jScrollPane2, GBC.eop().insets(5, 0, 0, 0).fill(2));
        jPanel4.add((Component)new JLabel(I18n.trc("layer", "Zoom")), GBC.std().insets(0, 0, 5, 0));
        this.tmsZoom = new JTextField(3);
        this.tmsZoom.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                AddWMSLayerPanel.this.resultingLayerField.setText(AddWMSLayerPanel.this.buildTMSUrl());
            }
        });
        jPanel4.add((Component)this.tmsZoom, GBC.eop().insets(5, 0, 0, 0).fill(2));
        jTabbedPane.addTab(I18n.tr("TMS"), jPanel4);
        jPanel.add((Component)new JLabel(I18n.tr("Imagery URL")), GBC.std().insets(0, 0, 5, 0));
        this.resultingLayerField = new JTextArea(3, 40);
        this.resultingLayerField.setLineWrap(true);
        jPanel.add((Component)new JScrollPane(this.resultingLayerField, 20, 31), GBC.eop().insets(5, 0, 0, 0).fill(2));
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = jTabbedPane.getSelectedComponent();
                if (jPanel4 == component) {
                    AddWMSLayerPanel.this.resultingLayerField.setText(AddWMSLayerPanel.this.buildTMSUrl());
                } else if (jPanel2 == component && AddWMSLayerPanel.this.serviceUrl != null) {
                    AddWMSLayerPanel.this.resultingLayerField.setText(AddWMSLayerPanel.this.buildGetMapUrl());
                }
            }
        });
        this.add(jPanel);
    }

    private String sanitize(String string) {
        return string.replaceAll("[\r\n]+", "").trim();
    }

    private String buildTMSUrl() {
        StringBuilder stringBuilder = new StringBuilder("tms");
        String string = this.sanitize(this.tmsZoom.getText());
        if (!string.isEmpty()) {
            stringBuilder.append("[" + string + "]");
        }
        stringBuilder.append(":");
        stringBuilder.append(this.sanitize(this.tmsURL.getText()));
        return stringBuilder.toString();
    }

    private String buildRootUrl() {
        StringBuilder stringBuilder = new StringBuilder(this.serviceUrl.getProtocol());
        stringBuilder.append("://");
        stringBuilder.append(this.serviceUrl.getHost());
        if (this.serviceUrl.getPort() != -1) {
            stringBuilder.append(":");
            stringBuilder.append(this.serviceUrl.getPort());
        }
        stringBuilder.append(this.serviceUrl.getPath());
        stringBuilder.append("?");
        if (this.serviceUrl.getQuery() != null) {
            stringBuilder.append(this.serviceUrl.getQuery());
            if (!this.serviceUrl.getQuery().isEmpty() && !this.serviceUrl.getQuery().endsWith("&")) {
                stringBuilder.append("&");
            }
        }
        return stringBuilder.toString();
    }

    private String buildGetMapUrl() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.buildRootUrl());
        stringBuilder.append("FORMAT=image/jpeg&VERSION=1.1.1&SERVICE=WMS&REQUEST=GetMap&Layers=");
        stringBuilder.append(this.commaSepLayerList());
        stringBuilder.append("&");
        return stringBuilder.toString();
    }

    private String commaSepLayerList() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<LayerDetails> iterator = this.selectedLayers.iterator();
        while (iterator.hasNext()) {
            LayerDetails layerDetails = iterator.next();
            stringBuilder.append(layerDetails.ident);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private void showError(String string, Exception exception) {
        JOptionPane.showMessageDialog(this, I18n.tr("Could not parse WMS layer list."), I18n.tr("WMS Error"), 0);
        System.err.println("Could not parse WMS layer list. Incoming data:");
        System.err.println(string);
        exception.printStackTrace();
    }

    private void attemptGetCapabilities(String string) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        URL uRL = null;
        try {
            uRL = !string.trim().contains("capabilities") ? new URL(string + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : new URL(string);
            this.serviceUrl = new URL(string);
        }
        catch (HeadlessException headlessException) {
            return;
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, I18n.tr("Invalid service URL."), I18n.tr("WMS Error"), 0);
            return;
        }
        try {
            System.out.println("GET " + uRL.toString());
            object5 = uRL.openConnection();
            object4 = ((URLConnection)object5).getInputStream();
            object3 = new BufferedReader(new InputStreamReader((InputStream)object4, "UTF-8"));
            object2 = new StringBuilder();
            while ((object = ((BufferedReader)object3).readLine()) != null) {
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append("\n");
            }
            string2 = ((StringBuilder)object2).toString();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, I18n.tr("Could not retrieve WMS layer list."), I18n.tr("WMS Error"), 0);
            return;
        }
        try {
            object4 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object4).setValidating(false);
            ((DocumentBuilderFactory)object4).setNamespaceAware(true);
            object3 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
            ((DocumentBuilder)object3).setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    System.out.println("Ignoring DTD " + string + ", " + string2);
                    return new InputSource(new StringReader(""));
                }
            });
            object5 = ((DocumentBuilder)object3).parse(new InputSource(new StringReader(string2)));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.showError(string2, parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            this.showError(string2, sAXException);
            return;
        }
        catch (IOException iOException) {
            this.showError(string2, iOException);
            return;
        }
        object4 = AddWMSLayerPanel.getChild(object5.getDocumentElement(), "Capability");
        object4 = AddWMSLayerPanel.getChild((Element)object4, "Request");
        object4 = AddWMSLayerPanel.getChild((Element)object4, "GetMap");
        object4 = AddWMSLayerPanel.getChild((Element)object4, "DCPType");
        object4 = AddWMSLayerPanel.getChild((Element)object4, "HTTP");
        object4 = AddWMSLayerPanel.getChild((Element)object4, "Get");
        object4 = AddWMSLayerPanel.getChild((Element)object4, "OnlineResource");
        if (object4 != null && (object3 = object4.getAttribute("xlink:href")) != null) {
            try {
                System.out.println("GetCapabilities specifies a different service URL: " + (String)object3);
                this.serviceUrl = new URL((String)object3);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            this.treeRootNode.setUserObject(uRL.getHost());
            object3 = AddWMSLayerPanel.getChild(object5.getDocumentElement(), "Capability");
            object = AddWMSLayerPanel.getChildren((Element)object3, "Layer");
            object2 = this.parseLayers((List<Element>)object, new HashSet<String>());
            this.updateTreeList((List<LayerDetails>)object2);
        }
        catch (Exception exception) {
            this.showError(string2, exception);
            return;
        }
    }

    private void updateTreeList(List<LayerDetails> list) {
        this.addLayersToTreeData(this.treeRootNode, list);
        this.layerTree.expandRow(0);
    }

    private void addLayersToTreeData(MutableTreeNode mutableTreeNode, List<LayerDetails> list) {
        for (LayerDetails layerDetails : list) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(layerDetails);
            this.addLayersToTreeData(defaultMutableTreeNode, layerDetails.children);
            this.treeData.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, 0);
        }
    }

    private List<LayerDetails> parseLayers(List<Element> list, Set<String> set) {
        LinkedList<LayerDetails> linkedList = new LinkedList<LayerDetails>();
        for (Element element : list) {
            linkedList.add(this.parseLayer(element, set));
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    private LayerDetails parseLayer(Element element, Set<String> set) {
        void var8_14;
        String string = AddWMSLayerPanel.getChildContent(element, "Title", null, null);
        String string2 = AddWMSLayerPanel.getChildContent(element, "Name", null, null);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        List<Element> list = AddWMSLayerPanel.getChildren(element, "CRS");
        list.addAll(AddWMSLayerPanel.getChildren(element, "SRS"));
        for (Element object22 : list) {
            String string3 = (String)AddWMSLayerPanel.getContent(object22);
            if (string3 == null) continue;
            String string4 = string3.trim().toUpperCase();
            hashSet.add(string4);
        }
        boolean bl = false;
        for (String string5 : hashSet) {
            bl |= this.isProjSupported(string5);
        }
        Object var8_11 = null;
        Element element2 = AddWMSLayerPanel.getChild(element, "EX_GeographicBoundingBox");
        if (element2 != null) {
            double d = Double.parseDouble(AddWMSLayerPanel.getChildContent(element2, "westBoundLongitude", null, null));
            double d2 = Double.parseDouble(AddWMSLayerPanel.getChildContent(element2, "northBoundLatitude", null, null));
            double d3 = Double.parseDouble(AddWMSLayerPanel.getChildContent(element2, "eastBoundLongitude", null, null));
            double d4 = Double.parseDouble(AddWMSLayerPanel.getChildContent(element2, "southBoundLatitude", null, null));
            Bounds bounds = new Bounds(d4, d, d2, d3);
        } else {
            Element element3 = AddWMSLayerPanel.getChild(element, "LatLonBoundingBox");
            if (element3 != null) {
                double d = Double.parseDouble(element3.getAttribute("minx"));
                double d5 = Double.parseDouble(element3.getAttribute("maxy"));
                double d6 = Double.parseDouble(element3.getAttribute("maxx"));
                double d7 = Double.parseDouble(element3.getAttribute("miny"));
                Bounds bounds = new Bounds(d7, d, d5, d6);
            }
        }
        List<Element> list2 = AddWMSLayerPanel.getChildren(element, "Layer");
        List<LayerDetails> list3 = this.parseLayers(list2, hashSet);
        return new LayerDetails(string, string2, hashSet, bl, (Bounds)var8_14, list3);
    }

    private boolean isProjSupported(String string) {
        for (Projection projection : Projections.getProjections()) {
            if (!(projection instanceof ProjectionSubPrefs ? ((ProjectionSubPrefs)projection).getPreferencesFromCode(string) == null : projection.toCode().equals(string))) continue;
            return true;
        }
        return false;
    }

    public String getUrlName() {
        return this.menuName.getText();
    }

    public String getUrl() {
        return this.resultingLayerField.getText();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setContentPane(new AddWMSLayerPanel());
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static String getChildContent(Element element, String string, String string2, String string3) {
        Element element2 = AddWMSLayerPanel.getChild(element, string);
        if (element2 == null) {
            return string2;
        }
        String string4 = (String)AddWMSLayerPanel.getContent(element2);
        return string4 != null ? string4 : string3;
    }

    private static Object getContent(Element element) {
        NodeList nodeList = element.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    return node;
                }
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
        }
        return stringBuffer.toString().trim();
    }

    private static List<Element> getChildren(Element element, String string) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            linkedList.add((Element)node);
        }
        return linkedList;
    }

    private static Element getChild(Element element, String string) {
        if (element == null) {
            return null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    class LayerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        LayerTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof LayerDetails) {
                LayerDetails layerDetails = (LayerDetails)object2;
                this.setEnabled(layerDetails.isSupported());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LayerDetails {
        private String name;
        private String ident;
        private List<LayerDetails> children;
        private Bounds bounds;
        private boolean supported;

        public LayerDetails(String string, String string2, Set<String> set, boolean bl, Bounds bounds, List<LayerDetails> list) {
            this.name = string;
            this.ident = string2;
            this.supported = bl;
            this.children = list;
            this.bounds = bounds;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public String toString() {
            if (this.name == null || this.name.isEmpty()) {
                return this.ident;
            }
            return this.name;
        }
    }
}

