/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeElemStyle
extends ElemStyle {
    public ImageIcon icon;
    public int iconAlpha;
    public Symbol symbol;
    public NodeTextElement text;
    private ImageIcon disabledIcon;
    public static final NodeElemStyle SIMPLE_NODE_ELEMSTYLE;
    private static Color DEFAULT_TEXT_COLOR;

    protected NodeElemStyle(Cascade cascade, ImageIcon imageIcon, Integer n, Symbol symbol, NodeTextElement nodeTextElement) {
        super(cascade, 1000.0f);
        this.icon = imageIcon;
        this.iconAlpha = n == null ? 0 : n;
        this.symbol = symbol;
        this.text = nodeTextElement;
    }

    public static NodeElemStyle create(Environment environment) {
        return NodeElemStyle.create(environment, false);
    }

    private static void initDefaultParameters() {
        if (DEFAULT_TEXT_COLOR != null) {
            return;
        }
        DEFAULT_TEXT_COLOR = PaintColors.TEXT.get();
    }

    private static NodeElemStyle create(Environment environment, boolean bl) {
        NodeElemStyle.initDefaultParameters();
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Pair<ImageIcon, Integer> pair = NodeElemStyle.createIcon(environment);
        Symbol symbol = null;
        if (pair == null) {
            symbol = NodeElemStyle.createSymbol(environment);
        }
        NodeTextElement nodeTextElement = null;
        TextElement textElement = TextElement.create(cascade, DEFAULT_TEXT_COLOR, symbol == null && pair == null);
        if (symbol == null && pair == null && textElement == null) {
            return null;
        }
        if (textElement != null) {
            HorizontalTextAlignment horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
            Keyword keyword = cascade.get("text-anchor-horizontal", Keyword.RIGHT, Keyword.class);
            if (Utils.equal(keyword.val, "left")) {
                horizontalTextAlignment = HorizontalTextAlignment.LEFT;
            } else if (Utils.equal(keyword.val, "center")) {
                horizontalTextAlignment = HorizontalTextAlignment.CENTER;
            } else if (Utils.equal(keyword.val, "right")) {
                horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
            }
            VerticalTextAlignment verticalTextAlignment = VerticalTextAlignment.BOTTOM;
            String string = cascade.get((String)"text-anchor-vertical", Keyword.BOTTOM, Keyword.class).val;
            if (Utils.equal(string, "above")) {
                verticalTextAlignment = VerticalTextAlignment.ABOVE;
            } else if (Utils.equal(string, "top")) {
                verticalTextAlignment = VerticalTextAlignment.TOP;
            } else if (Utils.equal(string, "center")) {
                verticalTextAlignment = VerticalTextAlignment.CENTER;
            } else if (Utils.equal(string, "bottom")) {
                verticalTextAlignment = VerticalTextAlignment.BOTTOM;
            } else if (Utils.equal(string, "below")) {
                verticalTextAlignment = VerticalTextAlignment.BELOW;
            }
            nodeTextElement = new NodeTextElement(textElement, horizontalTextAlignment, verticalTextAlignment);
        }
        return new NodeElemStyle(cascade, pair == null ? null : (ImageIcon)pair.a, pair == null ? null : (Integer)pair.b, symbol, nodeTextElement);
    }

    private static Pair<ImageIcon, Integer> createIcon(Environment environment) {
        Float f;
        int n;
        int n2;
        ImageIcon imageIcon;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Cascade cascade2 = environment.mc.getCascade("default");
        MapPaintStyles.IconReference iconReference = cascade.get("icon-image", null, MapPaintStyles.IconReference.class);
        if (iconReference == null) {
            return null;
        }
        Float f2 = cascade2.get("icon-width", null, Float.class);
        if (f2 != null && f2.floatValue() <= 0.0f) {
            f2 = null;
        }
        Float f3 = NodeElemStyle.getWidth(cascade, "icon-width", f2);
        Float f4 = cascade2.get("icon-height", null, Float.class);
        if (f4 != null && f4.floatValue() <= 0.0f) {
            f4 = null;
        }
        if ((imageIcon = MapPaintStyles.getIcon(iconReference, n2 = f3 == null ? -1 : Math.round(f3.floatValue()), n = (f = NodeElemStyle.getWidth(cascade, "icon-height", f4)) == null ? -1 : Math.round(f.floatValue()), false)) == null) {
            return new Pair<ImageIcon, Integer>(MapPaintStyles.getNoIcon_Icon(iconReference.source, false), 255);
        }
        int n3 = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.icon-image-alpha", 255)));
        Integer n4 = Utils.color_float2int(cascade.get("icon-opacity", null, Float.TYPE));
        if (n4 != null) {
            n3 = n4;
        }
        return new Pair<ImageIcon, Integer>(imageIcon, n3);
    }

    private static Symbol createSymbol(Environment environment) {
        Float f;
        SymbolShape symbolShape;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Cascade cascade2 = environment.mc.getCascade("default");
        Keyword keyword = cascade.get("symbol-shape", null, Keyword.class);
        if (keyword == null) {
            return null;
        }
        if (Utils.equal(keyword.val, "square")) {
            symbolShape = SymbolShape.SQUARE;
        } else if (Utils.equal(keyword.val, "circle")) {
            symbolShape = SymbolShape.CIRCLE;
        } else if (Utils.equal(keyword.val, "triangle")) {
            symbolShape = SymbolShape.TRIANGLE;
        } else if (Utils.equal(keyword.val, "pentagon")) {
            symbolShape = SymbolShape.PENTAGON;
        } else if (Utils.equal(keyword.val, "hexagon")) {
            symbolShape = SymbolShape.HEXAGON;
        } else if (Utils.equal(keyword.val, "heptagon")) {
            symbolShape = SymbolShape.HEPTAGON;
        } else if (Utils.equal(keyword.val, "octagon")) {
            symbolShape = SymbolShape.OCTAGON;
        } else if (Utils.equal(keyword.val, "nonagon")) {
            symbolShape = SymbolShape.NONAGON;
        } else if (Utils.equal(keyword.val, "decagon")) {
            symbolShape = SymbolShape.DECAGON;
        } else {
            return null;
        }
        Float f2 = cascade2.get("symbol-size", null, Float.class);
        if (f2 != null && f2.floatValue() <= 0.0f) {
            f2 = null;
        }
        if ((f = NodeElemStyle.getWidth(cascade, "symbol-size", f2)) == null) {
            f = Float.valueOf(10.0f);
        }
        if (f.floatValue() <= 0.0f) {
            return null;
        }
        Float f3 = NodeElemStyle.getWidth(cascade2, "symbol-stroke-width", null);
        Float f4 = NodeElemStyle.getWidth(cascade, "symbol-stroke-width", f3);
        Color color = cascade.get("symbol-stroke-color", null, Color.class);
        if (f4 == null && color != null) {
            f4 = Float.valueOf(1.0f);
        } else if (f4 != null && color == null) {
            color = Color.ORANGE;
        }
        BasicStroke basicStroke = null;
        if (color != null) {
            float f5 = cascade.get("symbol-stroke-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Utils.color_float2int(Float.valueOf(f5)));
            basicStroke = new BasicStroke(f4.floatValue());
        }
        Color color2 = cascade.get("symbol-fill-color", null, Color.class);
        if (basicStroke == null && color2 == null) {
            color2 = Color.BLUE;
        }
        if (color2 != null) {
            float f6 = cascade.get("symbol-fill-opacity", Float.valueOf(1.0f), Float.class).floatValue();
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Utils.color_float2int(Float.valueOf(f6)));
        }
        return new Symbol(symbolShape, Math.round(f.floatValue()), basicStroke, color, color2);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Node) {
            Node node = (Node)osmPrimitive;
            if (this.icon != null && mapPainter.isShowIcons()) {
                mapPainter.drawNodeIcon(node, mapPainter.isInactiveMode() || node.isDisabled() ? this.getDisabledIcon() : this.icon, Utils.color_int2float(this.iconAlpha).floatValue(), bl, bl2, this.text);
            } else if (this.symbol != null) {
                Color color;
                Color color2 = this.symbol.fillColor;
                if (color2 != null) {
                    if (node.isHighlighted()) {
                        color2 = mapPaintSettings.getHighlightColor();
                    } else if (mapPainter.isInactiveMode() || node.isDisabled()) {
                        color2 = mapPaintSettings.getInactiveColor();
                    } else if (bl) {
                        color2 = mapPaintSettings.getSelectedColor(color2.getAlpha());
                    } else if (bl2) {
                        color2 = mapPaintSettings.getRelationSelectedColor(color2.getAlpha());
                    }
                }
                if ((color = this.symbol.strokeColor) != null) {
                    if (node.isHighlighted()) {
                        color = mapPaintSettings.getHighlightColor();
                    } else if (mapPainter.isInactiveMode() || node.isDisabled()) {
                        color = mapPaintSettings.getInactiveColor();
                    } else if (bl) {
                        color = mapPaintSettings.getSelectedColor(color.getAlpha());
                    } else if (bl2) {
                        color = mapPaintSettings.getRelationSelectedColor(color.getAlpha());
                    }
                }
                mapPainter.drawNodeSymbol(node, this.symbol, color2, color, this.text);
            } else if (node.isHighlighted()) {
                mapPainter.drawNode(node, mapPaintSettings.getHighlightColor(), mapPaintSettings.getSelectedNodeSize(), mapPaintSettings.isFillSelectedNode(), this.text);
            } else {
                boolean bl3 = node.isConnectionNode();
                Color color = mapPainter.isInactiveMode() || node.isDisabled() ? mapPaintSettings.getInactiveColor() : (bl ? mapPaintSettings.getSelectedColor() : (bl2 ? mapPaintSettings.getRelationSelectedColor() : (bl3 ? (node.isTagged() ? mapPaintSettings.getTaggedConnectionColor() : mapPaintSettings.getConnectionColor()) : (node.isTagged() ? mapPaintSettings.getTaggedColor() : mapPaintSettings.getNodeColor()))));
                int n = Utils.max(bl ? mapPaintSettings.getSelectedNodeSize() : 0, node.isTagged() ? mapPaintSettings.getTaggedNodeSize() : 0, bl3 ? mapPaintSettings.getConnectionNodeSize() : 0, mapPaintSettings.getUnselectedNodeSize());
                boolean bl4 = bl && mapPaintSettings.isFillSelectedNode() || node.isTagged() && mapPaintSettings.isFillTaggedNode() || bl3 && mapPaintSettings.isFillConnectionNode() || mapPaintSettings.isFillUnselectedNode();
                mapPainter.drawNode(node, color, n, bl4, this.text);
            }
        } else if (osmPrimitive instanceof Relation && this.icon != null) {
            mapPainter.drawRestriction((Relation)osmPrimitive, this);
        }
    }

    public ImageIcon getDisabledIcon() {
        if (this.disabledIcon != null) {
            return this.disabledIcon;
        }
        if (this.icon == null) {
            return null;
        }
        this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(this.icon.getImage()));
        return this.disabledIcon;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 17 * n + (this.icon != null ? this.icon.getImage().hashCode() : 0);
        n = 17 * n + this.iconAlpha;
        n = 17 * n + (this.symbol != null ? this.symbol.hashCode() : 0);
        n = 17 * n + (this.text != null ? this.text.hashCode() : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NodeElemStyle nodeElemStyle = (NodeElemStyle)object;
        if (this.icon != nodeElemStyle.icon && (this.icon == null || nodeElemStyle.icon == null || this.icon.getImage() != nodeElemStyle.icon.getImage())) {
            return false;
        }
        if (this.iconAlpha != nodeElemStyle.iconAlpha) {
            return false;
        }
        if (!Utils.equal(this.symbol, nodeElemStyle.symbol)) {
            return false;
        }
        return Utils.equal(this.text, nodeElemStyle.text);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NodeElemStyle{");
        stringBuilder.append(super.toString());
        if (this.icon != null) {
            stringBuilder.append(" icon=" + this.icon + " iconAlpha=" + this.iconAlpha);
        }
        if (this.symbol != null) {
            stringBuilder.append(" symbol=[" + this.symbol + "]");
        }
        if (this.text != null) {
            stringBuilder.append(" text=[" + this.text.toStringImpl() + "]");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("text", Keyword.AUTO);
        SIMPLE_NODE_ELEMSTYLE = NodeElemStyle.create(new Environment(null, multiCascade, "default", null), true);
        DEFAULT_TEXT_COLOR = null;
    }

    public static class NodeTextElement
    extends TextElement {
        public HorizontalTextAlignment hAlign;
        public VerticalTextAlignment vAlign;

        public NodeTextElement(TextElement textElement, HorizontalTextAlignment horizontalTextAlignment, VerticalTextAlignment verticalTextAlignment) {
            super(textElement);
            CheckParameterUtil.ensureParameterNotNull((Object)horizontalTextAlignment);
            CheckParameterUtil.ensureParameterNotNull((Object)verticalTextAlignment);
            this.hAlign = horizontalTextAlignment;
            this.vAlign = verticalTextAlignment;
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NodeTextElement nodeTextElement = (NodeTextElement)object;
            return this.hAlign == nodeTextElement.hAlign && this.vAlign == nodeTextElement.vAlign;
        }

        public int hashCode() {
            int n = super.hashCode();
            n = 97 * n + this.hAlign.hashCode();
            n = 97 * n + this.vAlign.hashCode();
            return n;
        }

        public String toString() {
            return "NodeTextElement{" + this.toStringImpl() + '}';
        }

        protected String toStringImpl() {
            return super.toStringImpl() + " hAlign=" + (Object)((Object)this.hAlign) + " vAlign=" + (Object)((Object)this.vAlign);
        }
    }

    public static class Symbol {
        public SymbolShape symbol;
        public int size;
        public Stroke stroke;
        public Color strokeColor;
        public Color fillColor;

        public Symbol(SymbolShape symbolShape, int n, Stroke stroke, Color color, Color color2) {
            if (stroke != null && color == null) {
                throw new IllegalArgumentException();
            }
            if (stroke == null && color2 == null) {
                throw new IllegalArgumentException();
            }
            this.symbol = symbolShape;
            this.size = n;
            this.stroke = stroke;
            this.strokeColor = color;
            this.fillColor = color2;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Symbol symbol = (Symbol)object;
            return this.symbol == symbol.symbol && this.size == symbol.size && Utils.equal(this.stroke, symbol.stroke) && Utils.equal(this.strokeColor, symbol.strokeColor) && Utils.equal(this.fillColor, symbol.fillColor);
        }

        public int hashCode() {
            int n = 7;
            n = 67 * n + this.symbol.hashCode();
            n = 67 * n + this.size;
            n = 67 * n + (this.stroke != null ? this.stroke.hashCode() : 0);
            n = 67 * n + (this.strokeColor != null ? this.strokeColor.hashCode() : 0);
            n = 67 * n + (this.fillColor != null ? this.fillColor.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "symbol=" + (Object)((Object)this.symbol) + " size=" + this.size + (this.stroke != null ? " stroke=" + this.stroke + " strokeColor=" + this.strokeColor : "") + (this.fillColor != null ? " fillColor=" + this.fillColor : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalTextAlignment {
        ABOVE,
        TOP,
        CENTER,
        BOTTOM,
        BELOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalTextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymbolShape {
        SQUARE,
        CIRCLE,
        TRIANGLE,
        PENTAGON,
        HEXAGON,
        HEPTAGON,
        OCTAGON,
        NONAGON,
        DECAGON;

    }
}

