/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.imagery.Grabber;
import org.openstreetmap.josm.io.imagery.WMSRequest;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSGrabber
extends Grabber {
    protected String baseURL;
    private final boolean urlWithPatterns;
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    public WMSGrabber(MapView mapView, WMSLayer wMSLayer) {
        super(mapView, wMSLayer);
        this.baseURL = wMSLayer.getInfo().getUrl();
        this.urlWithPatterns = ImageryInfo.isUrlWithPatterns(this.baseURL);
    }

    @Override
    void fetch(WMSRequest wMSRequest, int n) throws Exception {
        URL uRL = null;
        try {
            uRL = this.getURL(this.b.minEast, this.b.minNorth, this.b.maxEast, this.b.maxNorth, this.width(), this.height());
            wMSRequest.finish(GeorefImage.State.IMAGE, this.grab(uRL, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage() + "\nImage couldn't be fetched: " + (uRL != null ? uRL.toString() : ""));
        }
    }

    protected URL getURL(double d, double d2, double d3, double d4, int n, int n2) throws MalformedURLException {
        Object object;
        Object object2;
        String string = Main.getProjection().toCode();
        String string2 = "";
        boolean bl = false;
        try {
            object2 = Pattern.compile(".*SRS=([a-z0-9:]+).*", 2).matcher(this.baseURL.toUpperCase());
            if (((Matcher)object2).matches()) {
                if (((Matcher)object2).group(1).equals("EPSG:4326") && Main.getProjection() instanceof Mercator) {
                    bl = true;
                }
            } else if (Main.getProjection() instanceof Mercator) {
                bl = true;
                string2 = "&srs=EPSG:4326";
            } else {
                string2 = "&srs=" + string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            object2 = Main.getProjection().eastNorth2latlon(new EastNorth(d, d2));
            object = Main.getProjection().eastNorth2latlon(new EastNorth(d3, d4));
            string = "EPSG:4326";
            d2 = ((LatLon)object2).lat();
            d = ((LatLon)object2).lon();
            d4 = ((LatLon)object).lat();
            d3 = ((LatLon)object).lon();
        }
        object2 = this.baseURL;
        object = latLonFormat.format(d) + "," + latLonFormat.format(d2) + "," + latLonFormat.format(d3) + "," + latLonFormat.format(d4);
        if (this.urlWithPatterns) {
            object2 = ((String)object2).replaceAll("\\{proj(\\([^})]+\\))?\\}", string).replaceAll("\\{bbox\\}", (String)object).replaceAll("\\{w\\}", latLonFormat.format(d)).replaceAll("\\{s\\}", latLonFormat.format(d2)).replaceAll("\\{e\\}", latLonFormat.format(d3)).replaceAll("\\{n\\}", latLonFormat.format(d4)).replaceAll("\\{width\\}", String.valueOf(n)).replaceAll("\\{height\\}", String.valueOf(n2));
        } else {
            object2 = (String)object2 + "bbox=" + (String)object + string2 + "&width=" + n + "&height=" + n2;
            if (!this.baseURL.endsWith("&") && !this.baseURL.endsWith("?")) {
                System.out.println(I18n.tr("Warning: The base URL ''{0}'' for a WMS service doesn't have a trailing '&' or a trailing '?'.", this.baseURL));
                System.out.println(I18n.tr("Warning: Fetching WMS tiles is likely to fail. Please check you preference settings."));
                System.out.println(I18n.tr("Warning: The complete URL is ''{0}''.", object2));
            }
        }
        return new URL(((String)object2).replace(" ", "%20"));
    }

    public static ArrayList<String> getServerProjections(String string, Boolean bl) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            object = Pattern.compile(".*\\{PROJ\\(([^)}]+)\\)\\}.*").matcher(string.toUpperCase());
            if (((Matcher)object).matches()) {
                boolean bl2 = false;
                for (String string2 : ((Matcher)object).group(1).split(",")) {
                    arrayList.add(string2);
                    if (!string2.equals("EPSG:4326")) continue;
                    bl2 = true;
                }
                if (bl2 && !arrayList.contains(new Mercator().toCode())) {
                    arrayList.add(new Mercator().toCode());
                }
            } else {
                object = Pattern.compile(".*SRS=([a-z0-9:]+).*", 2).matcher(string.toUpperCase());
                if (((Matcher)object).matches()) {
                    arrayList.add(((Matcher)object).group(1));
                    if (((Matcher)object).group(1).equals("EPSG:4326")) {
                        arrayList.add(new Mercator().toCode());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (bl.booleanValue() && !arrayList.contains(object = Main.getProjection().toCode().toUpperCase())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection ''{0}'' in URL and current projection ''{1}'' mismatch.\nThis may lead to wrong coordinates.", arrayList.get(0), object), I18n.tr("Warning"), 2);
        }
        return arrayList;
    }

    @Override
    public boolean loadFromCache(WMSRequest wMSRequest) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.layer.cache.getExactMatch(Main.getProjection(), this.pixelPerDegree, this.b.minEast, this.b.minNorth);
        if (bufferedImage2 != null) {
            wMSRequest.finish(GeorefImage.State.IMAGE, bufferedImage2);
            return true;
        }
        if (wMSRequest.isAllowPartialCacheMatch() && (bufferedImage = this.layer.cache.getPartialMatch(Main.getProjection(), this.pixelPerDegree, this.b.minEast, this.b.minNorth)) != null) {
            wMSRequest.finish(GeorefImage.State.PARTLY_IN_CACHE, bufferedImage);
            return true;
        }
        if (!wMSRequest.isReal() && !this.layer.hasAutoDownload()) {
            wMSRequest.finish(GeorefImage.State.NOT_IN_CACHE, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage grab(URL uRL, int n) throws IOException, OsmTransferException {
        System.out.println("Grabbing WMS " + (n > 1 ? "(attempt " + n + ") " : "") + uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (this.layer.getInfo().getCookies() != null && !this.layer.getInfo().getCookies().equals("")) {
            httpURLConnection.setRequestProperty("Cookie", this.layer.getInfo().getCookies());
        }
        httpURLConnection.setRequestProperty("User-Agent", Main.pref.get("imagery.wms.user_agent", Version.getInstance().getAgentString()));
        httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
        httpURLConnection.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
        String string = httpURLConnection.getHeaderField("Content-Type");
        if (httpURLConnection.getResponseCode() != 200 || string != null && !string.startsWith("image")) {
            throw new IOException(this.readException(httpURLConnection));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProgressInputStream progressInputStream = new ProgressInputStream(httpURLConnection, null);
        try {
            Utils.copyStream(progressInputStream, byteArrayOutputStream);
        }
        finally {
            ((InputStream)progressInputStream).close();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = this.layer.normalizeImage(ImageIO.read(byteArrayInputStream));
        byteArrayInputStream.reset();
        this.layer.cache.saveToCache(this.layer.isOverlapEnabled() ? bufferedImage : null, byteArrayInputStream, Main.getProjection(), this.pixelPerDegree, this.b.minEast, this.b.minNorth);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readException(URLConnection uRLConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string.replaceAll("[^\\p{Print}]", ""));
                stringBuilder.append('\n');
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }
}

