/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TaggingPresetPreference
implements PreferenceSetting {
    public static Collection<TaggingPreset> taggingPresets;
    private SourceEditor sources;
    private JCheckBox sortMenu;
    private PreferenceTabbedPane.ValidationListener validationListener = new PreferenceTabbedPane.ValidationListener(){

        public boolean validatePreferences() {
            if (TaggingPresetPreference.this.sources.hasActiveSourcesChanged()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n = -1;
                block15: for (SourceEntry sourceEntry : TaggingPresetPreference.this.sources.getActiveSources()) {
                    ++n;
                    boolean bl = false;
                    try {
                        TaggingPreset.readAll(sourceEntry.url, false);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        System.err.println(I18n.tr("Warning: Could not read tagging preset source: {0}", sourceEntry));
                        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Error"), new String[]{I18n.tr("Yes"), I18n.tr("No"), I18n.tr("Cancel")});
                        extendedDialog.setContent(I18n.tr("Could not read tagging preset source: {0}\nDo you want to keep it?", sourceEntry));
                        switch (extendedDialog.showDialog().getValue()) {
                            case 1: {
                                continue block15;
                            }
                            case 2: {
                                arrayList.add(n);
                                continue block15;
                            }
                        }
                        return false;
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                    String string = null;
                    try {
                        TaggingPreset.readAll(sourceEntry.url, true);
                    }
                    catch (IOException iOException) {
                        String string2 = I18n.tr("Could not read tagging preset source {0}", sourceEntry);
                        System.err.println(string2);
                        JOptionPane.showMessageDialog(Main.parent, string2);
                        return false;
                    }
                    catch (SAXParseException sAXParseException) {
                        string = bl ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: [{1}:{2}] {3}</table></html>", sourceEntry, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=400>Error is: [{1}:{2}] {3}</table></html>", sourceEntry, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
                    }
                    catch (SAXException sAXException) {
                        string = bl ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", sourceEntry, sAXException.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", sourceEntry, sAXException.getMessage());
                    }
                    if (string == null) continue;
                    System.err.println("Error: " + string);
                    int n2 = JOptionPane.showConfirmDialog(Main.parent, new JLabel(string), I18n.tr("Error"), 1, 0);
                    switch (n2) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            arrayList.add(n);
                            continue block15;
                        }
                    }
                    return false;
                }
                TaggingPresetPreference.this.sources.removeSources(arrayList);
                return true;
            }
            return true;
        }
    };

    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu"), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        this.sources = new TaggingPresetSourceEditor();
        jPanel.add((Component)this.sources, GBC.eol().fill(1));
        preferenceTabbedPane.mapcontent.addTab(I18n.tr("Tagging Presets"), jPanel);
        preferenceTabbedPane.mapcontent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (preferenceTabbedPane.mapcontent.getSelectedComponent() == jPanel) {
                    TaggingPresetPreference.this.sources.initiallyLoadAvailableSources();
                }
            }
        });
        preferenceTabbedPane.addValidationListener(this.validationListener);
    }

    public boolean ok() {
        boolean bl = Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null);
        return bl |= this.sources.finish();
    }

    public static void initialize() {
        taggingPresets = TaggingPreset.readFromPreferences(false);
        for (TaggingPreset object : taggingPresets) {
            if (object instanceof TaggingPresetSeparator) continue;
            Main.toolbar.register(object);
        }
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            AutoCompletionManager.cachePresets(taggingPresets);
            HashMap hashMap = new HashMap();
            for (TaggingPreset taggingPreset : taggingPresets) {
                JMenuItem jMenuItem;
                JMenu jMenu;
                JMenu jMenu2 = jMenu = taggingPreset.group != null ? (JMenu)hashMap.get(taggingPreset.group) : Main.main.menu.presetsMenu;
                if (taggingPreset instanceof TaggingPresetSeparator) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetMenu) {
                    jMenuItem = new JMenu(taggingPreset);
                    jMenuItem.setText(taggingPreset.getLocaleName());
                    ((TaggingPresetMenu)taggingPreset).menu = jMenuItem;
                    hashMap.put((TaggingPresetMenu)taggingPreset, jMenuItem);
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem(taggingPreset);
                jMenuItem.setText(taggingPreset.getLocaleName());
                jMenu.add(jMenuItem);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PresetPrefMigration
    extends SourceEditor.SourcePrefMigration {
        public static final PresetPrefMigration INSTANCE = new PresetPrefMigration();

        public PresetPrefMigration() {
            super("taggingpreset.sources", "taggingpreset.enable-defaults", "taggingpreset.sources-list");
        }

        @Override
        public List<SourceEntry> get() {
            ArrayList<SourceEntry> arrayList = new ArrayList<SourceEntry>(super.get());
            if (this.removeDeprecated(arrayList)) {
                this.put(arrayList);
            }
            return arrayList;
        }

        private boolean removeDeprecated(List<SourceEntry> list) {
            boolean bl = false;
            Iterator<SourceEntry> iterator = list.iterator();
            while (iterator.hasNext()) {
                SourceEntry sourceEntry = iterator.next();
                if (!sourceEntry.url.equals("resource://data/elemstyles.xml")) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            SourceEditor.ExtendedSourceEntry extendedSourceEntry = new SourceEditor.ExtendedSourceEntry("defaultpresets.xml", "resource://data/defaultpresets.xml");
            extendedSourceEntry.title = I18n.tr("Internal Preset");
            extendedSourceEntry.description = I18n.tr("The default preset for JOSM");
            return Collections.singletonList(extendedSourceEntry);
        }

        @Override
        public Collection<String> serialize(SourceEntry sourceEntry) {
            return Arrays.asList(sourceEntry.url, sourceEntry.title);
        }

        @Override
        public SourceEntry deserialize(List<String> list) {
            if (list.size() < 2) {
                return null;
            }
            String string = list.get(0);
            String string2 = list.get(1);
            return new SourceEntry(string, null, string2, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TaggingPresetSourceEditor
    extends SourceEditor {
        private final String iconpref = "taggingpreset.icon.sources";

        public TaggingPresetSourceEditor() {
            super(false, "http://josm.openstreetmap.de/presets");
            this.iconpref = "taggingpreset.icon.sources";
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return PresetPrefMigration.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            List<SourceEntry> list = this.activeSourcesModel.getSources();
            boolean bl = PresetPrefMigration.INSTANCE.put(list);
            if (this.tblIconPaths != null) {
                List<String> list2 = this.iconPathsModel.getIconPaths();
                if (!list2.isEmpty()) {
                    if (Main.pref.putCollection("taggingpreset.icon.sources", list2)) {
                        bl = true;
                    }
                } else if (Main.pref.putCollection("taggingpreset.icon.sources", null)) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return PresetPrefMigration.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return Main.pref.getCollection("taggingpreset.icon.sources", null);
        }

        @Override
        public String getStr(SourceEditor.I18nString i18nString) {
            switch (i18nString) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available presets:");
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active presets:");
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new preset by entering filename or URL");
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New preset entry:");
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected presets from the list of active presets");
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active preset");
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available presets to the list of active presets");
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available presets from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading preset sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of preset sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Presets#FailedToLoadPresetSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in preset list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

