/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.ConfigurationParameterRequestHandler;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadParameterSummaryPanel
extends JPanel
implements HyperlinkListener,
PropertyChangeListener {
    private UploadStrategySpecification spec = new UploadStrategySpecification();
    private int numObjects;
    private JEditorPane jepMessage;
    private JLabel lblWarning;
    private Changeset selectedChangeset;
    private boolean closeChangesetAfterNextUpload;
    private ConfigurationParameterRequestHandler configHandler;

    protected String buildChangesetSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.selectedChangeset == null || this.selectedChangeset.isNew()) {
            stringBuffer.append(I18n.tr("Objects are uploaded to a <strong>new changeset</strong>."));
        } else {
            String string = this.selectedChangeset.get("comment") == null ? "" : this.selectedChangeset.get("comment");
            stringBuffer.append(I18n.tr("Objects are uploaded to the <strong>open changeset</strong> {0} with upload comment ''{1}''.", this.selectedChangeset.getId(), string));
        }
        stringBuffer.append(" ");
        if (this.closeChangesetAfterNextUpload) {
            stringBuffer.append(I18n.tr("The changeset is going to be <strong>closed</strong> after this upload"));
        } else {
            stringBuffer.append(I18n.tr("The changeset is <strong>left open</strong> after this upload"));
        }
        stringBuffer.append(" (<a href=\"urn:changeset-configuration\">" + I18n.tr("configure changeset") + "</a>)");
        return stringBuffer.toString();
    }

    protected String buildStrategySummary() {
        if (this.spec == null) {
            return "";
        }
        boolean bl = true;
        int n = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        if (n > 0 && this.numObjects > n) {
            bl = false;
        }
        int n2 = this.spec.getNumRequests(this.numObjects);
        String string = null;
        if (bl) {
            this.lblWarning.setVisible(false);
            if (n2 == 0) {
                string = I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong>", this.numObjects, this.numObjects);
            } else if (n2 == 1) {
                string = I18n.trn("Uploading <strong>{0} object</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", "Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>1 request</strong>", this.numObjects, this.numObjects);
            } else if (n2 > 1) {
                string = I18n.tr("Uploading <strong>{0} objects</strong> to <strong>1 changeset</strong> using <strong>{1} requests</strong>", this.numObjects, n2);
            }
            string = string + " (<a href=\"urn:advanced-configuration\">" + I18n.tr("advanced configuration") + "</a>)";
        } else {
            this.lblWarning.setVisible(true);
            if (n2 == 0) {
                string = I18n.tr("{0} objects exceed the max. allowed {1} objects in a changeset on the server ''{2}''. Please <a href=\"urn:advanced-configuration\">configure</a> how to proceed with <strong>multiple changesets</strong>", this.numObjects, n, OsmApi.getOsmApi().getBaseUrl());
            } else if (n2 > 1) {
                string = I18n.tr("Uploading <strong>{0} objects</strong> to <strong>multiple changesets</strong> using <strong>{1} requests</strong>", this.numObjects, n2);
                string = string + " (<a href=\"urn:advanced-configuration\">" + I18n.tr("advanced configuration") + "</a>)";
            }
        }
        return string;
    }

    protected void build() {
        this.jepMessage = new JEditorPane("text/html", "");
        this.jepMessage.setOpaque(false);
        this.jepMessage.setEditable(false);
        this.jepMessage.addHyperlinkListener(this);
        Font font = UIManager.getFont("Label.font");
        StyleSheet styleSheet = new StyleSheet();
        String string = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", font.getName(), font.getSize(), font.isBold() ? "bold" : "normal", font.isItalic() ? "italic" : "normal");
        string = "body {" + string + "}";
        string = MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", font.getName(), font.getSize(), "bold", font.isItalic() ? "italic" : "normal");
        string = "strong {" + string + "}";
        styleSheet.addRule(string);
        styleSheet.addRule("a {text-decoration: underline; color: blue}");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        hTMLEditorKit.setStyleSheet(styleSheet);
        this.jepMessage.setEditorKit(hTMLEditorKit);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jepMessage, "Center");
        this.lblWarning = new JLabel("");
        this.lblWarning.setVisible(false);
        this.lblWarning.setIcon(ImageProvider.get("warning-small.png"));
        this.lblWarning.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.lblWarning, "North");
        this.add((Component)jPanel, "West");
    }

    public UploadParameterSummaryPanel() {
        this.build();
        this.updateSummary();
    }

    public void setConfigurationParameterRequestListener(ConfigurationParameterRequestHandler configurationParameterRequestHandler) {
        this.configHandler = configurationParameterRequestHandler;
    }

    public void setUploadStrategySpecification(UploadStrategySpecification uploadStrategySpecification) {
        this.spec = uploadStrategySpecification;
        this.updateSummary();
    }

    public void setNumObjects(int n) {
        this.numObjects = n;
        this.updateSummary();
    }

    public void setCloseChangesetAfterNextUpload(boolean bl) {
        this.closeChangesetAfterNextUpload = bl;
        this.updateSummary();
    }

    protected void updateSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(this.buildStrategySummary());
        stringBuffer.append("<br><br>");
        stringBuffer.append(this.buildChangesetSummary());
        stringBuffer.append("</html>");
        this.jepMessage.setText(stringBuffer.toString());
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
            if (hyperlinkEvent.getDescription() == null || this.configHandler == null) {
                return;
            }
            if (hyperlinkEvent.getDescription().equals("urn:changeset-configuration")) {
                this.configHandler.handleChangesetConfigurationRequest();
            } else if (hyperlinkEvent.getDescription().equals("urn:advanced-configuration")) {
                this.configHandler.handleUploadStrategyConfigurationRequest();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            this.selectedChangeset = (Changeset)propertyChangeEvent.getNewValue();
            this.updateSummary();
        } else if (propertyChangeEvent.getPropertyName().equals(ChangesetManagementPanel.CLOSE_CHANGESET_AFTER_UPLOAD)) {
            this.closeChangesetAfterNextUpload = (Boolean)propertyChangeEvent.getNewValue();
            this.updateSummary();
        } else if (propertyChangeEvent.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.numObjects = (Integer)propertyChangeEvent.getNewValue();
            this.updateSummary();
        } else if (propertyChangeEvent.getPropertyName().equals(UploadStrategySelectionPanel.UPLOAD_STRATEGY_SPECIFICATION_PROP)) {
            this.spec = (UploadStrategySpecification)propertyChangeEvent.getNewValue();
            this.updateSummary();
        }
    }
}

