/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dialog;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class RelationTree
extends JTree {
    protected void build() {
        this.setRootVisible(false);
        this.setCellRenderer(new RelationTreeCellRenderer());
        this.addTreeWillExpandListener(new LazyRelationLoader());
    }

    public RelationTree() {
        this.build();
    }

    public RelationTree(RelationTreeModel relationTreeModel) {
        super(relationTreeModel);
        this.build();
    }

    protected Dialog getParentDialog() {
        Container container;
        for (container = this; container != null && !(container instanceof Dialog); container = container.getParent()) {
        }
        return (Dialog)container;
    }

    class RelationLoader
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private Exception lastException;
        private Relation relation;
        private DataSet ds;
        private TreePath path;

        public RelationLoader(Dialog dialog, Relation relation, TreePath treePath) {
            super(I18n.tr("Load relation"), new PleaseWaitProgressMonitor(dialog), false);
            this.relation = relation;
            this.path = treePath;
        }

        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.cancelled = true;
        }

        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                this.lastException.printStackTrace();
                return;
            }
            DataSetMerger dataSetMerger = new DataSetMerger(Main.main.getEditLayer().data, this.ds);
            dataSetMerger.merge();
            if (!dataSetMerger.getConflicts().isEmpty()) {
                Main.main.getEditLayer().getConflicts().add(dataSetMerger.getConflicts());
            }
            final RelationTreeModel relationTreeModel = (RelationTreeModel)RelationTree.this.getModel();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    relationTreeModel.refreshNode(RelationLoader.this.path);
                }
            });
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(this.relation.getId(), OsmPrimitiveType.from(this.relation), true);
                this.ds = osmServerObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception exception) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task was cancelled. Exception was: {0}", exception.toString()));
                    return;
                }
                this.lastException = exception;
            }
        }
    }

    class LazyRelationLoader
    implements TreeWillExpandListener {
        LazyRelationLoader() {
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            Relation relation = (Relation)treeExpansionEvent.getPath().getLastPathComponent();
            if (!relation.isIncomplete() || relation.isNew()) {
                return;
            }
            Main.worker.submit(new RelationLoader(RelationTree.this.getParentDialog(), relation, treePath));
        }
    }
}

