/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwissGrid
implements Projection,
ProjectionSubPrefs {
    private static final double dX = 674.374;
    private static final double dY = 15.056;
    private static final double dZ = 405.346;
    private static final double phi0 = Math.toRadians(46.95240555555556);
    private static final double lambda0 = Math.toRadians(7.439583333333333);
    private static final double R = Ellipsoid.Bessel1841.a * Math.sqrt(1.0 - Ellipsoid.Bessel1841.e2) / (1.0 - Ellipsoid.Bessel1841.e2 * Math.pow(Math.sin(phi0), 2.0));
    private static final double alpha = Math.sqrt(1.0 + Ellipsoid.Bessel1841.eb2 * Math.pow(Math.cos(phi0), 4.0));
    private static final double b0 = Math.asin(Math.sin(phi0) / alpha);
    private static final double K = Math.log(Math.tan(0.7853981633974483 + b0 / 2.0)) - alpha * Math.log(Math.tan(0.7853981633974483 + phi0 / 2.0)) + alpha * Ellipsoid.Bessel1841.e / 2.0 * Math.log((1.0 + Ellipsoid.Bessel1841.e * Math.sin(phi0)) / (1.0 - Ellipsoid.Bessel1841.e * Math.sin(phi0)));
    private static final double xTrans = 200000.0;
    private static final double yTrans = 600000.0;
    private static final double DELTA_PHI = 1.0E-11;

    private LatLon correctEllipoideGSR80toBressel1841(LatLon latLon) {
        double[] dArray = Ellipsoid.WGS84.latLon2Cart(latLon);
        dArray[0] = dArray[0] - 674.374;
        dArray[1] = dArray[1] - 15.056;
        dArray[2] = dArray[2] - 405.346;
        return Ellipsoid.Bessel1841.cart2LatLon(dArray);
    }

    private LatLon correctEllipoideBressel1841toGRS80(LatLon latLon) {
        double[] dArray = Ellipsoid.Bessel1841.latLon2Cart(latLon);
        dArray[0] = dArray[0] + 674.374;
        dArray[1] = dArray[1] + 15.056;
        dArray[2] = dArray[2] + 405.346;
        return Ellipsoid.WGS84.cart2LatLon(dArray);
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        LatLon latLon2 = this.correctEllipoideGSR80toBressel1841(latLon);
        double d = Math.toRadians(latLon2.lat());
        double d2 = Math.toRadians(latLon2.lon());
        double d3 = alpha * Math.log(Math.tan(0.7853981633974483 + d / 2.0)) - alpha * Ellipsoid.Bessel1841.e / 2.0 * Math.log((1.0 + Ellipsoid.Bessel1841.e * Math.sin(d)) / (1.0 - Ellipsoid.Bessel1841.e * Math.sin(d))) + K;
        double d4 = 2.0 * (Math.atan(Math.exp(d3)) - 0.7853981633974483);
        double d5 = alpha * (d2 - lambda0);
        double d6 = Math.atan2(Math.sin(d5), Math.sin(b0) * Math.tan(d4) + Math.cos(b0) * Math.cos(d5));
        double d7 = Math.asin(Math.cos(b0) * Math.sin(d4) - Math.sin(b0) * Math.cos(d4) * Math.cos(d5));
        double d8 = R * d6;
        double d9 = R / 2.0 * Math.log((1.0 + Math.sin(d7)) / (1.0 - Math.sin(d7)));
        return new EastNorth(d8 + 600000.0, d9 + 200000.0);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        double d = eastNorth.north() - 200000.0;
        double d2 = eastNorth.east() - 600000.0;
        double d3 = d2 / R;
        double d4 = 2.0 * (Math.atan(Math.exp(d / R)) - 0.7853981633974483);
        double d5 = Math.asin(Math.cos(b0) * Math.sin(d4) + Math.sin(b0) * Math.cos(d4) * Math.cos(d3));
        double d6 = Math.atan2(Math.sin(d3), Math.cos(b0) * Math.cos(d3) - Math.sin(b0) * Math.tan(d4));
        double d7 = lambda0 + d6 / alpha;
        double d8 = d5;
        double d9 = 0.0;
        double d10 = -1000.0;
        int n = 0;
        while (Math.abs(d8 - d10) > 1.0E-11) {
            if (++n > 30) {
                throw new RuntimeException("Two many iterations");
            }
            d10 = d8;
            d9 = 1.0 / alpha * (Math.log(Math.tan(0.7853981633974483 + d5 / 2.0)) - K) + Ellipsoid.Bessel1841.e * Math.log(Math.tan(0.7853981633974483 + Math.asin(Ellipsoid.Bessel1841.e * Math.sin(d8)) / 2.0));
            d8 = 2.0 * Math.atan(Math.exp(d9)) - 1.5707963267948966;
        }
        LatLon latLon = this.correctEllipoideBressel1841toGRS80(new LatLon(Math.toDegrees(d8), Math.toDegrees(d7)));
        return latLon;
    }

    @Override
    public String toString() {
        return I18n.tr("Swiss Grid (Switzerland)");
    }

    @Override
    public String toCode() {
        return "EPSG:21781";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public String getCacheDirectoryName() {
        return "swissgrid";
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.7, 5.7), new LatLon(47.9, 10.6));
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 1.01;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        jPanel.add((Component)new HtmlPanel("<i>CH1903 / LV03 (without local corrections)</i>"), GBC.eol().fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        return Collections.singletonList("CH1903");
    }

    @Override
    public String[] allCodes() {
        return new String[]{"EPSG:21781"};
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if ("EPSG:21781".equals(string)) {
            return Collections.singletonList("CH1903");
        }
        return null;
    }
}

