/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final String key;
    private final String value;

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.key = string;
        this.value = string2;
        if (string2 == null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive.get(string) == null) continue;
                this.objects.add(osmPrimitive);
            }
        } else {
            for (OsmPrimitive osmPrimitive : collection) {
                String string3 = osmPrimitive.get(string);
                if (string3 != null && string2.equals(string3)) continue;
                this.objects.add(osmPrimitive);
            }
        }
    }

    public ChangePropertyCommand(OsmPrimitive osmPrimitive, String string, String string2) {
        this.key = string;
        this.value = string2;
        String string3 = osmPrimitive.get(string);
        if (string2 == null && string3 != null || string2 != null && (string3 == null || !string2.equals(string3))) {
            this.objects.add(osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        Main.main.getCurrentDataSet().beginUpdate();
        try {
            super.executeCommand();
            if (this.value == null) {
                for (OsmPrimitive osmPrimitive : this.objects) {
                    osmPrimitive.setModified(true);
                    osmPrimitive.remove(this.key);
                }
            } else {
                for (OsmPrimitive osmPrimitive : this.objects) {
                    osmPrimitive.setModified(true);
                    osmPrimitive.put(this.key, this.value);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Main.main.getCurrentDataSet().endUpdate();
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    @Override
    public JLabel getDescription() {
        String string;
        if (this.objects.size() == 1) {
            OsmPrimitive osmPrimitive = this.objects.iterator().next();
            String string2 = "";
            if (this.value == null) {
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string2 = I18n.marktr("Remove \"{0}\" for node ''{1}''");
                        break;
                    }
                    case WAY: {
                        string2 = I18n.marktr("Remove \"{0}\" for way ''{1}''");
                        break;
                    }
                    case RELATION: {
                        string2 = I18n.marktr("Remove \"{0}\" for relation ''{1}''");
                    }
                }
                string = I18n.tr(string2, this.key, osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                switch (OsmPrimitiveType.from(osmPrimitive)) {
                    case NODE: {
                        string2 = I18n.marktr("Set {0}={1} for node ''{2}''");
                        break;
                    }
                    case WAY: {
                        string2 = I18n.marktr("Set {0}={1} for way ''{2}''");
                        break;
                    }
                    case RELATION: {
                        string2 = I18n.marktr("Set {0}={1} for relation ''{2}''");
                    }
                }
                string = I18n.tr(string2, this.key, this.value, osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        } else {
            string = this.value == null ? I18n.tr("Remove \"{0}\" for {1} objects", this.key, this.objects.size()) : I18n.tr("Set {0}={1} for {2} objects", this.key, this.value, this.objects.size());
        }
        return new JLabel(string, ImageProvider.get("data", "key"), 0);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osmPrimitive : this.objects) {
            arrayList.add(new PseudoCommand(){

                @Override
                public JLabel getDescription() {
                    return new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0);
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return arrayList;
    }
}

