/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geometry {
    public static Set<Node> addIntersections(List<Way> list, boolean bl, List<Command> list2) {
        Object object;
        int n;
        ArrayList[] arrayListArray = new ArrayList[list.size()];
        BBox[] bBoxArray = new BBox[list.size()];
        boolean[] blArray = new boolean[list.size()];
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        for (int i = 0; i < list.size(); ++i) {
            arrayListArray[i] = new ArrayList<Node>(list.get(i).getNodes());
            bBoxArray[i] = Geometry.getNodesBounds(arrayListArray[i]);
            blArray[i] = false;
        }
        NodePositionComparator nodePositionComparator = new NodePositionComparator();
        for (n = 0; n < list.size(); ++n) {
            for (int i = n; i < list.size(); ++i) {
                if (!bBoxArray[n].intersects(bBoxArray[i])) continue;
                object = arrayListArray[n];
                ArrayList arrayList = arrayListArray[i];
                int n2 = 0;
                while (n2 + 1 < ((ArrayList)object).size()) {
                    int n3;
                    int n4 = n3 = n != i ? 0 : n2 + 2;
                    while (n4 + 1 < arrayList.size()) {
                        Node node = (Node)((ArrayList)object).get(n2);
                        Node node2 = (Node)((ArrayList)object).get(n2 + 1);
                        Node node3 = (Node)arrayList.get(n4);
                        Node node4 = (Node)arrayList.get(n4 + 1);
                        int n5 = 0;
                        if (node == node3 || node == node4) {
                            ++n5;
                            if (n != i || n2 != 0 || n4 != arrayList.size() - 2) {
                                linkedHashSet.add(node);
                            }
                        }
                        if (node2 == node3 || node2 == node4) {
                            ++n5;
                            linkedHashSet.add(node2);
                        }
                        if (n5 == 0) {
                            EastNorth eastNorth = Geometry.getSegmentSegmentIntersection(node.getEastNorth(), node2.getEastNorth(), node3.getEastNorth(), node4.getEastNorth());
                            if (eastNorth != null) {
                                Node node5;
                                if (bl) {
                                    linkedHashSet.add(node3);
                                    return linkedHashSet;
                                }
                                Node node6 = node5 = new Node(Main.proj.eastNorth2latlon(eastNorth));
                                boolean bl2 = false;
                                boolean bl3 = false;
                                if (nodePositionComparator.compare(node5, node) == 0) {
                                    node6 = node;
                                } else if (nodePositionComparator.compare(node5, node2) == 0) {
                                    node6 = node2;
                                } else {
                                    bl2 = true;
                                }
                                if (nodePositionComparator.compare(node5, node3) == 0) {
                                    node6 = node3;
                                } else if (nodePositionComparator.compare(node5, node4) == 0) {
                                    node6 = node4;
                                } else {
                                    bl3 = true;
                                }
                                if (bl2) {
                                    ((ArrayList)object).add(n2 + 1, node6);
                                    blArray[n] = true;
                                    if (i == n) {
                                        ++n4;
                                    }
                                }
                                if (bl3) {
                                    arrayList.add(n4 + 1, node6);
                                    blArray[i] = true;
                                    ++n4;
                                }
                                linkedHashSet.add(node6);
                                if (node6 == node5) {
                                    list2.add(new AddCommand(node6));
                                }
                            }
                        } else if (bl && linkedHashSet.size() > 0) {
                            return linkedHashSet;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        for (n = 0; n < list.size(); ++n) {
            if (!blArray[n]) continue;
            Way way = list.get(n);
            object = new Way(way);
            ((Way)object).setNodes(arrayListArray[n]);
            list2.add(new ChangeCommand(way, (OsmPrimitive)object));
        }
        return linkedHashSet;
    }

    private static BBox getNodesBounds(ArrayList<Node> arrayList) {
        BBox bBox = new BBox(arrayList.get(0));
        for (Node node : arrayList) {
            bBox.add(node.getCoor());
        }
        return bBox;
    }

    public static boolean isToTheRightSideOfLine(Node node, Node node2, Node node3, Node node4) {
        boolean bl = Geometry.angleIsClockwise(node, node2, node3);
        boolean bl2 = Geometry.angleIsClockwise(node, node2, node4);
        boolean bl3 = Geometry.angleIsClockwise(node2, node3, node4);
        if (bl) {
            return bl2 && bl3;
        }
        return bl2 || bl3;
    }

    public static boolean angleIsClockwise(Node node, Node node2, Node node3) {
        double d = node2.getEastNorth().getY() - node.getEastNorth().getY();
        double d2 = node3.getEastNorth().getY() - node.getEastNorth().getY();
        double d3 = node2.getEastNorth().getX() - node.getEastNorth().getX();
        double d4 = node3.getEastNorth().getX() - node.getEastNorth().getX();
        return d * d4 - d3 * d2 > 0.0;
    }

    public static EastNorth getSegmentSegmentIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = eastNorth.getX();
        if (!Line2D.linesIntersect(d8, d7 = eastNorth.getY(), d6 = eastNorth2.getX(), d5 = eastNorth2.getY(), d4 = eastNorth3.getX(), d3 = eastNorth3.getY(), d2 = eastNorth4.getX(), d = eastNorth4.getY())) {
            return null;
        }
        double d9 = d5 - d7;
        double d10 = d8 - d6;
        double d11 = d6 * d7 - d8 * d5;
        double d12 = d - d3;
        double d13 = d4 - d2;
        double d14 = d2 * d3 - d4 * d;
        double d15 = d9 * d13 - d12 * d10;
        if (d15 == 0.0) {
            return null;
        }
        double d16 = (d10 * d14 - d13 * d11) / d15;
        double d17 = (d12 * d11 - d9 * d14) / d15;
        return new EastNorth(d16, d17);
    }

    public static EastNorth getLineLineIntersection(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth2.getX() * eastNorth.getY() - eastNorth.getX() * eastNorth2.getY();
        double d4 = eastNorth4.getY() - eastNorth3.getY();
        double d5 = eastNorth3.getX() - eastNorth4.getX();
        double d6 = eastNorth4.getX() * eastNorth3.getY() - eastNorth3.getX() * eastNorth4.getY();
        double d7 = d * d5 - d4 * d2;
        if (d7 == 0.0) {
            return null;
        }
        return new EastNorth((d2 * d6 - d5 * d3) / d7, (d4 * d3 - d * d6) / d7);
    }

    public static boolean segmentsParallel(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3, EastNorth eastNorth4) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth.getX() - eastNorth2.getX();
        double d3 = eastNorth4.getY() - eastNorth3.getY();
        double d4 = eastNorth3.getX() - eastNorth4.getX();
        double d5 = d * d4 - d3 * d2;
        return Math.abs(d5 /= Math.sqrt(d * d + d2 * d2) * Math.sqrt(d3 * d3 + d4 * d4)) < 0.001;
    }

    public static EastNorth closestPointToSegment(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        double d;
        double d2 = eastNorth2.getX() - eastNorth.getX();
        double d3 = eastNorth2.getY() - eastNorth.getY();
        if (d2 == 0.0 && d3 == 0.0) {
            return eastNorth;
        }
        double d4 = eastNorth3.getX() - eastNorth.getX();
        double d5 = (d4 * d2 + (d = eastNorth3.getY() - eastNorth.getY()) * d3) / (d2 * d2 + d3 * d3);
        if (d5 <= 0.0) {
            return eastNorth;
        }
        if (d5 >= 1.0) {
            return eastNorth2;
        }
        return new EastNorth(eastNorth.getX() + d2 * d5, eastNorth.getY() + d3 * d5);
    }

    public static boolean angleIsClockwise(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        double d = eastNorth2.getY() - eastNorth.getY();
        double d2 = eastNorth3.getY() - eastNorth.getY();
        double d3 = eastNorth2.getX() - eastNorth.getX();
        double d4 = eastNorth3.getX() - eastNorth.getX();
        return d * d4 - d3 * d2 > 0.0;
    }

    public static PolygonIntersection polygonIntersection(List<Node> list, List<Node> list2) {
        HashSet<Node> hashSet = new HashSet<Node>(list);
        HashSet<Node> hashSet2 = new HashSet<Node>(list2);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Node node : list) {
            if (hashSet2.contains(node)) continue;
            if (Geometry.nodeInsidePolygon(node, list2)) {
                ++n;
                continue;
            }
            ++n2;
        }
        for (Node node : list2) {
            if (hashSet.contains(node)) continue;
            if (Geometry.nodeInsidePolygon(node, list)) {
                ++n3;
                continue;
            }
            ++n4;
        }
        if (n3 == 0) {
            if (n == 0) {
                if (n4 + n > 0) {
                    return PolygonIntersection.OUTSIDE;
                }
                return PolygonIntersection.CROSSING;
            }
            return PolygonIntersection.FIRST_INSIDE_SECOND;
        }
        if (n == 0) {
            return PolygonIntersection.SECOND_INSIDE_FIRST;
        }
        return PolygonIntersection.CROSSING;
    }

    public static boolean nodeInsidePolygon(Node node, List<Node> list) {
        if (list.size() < 2) {
            return false;
        }
        boolean bl = false;
        Node node2 = list.get(list.size() - 1);
        for (Node node3 : list) {
            Node node4;
            Node node5;
            if (node3.equals(node2)) continue;
            if (node3.getEastNorth().getY() > node2.getEastNorth().getY()) {
                node5 = node2;
                node4 = node3;
            } else {
                node5 = node3;
                node4 = node2;
            }
            if (node3.getEastNorth().getY() < node.getEastNorth().getY() == node.getEastNorth().getY() <= node2.getEastNorth().getY() && (node.getEastNorth().getX() - node5.getEastNorth().getX()) * (node4.getEastNorth().getY() - node5.getEastNorth().getY()) < (node4.getEastNorth().getX() - node5.getEastNorth().getX()) * (node.getEastNorth().getY() - node5.getEastNorth().getY())) {
                bl = !bl;
            }
            node2 = node3;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PolygonIntersection {
        FIRST_INSIDE_SECOND,
        SECOND_INSIDE_FIRST,
        OUTSIDE,
        CROSSING;

    }
}

