/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginListParser {
    protected PluginInformation createInfo(String string, String string2, String string3) throws PluginListParseException {
        try {
            return new PluginInformation(new ByteArrayInputStream(string3.getBytes("utf-8")), string.substring(0, string.length() - 4), string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", string), unsupportedEncodingException);
        }
        catch (PluginException pluginException) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", string), pluginException);
        }
    }

    public List<PluginInformation> parse(InputStream inputStream) throws PluginListParseException {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            Object object = null;
            Object object2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            Object object3 = bufferedReader.readLine();
            while (object3 != null) {
                if (((String)object3).startsWith("\t")) {
                    if (((String)(object3 = ((String)object3).substring(1))).length() > 70) {
                        stringBuilder.append(((String)object3).substring(0, 70)).append("\n");
                        object3 = " " + ((String)object3).substring(70);
                    }
                    stringBuilder.append((String)object3).append("\n");
                } else {
                    Object object4;
                    if (object != null && (object4 = this.createInfo((String)object, (String)object2, stringBuilder.toString())) != null) {
                        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
                            if (!pluginProxy.getPluginInformation().name.equals(((PluginInformation)object4).getName())) continue;
                            ((PluginInformation)object4).localversion = pluginProxy.getPluginInformation().localversion;
                        }
                        linkedList.add((PluginInformation)object4);
                    }
                    if (((String[])(object4 = ((String)object3).split(";"))).length != 2) {
                        throw new IOException(I18n.tr("Illegal entry in plugin list."));
                    }
                    object = object4[0];
                    object2 = object4[1];
                    stringBuilder = new StringBuilder();
                }
                object3 = bufferedReader.readLine();
            }
            if (object != null && (object3 = this.createInfo((String)object, (String)object2, stringBuilder.toString())) != null) {
                for (PluginProxy pluginProxy : PluginHandler.pluginList) {
                    if (!pluginProxy.getPluginInformation().name.equals(((PluginInformation)object3).getName())) continue;
                    ((PluginInformation)object3).localversion = pluginProxy.getPluginInformation().localversion;
                }
                linkedList.add((PluginInformation)object3);
            }
            return linkedList;
        }
        catch (IOException iOException) {
            throw new PluginListParseException(iOException);
        }
    }
}

