/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import org.openstreetmap.josm.data.imagery.GeorefImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSRequest
implements Comparable<WMSRequest> {
    private final int xIndex;
    private final int yIndex;
    private final double pixelPerDegree;
    private final boolean real;
    private int priority;
    private GeorefImage.State state;
    private BufferedImage image;

    public WMSRequest(int n, int n2, double d, boolean bl) {
        this.xIndex = n;
        this.yIndex = n2;
        this.pixelPerDegree = d;
        this.real = bl;
    }

    public void finish(GeorefImage.State state, BufferedImage bufferedImage) {
        this.state = state;
        this.image = bufferedImage;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.pixelPerDegree);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + this.xIndex;
        n = 31 * n + this.yIndex;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WMSRequest wMSRequest = (WMSRequest)object;
        if (Double.doubleToLongBits(this.pixelPerDegree) != Double.doubleToLongBits(wMSRequest.pixelPerDegree)) {
            return false;
        }
        if (this.xIndex != wMSRequest.xIndex) {
            return false;
        }
        return this.yIndex == wMSRequest.yIndex;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(WMSRequest wMSRequest) {
        return this.priority - wMSRequest.priority;
    }

    public GeorefImage.State getState() {
        return this.state;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String toString() {
        return "WMSRequest [xIndex=" + this.xIndex + ", yIndex=" + this.yIndex + ", pixelPerDegree=" + this.pixelPerDegree + "]";
    }

    public boolean isReal() {
        return this.real;
    }
}

