/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.io.imagery.WMSRequest;

public abstract class Grabber
implements Runnable {
    public static final CacheFiles cache = new CacheFiles("imagery", false);
    protected final MapView mv;
    protected final WMSLayer layer;
    protected ProjectionBounds b;
    protected Projection proj;
    protected double pixelPerDegree;
    protected WMSRequest request;
    protected volatile boolean canceled;

    Grabber(MapView mapView, WMSLayer wMSLayer) {
        this.mv = mapView;
        this.layer = wMSLayer;
    }

    private void updateState(WMSRequest wMSRequest) {
        this.b = new ProjectionBounds(this.layer.getEastNorth(wMSRequest.getXIndex(), wMSRequest.getYIndex()), this.layer.getEastNorth(wMSRequest.getXIndex() + 1, wMSRequest.getYIndex() + 1));
        if (this.b.min != null && this.b.max != null && WMSLayer.PROP_OVERLAP.get()) {
            double d = this.b.max.east() - this.b.min.east();
            double d2 = this.b.max.north() - this.b.min.north();
            double d3 = (double)WMSLayer.PROP_OVERLAP_EAST.get() / 100.0;
            double d4 = (double)WMSLayer.PROP_OVERLAP_NORTH.get() / 100.0;
            this.b = new ProjectionBounds(new EastNorth(this.b.min.east(), this.b.min.north()), new EastNorth(this.b.max.east() + d3 * d, this.b.max.north() + d4 * d2));
        }
        this.proj = Main.proj;
        this.pixelPerDegree = wMSRequest.getPixelPerDegree();
        this.request = wMSRequest;
    }

    abstract void fetch(WMSRequest var1, int var2) throws Exception;

    int width() {
        return this.layer.getBaseImageWidth();
    }

    int height() {
        return this.layer.getBaseImageHeight();
    }

    public void run() {
        while (!this.canceled) {
            WMSRequest wMSRequest = this.layer.getRequest();
            if (wMSRequest == null) {
                return;
            }
            this.updateState(wMSRequest);
            if (!this.loadFromCache(wMSRequest)) {
                this.attempt(wMSRequest);
            }
            this.layer.finishRequest(wMSRequest);
        }
        return;
    }

    protected void attempt(WMSRequest wMSRequest) {
        int n = 5;
        for (int i = 1; i <= n; ++i) {
            if (this.canceled) {
                return;
            }
            try {
                if (!this.layer.requestIsValid(wMSRequest)) {
                    return;
                }
                this.fetch(wMSRequest, i);
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(Grabber.random(1000, 2000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i != n) continue;
                exception.printStackTrace();
                wMSRequest.finish(GeorefImage.State.FAILED, null);
                continue;
            }
        }
    }

    public static int random(int n, int n2) {
        return (int)(Math.random() * (double)(n2 + 1 - n)) + n;
    }

    public abstract boolean loadFromCache(WMSRequest var1);

    public void cancel() {
        this.canceled = true;
    }
}

