/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;

public class MapPaintVisitor
implements PaintVisitor {
    private Graphics2D g;
    private boolean inactive;
    private NavigatableComponent nc;
    private ElemStyles styles;
    private double circum;
    private MapPainter painter;
    private MapPaintSettings paintSettings;
    private static int FLAG_NORMAL = 0;
    private static int FLAG_DISABLED = 1;
    private static int FLAG_SELECTED = 2;
    private static int FLAG_MEMBER_OF_SELECTED = 4;

    public void visitAll(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = new BBox(bounds);
        this.styles = MapPaintStyles.getStyles();
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        boolean bl2 = this.circum <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000);
        boolean bl3 = bl2 && Main.pref.getBoolean("mappaint.multipolygon", true);
        this.styles.setDrawMultipolygon(bl3);
        boolean bl4 = Main.pref.getBoolean("mappaint.restriction", true);
        boolean bl5 = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", true) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.painter = new MapPainter(this.paintSettings, this.g, this.inactive, this.nc, bl, this.circum, bl5);
        StyleCollector styleCollector = new StyleCollector(bl2, bl3, bl4);
        for (Node osmPrimitive : dataSet.searchNodes(bBox)) {
            if (!osmPrimitive.isDrawable()) continue;
            if (osmPrimitive.isDisabled()) {
                styleCollector.add(osmPrimitive, FLAG_DISABLED);
                continue;
            }
            if (dataSet.isSelected(osmPrimitive)) {
                styleCollector.add(osmPrimitive, FLAG_SELECTED);
                continue;
            }
            if (osmPrimitive.isMemberOfSelected()) {
                styleCollector.add(osmPrimitive, FLAG_MEMBER_OF_SELECTED);
                continue;
            }
            styleCollector.add(osmPrimitive, FLAG_NORMAL);
        }
        for (Way way : dataSet.searchWays(bBox)) {
            if (!way.isDrawable()) continue;
            if (way.isDisabled()) {
                styleCollector.add(way, FLAG_DISABLED);
                continue;
            }
            if (dataSet.isSelected(way)) {
                styleCollector.add(way, FLAG_SELECTED);
                continue;
            }
            if (way.isMemberOfSelected()) {
                styleCollector.add(way, FLAG_MEMBER_OF_SELECTED);
                continue;
            }
            styleCollector.add(way, FLAG_NORMAL);
        }
        for (Relation relation : dataSet.searchRelations(bBox)) {
            if (!relation.isDrawable()) continue;
            if (relation.isDisabled()) {
                styleCollector.add(relation, FLAG_DISABLED);
                continue;
            }
            if (dataSet.isSelected(relation)) {
                styleCollector.add(relation, FLAG_SELECTED);
                continue;
            }
            styleCollector.add(relation, FLAG_NORMAL);
        }
        styleCollector.drawAll();
        styleCollector = null;
        this.painter.drawVirtualNodes(dataSet.searchWays(bBox));
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public void setInactive(boolean bl) {
        this.inactive = bl;
    }

    public void setNavigatableComponent(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }

    private class StyleCollector {
        private final boolean drawArea;
        private final boolean drawMultipolygon;
        private final boolean drawRestriction;
        private final List<StyleRecord> styleElems;

        public StyleCollector(boolean bl, boolean bl2, boolean bl3) {
            this.drawArea = bl;
            this.drawMultipolygon = bl2;
            this.drawRestriction = bl3;
            this.styleElems = new ArrayList<StyleRecord>();
        }

        public void add(Node node, int n) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(node, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                this.styleElems.add(new StyleRecord(elemStyle, node, n));
            }
        }

        public void add(Way way, int n) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(way, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if ((!this.drawArea || (n & FLAG_DISABLED) != 0) && elemStyle instanceof AreaElemStyle) continue;
                this.styleElems.add(new StyleRecord(elemStyle, way, n));
            }
        }

        public void add(Relation relation, int n) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(relation, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if (this.drawMultipolygon && this.drawArea && elemStyle instanceof AreaElemStyle && (n & FLAG_DISABLED) == 0) {
                    this.styleElems.add(new StyleRecord(elemStyle, relation, n));
                    continue;
                }
                if (!this.drawRestriction || !(elemStyle instanceof NodeElemStyle)) continue;
                this.styleElems.add(new StyleRecord(elemStyle, relation, n));
            }
        }

        public void drawAll() {
            Collections.sort(this.styleElems);
            for (StyleRecord styleRecord : this.styleElems) {
                styleRecord.style.paintPrimitive(styleRecord.osm, MapPaintVisitor.this.paintSettings, MapPaintVisitor.this.painter, (styleRecord.flags & FLAG_SELECTED) != 0, (styleRecord.flags & FLAG_MEMBER_OF_SELECTED) != 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StyleRecord
    implements Comparable<StyleRecord> {
        final ElemStyle style;
        final OsmPrimitive osm;
        final int flags;

        public StyleRecord(ElemStyle elemStyle, OsmPrimitive osmPrimitive, int n) {
            this.style = elemStyle;
            this.osm = osmPrimitive;
            this.flags = n;
        }

        @Override
        public int compareTo(StyleRecord styleRecord) {
            if ((this.flags & FLAG_DISABLED) != 0 && (styleRecord.flags & FLAG_DISABLED) == 0) {
                return -1;
            }
            if ((this.flags & FLAG_DISABLED) == 0 && (styleRecord.flags & FLAG_DISABLED) != 0) {
                return 1;
            }
            float f = this.style.z_index;
            if ((this.flags & FLAG_SELECTED) != 0) {
                f += 700.0f;
            } else if ((this.flags & FLAG_MEMBER_OF_SELECTED) != 0) {
                f += 600.0f;
            }
            float f2 = styleRecord.style.z_index;
            if ((styleRecord.flags & FLAG_SELECTED) != 0) {
                f2 += 700.0f;
            } else if ((styleRecord.flags & FLAG_MEMBER_OF_SELECTED) != 0) {
                f2 += 600.0f;
            }
            int n = Float.compare(f, f2);
            if (n != 0) {
                return n;
            }
            if (this.style == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && styleRecord.style != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return 1;
            }
            if (this.style != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && styleRecord.style == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return -1;
            }
            long l = this.osm.getUniqueId() - styleRecord.osm.getUniqueId();
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return Float.compare(this.style.object_z_index, styleRecord.style.object_z_index);
        }
    }
}

