/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.util.Collection;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static <T> boolean exists(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean exists(Iterable iterable, Class<? extends T> clazz) {
        for (Object t : iterable) {
            if (!clazz.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T find(Iterable iterable, Class<? extends T> clazz) {
        for (Object t : iterable) {
            if (!clazz.isInstance(t)) continue;
            Object t2 = t;
            return t2;
        }
        return null;
    }

    public static <T> int indexOf(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        int n = 0;
        for (T t : iterable) {
            if (predicate.evaluate(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int min(int n, int n2, int n3) {
        if (n2 < n3) {
            if (n < n2) {
                return n;
            }
            return n2;
        }
        if (n < n3) {
            return n;
        }
        return n3;
    }

    public static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    public static <T> boolean equal(T t, T t2) {
        if (t == t2) {
            return true;
        }
        return t != null && t.equals(t2);
    }

    public static int mod(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    public static String join(String string, Collection<?> collection) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = null;
        for (Object object : collection) {
            if (object == null) {
                object = "";
            }
            if (stringBuilder != null) {
                stringBuilder.append(string).append(object.toString());
                continue;
            }
            stringBuilder = new StringBuilder(object.toString());
        }
        return stringBuilder.toString();
    }

    public static String toString(Color color) {
        if (color == null) {
            return "null";
        }
        if (color.getAlpha() == 255) {
            return String.format("#%06x", color.getRGB() & 0xFFFFFF);
        }
        return String.format("#%06x(alpha=%d)", color.getRGB() & 0xFFFFFF, color.getAlpha());
    }

    public static Integer color_float2int(Float f) {
        if (f == null) {
            return null;
        }
        if (f.floatValue() < 0.0f || f.floatValue() > 1.0f) {
            return 255;
        }
        return (int)(255.0f * f.floatValue() + 0.5f);
    }

    public static Float color_int2float(Integer n) {
        if (n == null) {
            return null;
        }
        if (n < 0 || n > 255) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)n.intValue() / 255.0f);
    }

    public static Color complement(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }
}

