/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPainter {
    private final Graphics2D g;
    private final NavigatableComponent nc;
    private final boolean inactive;
    private final MapPaintSettings settings;
    private final boolean useStrokes;
    private final boolean showNames;
    private final boolean showIcons;
    private final boolean isOutlineOnly;
    private final Color inactiveColor;
    private final Color selectedColor;
    private final Color relationSelectedColor;
    private final Color nodeColor;
    private final Color backgroundColor;
    private final Font orderFont;
    private final int virtualNodeSize;
    private final int virtualNodeSpace;
    private final int segmentNumberSpace;
    private final double circum;
    private final boolean leftHandTraffic;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);

    public MapPainter(MapPaintSettings mapPaintSettings, Graphics2D graphics2D, boolean bl, NavigatableComponent navigatableComponent, boolean bl2, double d, boolean bl3) {
        this.settings = mapPaintSettings;
        this.g = graphics2D;
        this.inactive = bl;
        this.nc = navigatableComponent;
        this.useStrokes = (double)mapPaintSettings.getUseStrokesDistance() > d;
        this.showNames = (double)mapPaintSettings.getShowNamesDistance() > d;
        this.showIcons = (double)mapPaintSettings.getShowIconsDistance() > d;
        this.isOutlineOnly = mapPaintSettings.isOutlineOnly();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.backgroundColor = PaintColors.getBackgroundColor();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Helvetica"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.virtualNodeSize = bl2 ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.circum = d;
        this.leftHandTraffic = bl3;
    }

    public void drawWay(Way way, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = bl ? new GeneralPath() : null;
        GeneralPath generalPath3 = bl3 ? new GeneralPath() : null;
        GeneralPath generalPath4 = bl3 ? new GeneralPath() : null;
        Rectangle rectangle = this.g.getClipBounds();
        rectangle.grow(100, 100);
        double d = 0.0;
        Point point = null;
        boolean bl5 = true;
        Iterator<Node> iterator = way.getNodes().iterator();
        while (iterator.hasNext()) {
            Point point2;
            Point point3;
            LineClip lineClip;
            Node node = iterator.next();
            Point point4 = this.nc.getPoint(node);
            if (point != null && (lineClip = new LineClip(point3 = point, point2 = point4, rectangle)).execute()) {
                double d2;
                double d3;
                double d4;
                if (!point3.equals(lineClip.getP1())) {
                    point3 = lineClip.getP1();
                    generalPath.moveTo(point3.x, point3.y);
                } else if (bl5) {
                    bl5 = false;
                    generalPath.moveTo(point3.x, point3.y);
                }
                point2 = lineClip.getP2();
                generalPath.lineTo(point2.x, point2.y);
                if (bl2 ? !iterator.hasNext() : bl) {
                    d4 = (10.0 + (double)basicStroke.getLineWidth()) / point3.distance(point2);
                    d3 = d4 * (double)(point3.x - point2.x);
                    d2 = d4 * (double)(point3.y - point2.y);
                    generalPath2.moveTo(point2.x, point2.y);
                    generalPath2.lineTo((double)point2.x + cosPHI * d3 - sinPHI * d2, (double)point2.y + sinPHI * d3 + cosPHI * d2);
                    generalPath2.moveTo((double)point2.x + cosPHI * d3 + sinPHI * d2, (double)point2.y - sinPHI * d3 + cosPHI * d2);
                    generalPath2.lineTo(point2.x, point2.y);
                }
                if (bl3) {
                    d4 = point3.distance(point2);
                    d3 = (double)(point2.x - point3.x) / d4;
                    d2 = (double)(point2.y - point3.y) / d4;
                    for (double d5 = 60.0 - d % 60.0; d5 < d4; d5 += 60.0) {
                        for (Pair pair : Arrays.asList(new Pair<Float, GeneralPath>(Float.valueOf(3.0f), generalPath4), new Pair<Float, GeneralPath>(Float.valueOf(2.0f), generalPath3))) {
                            double d6 = (double)((float)(-(bl4 ? -1 : 1)) * ((Float)pair.a).floatValue()) * (1.0 + sinPHI) / (sinPHI * cosPHI);
                            double d7 = d3 * d6;
                            double d8 = d2 * d6;
                            double d9 = (double)point3.x + d3 * (d5 + (double)(bl4 ? -1 : 1) * ((double)((Float)pair.a).floatValue() / sinPHI));
                            double d10 = (double)point3.y + d2 * (d5 + (double)(bl4 ? -1 : 1) * ((double)((Float)pair.a).floatValue() / sinPHI));
                            ((GeneralPath)pair.b).moveTo(d9, d10);
                            ((GeneralPath)pair.b).lineTo(d9 + cosPHI * d7 - sinPHI * d8, d10 + sinPHI * d7 + cosPHI * d8);
                            ((GeneralPath)pair.b).lineTo(d9 + cosPHI * d7 + sinPHI * d8, d10 - sinPHI * d7 + cosPHI * d8);
                            ((GeneralPath)pair.b).lineTo(d9, d10);
                        }
                    }
                    d += d4;
                }
            }
            point = point4;
        }
        this.displaySegments(generalPath, generalPath2, generalPath3, generalPath4, color, basicStroke, basicStroke2, color2);
    }

    private void displaySegments(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, GeneralPath generalPath4, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2) {
        this.g.setColor(this.inactive ? this.inactiveColor : color);
        if (this.useStrokes) {
            this.g.setStroke(basicStroke);
        }
        this.g.draw(generalPath);
        if (!this.inactive && this.useStrokes && basicStroke2 != null) {
            this.g.setColor(color2);
            this.g.setStroke(basicStroke2);
            this.g.draw(generalPath);
        }
        if (generalPath2 != null) {
            this.g.setColor(this.inactive ? this.inactiveColor : color);
            this.g.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.draw(generalPath2);
        }
        if (generalPath3 != null) {
            this.g.setStroke(new BasicStroke(1.0f, basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.fill(generalPath4);
            this.g.setColor(this.inactive ? this.inactiveColor : this.backgroundColor);
            this.g.fill(generalPath3);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private boolean isSegmentVisible(Point point, Point point2) {
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.nc.getWidth() && point2.x > this.nc.getWidth()) {
            return false;
        }
        return point.y <= this.nc.getHeight() || point2.y <= this.nc.getHeight();
    }

    public void drawTextOnPath(Way way, TextElement textElement) {
        double d;
        double d2;
        double d3;
        double[] dArray;
        Cloneable cloneable;
        Object object;
        if (textElement == null) {
            return;
        }
        String string = textElement.getString(way);
        if (string == null || string.equals("")) {
            return;
        }
        Polygon polygon = new Polygon();
        Cloneable cloneable2 = null;
        Iterator<Node> iterator = way.getNodes().iterator();
        double d4 = 0.0;
        while (iterator.hasNext()) {
            object = iterator.next();
            cloneable = this.nc.getPoint((Node)object);
            polygon.addPoint(((Point)cloneable).x, ((Point)cloneable).y);
            if (cloneable2 != null) {
                int n = ((Point)cloneable).x - ((Point)cloneable2).x;
                int n2 = ((Point)cloneable).y - ((Point)cloneable2).y;
                d4 += Math.sqrt(n * n + n2 * n2);
            }
            cloneable2 = cloneable;
        }
        object = this.g.getFontMetrics(textElement.font);
        cloneable = ((FontMetrics)object).getStringBounds(string, this.g);
        if (((RectangularShape)cloneable).getWidth() > d4) {
            return;
        }
        double d5 = (d4 / 2.0 - ((RectangularShape)cloneable).getWidth() / 2.0) / d4;
        double d6 = (d4 / 2.0 + ((RectangularShape)cloneable).getWidth() / 2.0) / d4;
        double[] dArray2 = this.pointAt(d5, polygon, d4);
        if (dArray2[0] < (dArray = this.pointAt(d6, polygon, d4))[0] && dArray2[2] < 1.5707963267948966 && dArray2[2] > -1.5707963267948966) {
            d3 = 0.0;
            d2 = 1.0;
            d = d5;
        } else {
            d3 = Math.PI;
            d2 = -1.0;
            d = d6;
        }
        FontRenderContext fontRenderContext = this.g.getFontRenderContext();
        GlyphVector glyphVector = textElement.font.createGlyphVector(fontRenderContext, string);
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            Rectangle2D rectangle2D = glyphVector.getGlyphLogicalBounds(i).getBounds2D();
            double d7 = d + d2 * (rectangle2D.getX() + rectangle2D.getWidth() / 2.0) / d4;
            double[] dArray3 = this.pointAt(d7, polygon, d4);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray3[0] - rectangle2D.getX(), dArray3[1]);
            affineTransform.rotate(dArray3[2] + d3);
            double d8 = -rectangle2D.getY() - rectangle2D.getHeight() / 2.0 + (double)textElement.yOffset;
            affineTransform.translate(-rectangle2D.getWidth() / 2.0, d8);
            glyphVector.setGlyphTransform(i, affineTransform);
        }
        if (textElement.haloRadius != null) {
            Shape shape = glyphVector.getOutline();
            this.g.setStroke(new BasicStroke(2.0f * textElement.haloRadius.floatValue(), 0, 1));
            this.g.setColor(textElement.haloColor);
            this.g.draw(shape);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(textElement.color);
            this.g.fill(shape);
        } else {
            this.g.setColor(textElement.color);
            this.g.drawGlyphVector(glyphVector, 0.0f, 0.0f);
        }
    }

    private double[] pointAt(double d, Polygon polygon, double d2) {
        double d3 = d * d2;
        double d4 = 0.0;
        for (int i = 1; i < polygon.npoints; ++i) {
            int n = polygon.xpoints[i] - polygon.xpoints[i - 1];
            int n2 = polygon.ypoints[i] - polygon.ypoints[i - 1];
            double d5 = Math.sqrt(n * n + n2 * n2);
            if (d3 > d4 + d5) {
                d4 += d5;
                continue;
            }
            return new double[]{(double)polygon.xpoints[i - 1] + (d3 - d4) / d5 * (double)n, (double)polygon.ypoints[i - 1] + (d3 - d4) / d5 * (double)n2, Math.atan2(n2, n)};
        }
        return null;
    }

    public void drawLinePattern(Way way, ImageIcon imageIcon) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        Point point = null;
        double d = 0.0;
        for (Node node : way.getNodes()) {
            Point point2 = this.nc.getPoint(node);
            if (point != null) {
                double d2 = point2.distance(point);
                double d3 = point2.x - point.x;
                double d4 = point2.y - point.y;
                double d5 = d == 0.0 ? 0.0 : (double)n - d % (double)n;
                AffineTransform affineTransform = this.g.getTransform();
                this.g.translate(point.x, point.y);
                this.g.rotate(Math.atan2(d4, d3));
                if (d5 > 0.0) {
                    this.g.drawImage(imageIcon.getImage(), 0, 0, (int)d5, n2, n - (int)d5, 0, n, n2, null);
                }
                while (d5 < d2) {
                    if (d5 + (double)n > d2) {
                        this.g.drawImage(imageIcon.getImage(), (int)d5, 0, (int)d2, n2, 0, 0, (int)d2 - (int)d5, n2, null);
                    } else {
                        imageIcon.paintIcon(this.nc, this.g, (int)d5, 0);
                    }
                    d5 += (double)n;
                }
                this.g.setTransform(affineTransform);
                d += d2;
            }
            point = point2;
        }
    }

    public void drawNodeIcon(Node node, ImageIcon imageIcon, float f, boolean bl, boolean bl2, NodeElemStyle.NodeTextElement nodeTextElement) {
        Point point = this.nc.getPoint(node);
        if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
            return;
        }
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (f != 1.0f) {
            this.g.setComposite(AlphaComposite.getInstance(3, f));
        }
        imageIcon.paintIcon(this.nc, this.g, point.x - n / 2, point.y - n2 / 2);
        this.g.setPaintMode();
        this.drawNodeText(node, nodeTextElement, point, n / 2, n2 / 2);
        if (bl || bl2) {
            this.g.setColor(bl ? this.selectedColor : this.relationSelectedColor);
            this.g.drawRect(point.x - n / 2 - 2, point.y - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    private Polygon buildPolygon(Point point, int n, int n2, double d) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < n2; ++i) {
            double d2 = Math.PI * 2 / (double)n2 * (double)i - d;
            int n3 = (int)Math.round((double)point.x + (double)n * Math.cos(d2));
            int n4 = (int)Math.round((double)point.y + (double)n * Math.sin(d2));
            polygon.addPoint(n3, n4);
        }
        return polygon;
    }

    private Polygon buildPolygon(Point point, int n, int n2) {
        return this.buildPolygon(point, n, n2, 0.0);
    }

    public void drawNodeSymbol(Node node, NodeElemStyle.Symbol symbol, Color color, Color color2, NodeElemStyle.NodeTextElement nodeTextElement) {
        Point point = this.nc.getPoint(node);
        if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
            return;
        }
        int n = symbol.size / 2;
        if (color != null) {
            this.g.setColor(color);
            switch (symbol.symbol) {
                case SQUARE: {
                    this.g.fillRect(point.x - n, point.y - n, symbol.size, symbol.size);
                    break;
                }
                case CIRCLE: {
                    this.g.fillOval(point.x - n, point.y - n, symbol.size, symbol.size);
                    break;
                }
                case TRIANGLE: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (symbol.stroke != null) {
            this.g.setStroke(symbol.stroke);
            this.g.setColor(color2);
            switch (symbol.symbol) {
                case SQUARE: {
                    this.g.drawRect(point.x - n, point.y - n, symbol.size - 1, symbol.size - 1);
                    break;
                }
                case CIRCLE: {
                    this.g.drawOval(point.x - n, point.y - n, symbol.size - 1, symbol.size - 1);
                    break;
                }
                case TRIANGLE: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.g.setStroke(new BasicStroke());
        }
        this.drawNodeText(node, nodeTextElement, point, n, n);
    }

    public void drawNode(Node node, Color color, int n, boolean bl, NodeElemStyle.NodeTextElement nodeTextElement) {
        if (n > 1) {
            Point point = this.nc.getPoint(node);
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            int n2 = n / 2;
            if (this.inactive || node.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            if (bl) {
                this.g.fillRect(point.x - n2, point.y - n2, n + 1, n + 1);
            } else {
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            }
            this.drawNodeText(node, nodeTextElement, point, n2, n2 + 4);
        }
    }

    private void drawNodeText(Node node, NodeElemStyle.NodeTextElement nodeTextElement, Point point, int n, int n2) {
        Object object;
        FontRenderContext fontRenderContext;
        if (!this.isShowNames() || nodeTextElement == null) {
            return;
        }
        if (nodeTextElement.labelCompositionStrategy == null) {
            return;
        }
        String string = nodeTextElement.labelCompositionStrategy.compose(node);
        if (string == null) {
            return;
        }
        Font font = this.g.getFont();
        this.g.setFont(nodeTextElement.font);
        int n3 = point.x + nodeTextElement.xOffset;
        int n4 = point.y + nodeTextElement.yOffset;
        if (nodeTextElement.hAlign == NodeElemStyle.HorizontalTextAlignment.RIGHT) {
            n3 += n + 2;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = nodeTextElement.font.getStringBounds(string, fontRenderContext);
            int n5 = (int)((RectangularShape)object).getWidth();
            if (nodeTextElement.hAlign == NodeElemStyle.HorizontalTextAlignment.CENTER) {
                n3 -= n5 / 2;
            } else if (nodeTextElement.hAlign == NodeElemStyle.HorizontalTextAlignment.LEFT) {
                n3 -= n + 4 + n5;
            } else {
                throw new AssertionError();
            }
        }
        if (nodeTextElement.vAlign == NodeElemStyle.VerticalTextAlignment.BOTTOM) {
            n4 += n2 - 2;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = nodeTextElement.font.getLineMetrics(string, fontRenderContext);
            if (nodeTextElement.vAlign == NodeElemStyle.VerticalTextAlignment.ABOVE) {
                n4 = (int)((float)n4 - ((float)n2 + ((LineMetrics)object).getDescent()));
            } else if (nodeTextElement.vAlign == NodeElemStyle.VerticalTextAlignment.TOP) {
                n4 = (int)((float)n4 - ((float)n2 - ((LineMetrics)object).getAscent()));
            } else if (nodeTextElement.vAlign == NodeElemStyle.VerticalTextAlignment.CENTER) {
                n4 = (int)((float)n4 + (((LineMetrics)object).getAscent() - ((LineMetrics)object).getDescent()) / 2.0f);
            } else if (nodeTextElement.vAlign == NodeElemStyle.VerticalTextAlignment.BELOW) {
                n4 = (int)((float)n4 + ((float)n2 + ((LineMetrics)object).getAscent() + 2.0f));
            } else {
                throw new AssertionError();
            }
        }
        if (this.inactive || node.isDisabled()) {
            this.g.setColor(this.inactiveColor);
        } else {
            this.g.setColor(nodeTextElement.color);
        }
        if (nodeTextElement.haloRadius != null) {
            this.g.setStroke(new BasicStroke(2.0f * nodeTextElement.haloRadius.floatValue(), 0, 1));
            this.g.setColor(nodeTextElement.haloColor);
            fontRenderContext = this.g.getFontRenderContext();
            object = nodeTextElement.font.createGlyphVector(fontRenderContext, string);
            Shape shape = ((GlyphVector)object).getOutline(n3, n4);
            this.g.draw(shape);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(nodeTextElement.color);
            this.g.fill(shape);
        } else {
            this.g.drawString(string, n3, n4);
        }
        this.g.setFont(font);
    }

    private Polygon getPolygon(Way way) {
        Polygon polygon = new Polygon();
        for (Node node : way.getNodes()) {
            Point point = this.nc.getPoint(node);
            polygon.addPoint(point.x, point.y);
        }
        return polygon;
    }

    public void drawArea(Way way, Color color, BufferedImage bufferedImage, float f, TextElement textElement) {
        Polygon polygon = this.getPolygon(way);
        this.drawArea(way, polygon, color, bufferedImage, f, textElement);
    }

    protected void drawArea(OsmPrimitive osmPrimitive, Polygon polygon, Color color, BufferedImage bufferedImage, float f, TextElement textElement) {
        Object object;
        if (!this.isOutlineOnly) {
            if (bufferedImage == null) {
                this.g.setColor(color);
                this.g.fillPolygon(polygon);
            } else {
                object = new TexturePaint(bufferedImage, new Rectangle(polygon.xpoints[0], polygon.ypoints[0], bufferedImage.getWidth(), bufferedImage.getHeight()));
                this.g.setPaint((Paint)object);
                if (f != 1.0f) {
                    this.g.setComposite(AlphaComposite.getInstance(3, f));
                }
                this.g.fill(polygon);
                this.g.setPaintMode();
            }
        }
        if (textElement != null && this.isShowNames()) {
            if (textElement.labelCompositionStrategy == null) {
                return;
            }
            object = textElement.labelCompositionStrategy.compose(osmPrimitive);
            if (object == null) {
                return;
            }
            Rectangle rectangle = polygon.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object, this.g);
            Rectangle rectangle2 = new Rectangle(rectangle.x + (int)(((double)rectangle.width - rectangle2D.getWidth()) / 2.0), rectangle.y + (int)(((double)rectangle.height - rectangle2D.getHeight()) / 2.0), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            if ((double)rectangle.width >= rectangle2D.getWidth() && (double)rectangle.height >= rectangle2D.getHeight() && polygon.contains(rectangle2)) {
                this.g.setColor(textElement.color);
                Font font = this.g.getFont();
                this.g.setFont(textElement.font);
                this.g.drawString((String)object, (int)(rectangle2.getMinX() - rectangle2D.getMinX()), (int)(rectangle2.getMinY() - rectangle2D.getMinY()));
                this.g.setFont(font);
            }
        }
    }

    public void drawArea(Relation relation, Color color, BufferedImage bufferedImage, float f, TextElement textElement) {
        Multipolygon multipolygon = new Multipolygon(this.nc);
        multipolygon.load(relation);
        if (!relation.isDisabled() && !multipolygon.getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                Polygon polygon = polyData.get();
                if (!this.isPolygonVisible(polygon)) continue;
                this.drawArea(relation, polygon, polyData.selected ? this.settings.getRelationSelectedColor(color.getAlpha()) : color, bufferedImage, f, textElement);
            }
        }
    }

    private boolean isPolygonVisible(Polygon polygon) {
        Rectangle rectangle = polygon.getBounds();
        if (rectangle.width == 0 && rectangle.height == 0) {
            return false;
        }
        if (rectangle.x > this.nc.getWidth()) {
            return false;
        }
        if (rectangle.y > this.nc.getHeight()) {
            return false;
        }
        if (rectangle.x + rectangle.width < 0) {
            return false;
        }
        return rectangle.y + rectangle.height >= 0;
    }

    public void drawRestriction(ImageIcon imageIcon, Point point, double d, double d2, double d3, double d4, double d5, boolean bl) {
        ImageIcon imageIcon2 = ImageProvider.createRotatedImage(null, imageIcon, d5);
        ImageIcon imageIcon3 = new ImageIcon(imageIcon2.getImage().getScaledInstance(16, 16, 4));
        int n = imageIcon3.getIconWidth();
        int n2 = imageIcon3.getIconHeight();
        imageIcon3.paintIcon(this.nc, this.g, (int)((double)point.x + d + d2) - n / 2, (int)((double)point.y + d3 + d4) - n2 / 2);
        if (bl) {
            this.g.setColor(this.relationSelectedColor);
            this.g.drawRect((int)((double)point.x + d + d2) - n / 2 - 2, (int)((double)point.y + d3 + d4) - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawRestriction(Relation relation, NodeElemStyle nodeElemStyle) {
        void var7_13;
        Object object;
        Object object2;
        Object object3;
        Way way = null;
        OsmPrimitive osmPrimitive = null;
        Object object4 = null;
        for (RelationMember primitiveId2 : relation.getMembers()) {
            if (primitiveId2.getMember().isIncomplete()) {
                return;
            }
            if (primitiveId2.isWay()) {
                object3 = primitiveId2.getWay();
                if (((Way)object3).getNodesCount() < 2) continue;
                if ("from".equals(primitiveId2.getRole())) {
                    if (way != null) continue;
                    way = object3;
                    continue;
                }
                if ("to".equals(primitiveId2.getRole())) {
                    if (osmPrimitive != null) continue;
                    osmPrimitive = object3;
                    continue;
                }
                if (!"via".equals(primitiveId2.getRole()) || object4 != null) continue;
                object4 = object3;
                continue;
            }
            if (!primitiveId2.isNode()) continue;
            object3 = primitiveId2.getNode();
            if (!"via".equals(primitiveId2.getRole()) || object4 != null) continue;
            object4 = object3;
        }
        if (way == null || osmPrimitive == null || object4 == null) {
            return;
        }
        if (object4 instanceof Node) {
            object2 = (Node)object4;
            if (!way.isFirstLastNode((Node)object2)) {
                return;
            }
        } else {
            Way way2 = (Way)object4;
            object3 = way2.firstNode();
            object = way2.lastNode();
            Boolean bl = false;
            String string = way2.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl = true;
                    Object object5 = object3;
                    object3 = object;
                    object = object5;
                } else {
                    bl = OsmUtils.getOsmBoolean(string);
                    if (bl == null) {
                        bl = false;
                    }
                }
            }
            if (way.isFirstLastNode((Node)object3)) {
                object2 = object3;
            } else if (!bl.booleanValue() && way.isFirstLastNode((Node)object)) {
                object2 = object;
            } else {
                return;
            }
        }
        Object var7_10 = null;
        if (way.firstNode() == object4) {
            Node node = way.getNode(1);
        } else {
            Node node = way.getNode(way.getNodesCount() - 2);
        }
        object3 = this.nc.getPoint((Node)var7_13);
        object = this.nc.getPoint((Node)object2);
        double d = 14.0;
        double d2 = ((Point)object3).x >= ((Point)object).x ? (double)(((Point)object3).x - ((Point)object).x) : (double)(((Point)object).x - ((Point)object3).x);
        double d3 = ((Point)object3).y >= ((Point)object).y ? (double)(((Point)object3).y - ((Point)object).y) : (double)(((Point)object).y - ((Point)object3).y);
        double d4 = d2 == 0.0 ? 1.5707963267948966 : Math.atan(d3 / d2);
        double d5 = Math.toDegrees(d4);
        double d6 = d * Math.cos(d4);
        double d7 = d * Math.sin(d4);
        if (((Point)object3).x < ((Point)object).x) {
            d6 = -d6;
        }
        if (((Point)object3).y < ((Point)object).y) {
            d7 = -d7;
        }
        double d8 = 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            }
            d11 = 270.0 + d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            }
            d11 = 90.0 - d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            }
            d11 = 90.0 + d5;
        }
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            }
            d11 = 270.0 - d5;
        }
        this.drawRestriction(this.inactive || relation.isDisabled() ? nodeElemStyle.getDisabledIcon() : nodeElemStyle.icon, (Point)object, d6, d9, d7, d10, d11, relation.isSelected());
    }

    public void drawVirtualNodes(Collection<Way> collection) {
        if (this.virtualNodeSize != 0) {
            GeneralPath generalPath = new GeneralPath();
            for (Way way : collection) {
                if (!way.isUsable() || way.isDisabled()) continue;
                this.visitVirtual(generalPath, way);
            }
            this.g.setColor(this.nodeColor);
            this.g.draw(generalPath);
        }
    }

    public void visitVirtual(GeneralPath generalPath, Way way) {
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                if (this.isSegmentVisible(point, point2) && MapPainter.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                    int n = (point2.x + point.x) / 2;
                    int n2 = (point2.y + point.y) / 2;
                    generalPath.moveTo(n - this.virtualNodeSize, n2);
                    generalPath.lineTo(n + this.virtualNodeSize, n2);
                    generalPath.moveTo(n, n2 - this.virtualNodeSize);
                    generalPath.lineTo(n, n2 + this.virtualNodeSize);
                }
                point = point2;
            }
        }
    }

    private static boolean isLargeSegment(Point point, Point point2, int n) {
        int n2;
        int n3 = point.x - point2.x;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = point.y - point2.y) < 0) {
            n2 = -n2;
        }
        return n3 + n2 > n;
    }

    public void drawOrderNumber(Node node, Node node2, int n, Color color) {
        Point point = this.nc.getPoint(node);
        Point point2 = this.nc.getPoint(node2);
        this.drawOrderNumber(point, point2, n, color);
    }

    protected void drawOrderNumber(Point point, Point point2, int n, Color color) {
        if (this.isSegmentVisible(point, point2) && MapPainter.isLargeSegment(point, point2, this.segmentNumberSpace)) {
            String string = Integer.toString(n);
            int n2 = string.length();
            int n3 = (point.x + point2.x) / 2 - 4 * n2;
            int n4 = (point.y + point2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && MapPainter.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                n4 = (point.y + point2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(n3 - 1, n4 - 12, 8 * n2 + 1, 14);
            this.g.setColor(color);
            this.g.drawString(string, n3, n4);
        }
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public double getCircum() {
        return this.circum;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }
}

