/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.Pair;

public class MapPaintVisitor
implements PaintVisitor {
    private Graphics2D g;
    private boolean inactive;
    private NavigatableComponent nc;
    private ElemStyles styles;
    private double circum;
    private MapPainter painter;
    private MapPaintSettings paintSettings;
    private DataSet data;
    private static final Comparator<Pair<ElemStyle, OsmPrimitive>> STYLE_COMPARATOR = new Comparator<Pair<ElemStyle, OsmPrimitive>>(){

        @Override
        public int compare(Pair<ElemStyle, OsmPrimitive> pair, Pair<ElemStyle, OsmPrimitive> pair2) {
            int n = Float.compare(((ElemStyle)pair.a).z_index, ((ElemStyle)pair2.a).z_index);
            if (n != 0) {
                return n;
            }
            if (pair.a == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && pair2.a != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return 1;
            }
            if (pair.a != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && pair2.a == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return -1;
            }
            long l = ((OsmPrimitive)pair.b).getUniqueId() - ((OsmPrimitive)pair2.b).getUniqueId();
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return Float.compare(((ElemStyle)pair.a).object_z_index, ((ElemStyle)pair2.a).object_z_index);
        }
    };

    public void visitAll(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = new BBox(bounds);
        this.data = dataSet;
        this.styles = MapPaintStyles.getStyles();
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        boolean bl2 = this.circum <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000);
        boolean bl3 = bl2 && Main.pref.getBoolean("mappaint.multipolygon", true);
        this.styles.setDrawMultipolygon(bl3);
        boolean bl4 = Main.pref.getBoolean("mappaint.restriction", true);
        boolean bl5 = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", true) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.painter = new MapPainter(this.paintSettings, this.g, this.inactive, this.nc, bl, this.circum, bl5);
        StyleCollector styleCollector = new StyleCollector(false, false, bl4, false);
        StyleCollector styleCollector2 = new StyleCollector(bl2, bl3, bl4, false);
        StyleCollector styleCollector3 = new StyleCollector(bl2, bl3, bl4, true);
        StyleCollector styleCollector4 = new StyleCollector(bl2, bl3, bl4, false);
        for (Node osmPrimitive : dataSet.searchNodes(bBox)) {
            if (!osmPrimitive.isDrawable()) continue;
            if (osmPrimitive.isDisabled()) {
                styleCollector.add(osmPrimitive);
                continue;
            }
            if (osmPrimitive.isSelected()) {
                styleCollector2.add(osmPrimitive);
                continue;
            }
            if (osmPrimitive.isMemberOfSelected()) {
                styleCollector3.add(osmPrimitive);
                continue;
            }
            styleCollector4.add(osmPrimitive);
        }
        for (Way way : dataSet.searchWays(bBox)) {
            if (!way.isDrawable()) continue;
            if (way.isDisabled()) {
                styleCollector.add(way);
                continue;
            }
            if (way.isSelected()) {
                styleCollector2.add(way);
                continue;
            }
            if (way.isMemberOfSelected()) {
                styleCollector3.add(way);
                continue;
            }
            styleCollector4.add(way);
        }
        for (Relation relation : dataSet.searchRelations(bBox)) {
            if (!relation.isDrawable()) continue;
            if (relation.isDisabled()) {
                styleCollector.add(relation);
                continue;
            }
            if (relation.isSelected()) {
                styleCollector2.add(relation);
                continue;
            }
            styleCollector4.add(relation);
        }
        styleCollector.drawAll();
        styleCollector = null;
        styleCollector4.drawAll();
        styleCollector4 = null;
        styleCollector3.drawAll();
        styleCollector3 = null;
        styleCollector2.drawAll();
        styleCollector2 = null;
        this.painter.drawVirtualNodes(dataSet.searchWays(bBox));
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public void setInactive(boolean bl) {
        this.inactive = bl;
    }

    public void setNavigatableComponent(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }

    private class StyleCollector {
        private final boolean drawArea;
        private final boolean drawMultipolygon;
        private final boolean drawRestriction;
        private final boolean memberSelected;
        private final List<Pair<ElemStyle, OsmPrimitive>> styleElems;

        public StyleCollector(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.drawArea = bl;
            this.drawMultipolygon = bl2;
            this.drawRestriction = bl3;
            this.memberSelected = bl4;
            this.styleElems = new ArrayList<Pair<ElemStyle, OsmPrimitive>>();
        }

        public void add(Node node) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(node, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                this.styleElems.add(new Pair<ElemStyle, Node>(elemStyle, node));
            }
        }

        public void add(Way way) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(way, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if (!this.drawArea && elemStyle instanceof AreaElemStyle) continue;
                this.styleElems.add(new Pair<ElemStyle, Way>(elemStyle, way));
            }
        }

        public void add(Relation relation) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(relation, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if (this.drawMultipolygon && this.drawArea && elemStyle instanceof AreaElemStyle) {
                    this.styleElems.add(new Pair<ElemStyle, Relation>(elemStyle, relation));
                    continue;
                }
                if (!this.drawRestriction || !(elemStyle instanceof NodeElemStyle)) continue;
                this.styleElems.add(new Pair<ElemStyle, Relation>(elemStyle, relation));
            }
        }

        public void drawAll() {
            Collections.sort(this.styleElems, STYLE_COMPARATOR);
            for (Pair<ElemStyle, OsmPrimitive> pair : this.styleElems) {
                ((ElemStyle)pair.a).paintPrimitive((OsmPrimitive)pair.b, MapPaintVisitor.this.paintSettings, MapPaintVisitor.this.painter, MapPaintVisitor.this.data.isSelected((OsmPrimitive)pair.b), this.memberSelected);
            }
        }
    }
}

