/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateUploadHook
implements UploadHook {
    private static final long serialVersionUID = -2304521273582574603L;

    @Override
    public boolean checkUpload(APIDataSet aPIDataSet) {
        Collection<Test> collection = OsmValidator.getEnabledTests(true);
        if (collection.isEmpty()) {
            return true;
        }
        AgregatePrimitivesVisitor agregatePrimitivesVisitor = new AgregatePrimitivesVisitor();
        agregatePrimitivesVisitor.visit(aPIDataSet.getPrimitivesToAdd());
        Collection<OsmPrimitive> collection2 = agregatePrimitivesVisitor.visit(aPIDataSet.getPrimitivesToUpdate());
        ArrayList<TestError> arrayList = new ArrayList<TestError>(30);
        for (Test object : collection) {
            object.setBeforeUpload(true);
            object.setPartialSelection(true);
            object.startTest(null);
            object.visit(collection2);
            object.endTest();
            if (Main.pref.getBoolean("validator.other", false) && Main.pref.getBoolean("validator.otherUpload", false)) {
                arrayList.addAll(object.getErrors());
                continue;
            }
            for (TestError testError : object.getErrors()) {
                if (testError.getSeverity() == Severity.OTHER) continue;
                arrayList.add(testError);
            }
        }
        collection = null;
        if (arrayList == null || arrayList.isEmpty()) {
            return true;
        }
        if (Main.pref.getBoolean("validator.ignore", true)) {
            int n = 0;
            for (TestError testError : arrayList) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(testError.getIgnoreState());
                arrayList2.add(testError.getIgnoreGroup());
                arrayList2.add(testError.getIgnoreSubGroup());
                for (String string : arrayList2) {
                    if (string == null || !OsmValidator.hasIgnoredError(string)) continue;
                    testError.setIgnored(true);
                }
                if (testError.getIgnored().booleanValue()) continue;
                ++n;
            }
            if (n == 0) {
                return true;
            }
        }
        return this.displayErrorScreen(arrayList);
    }

    private boolean displayErrorScreen(List<TestError> list) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ValidatorTreePanel validatorTreePanel = new ValidatorTreePanel(list);
        validatorTreePanel.expandAll();
        jPanel.add((Component)new JScrollPane(validatorTreePanel), GBC.eol());
        int n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Data with errors. Upload anyway?"), 0, 3);
        if (n == 1) {
            OsmValidator.initializeErrorLayer();
            Main.map.validatorDialog.unfurlDialog();
            Main.map.validatorDialog.tree.setErrors(list);
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
        return n == 0;
    }
}

